/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.DataSourceParameters;
import software.amazon.awssdk.services.quicksight.model.DataSourceParametersListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CredentialPair
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CredentialPair> {
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Username").getter(CredentialPair.getter(CredentialPair::username)).setter(CredentialPair.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()}).build();
    private static final SdkField<String> PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Password").getter(CredentialPair.getter(CredentialPair::password)).setter(CredentialPair.setter(Builder::password)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()}).build();
    private static final SdkField<List<DataSourceParameters>> ALTERNATE_DATA_SOURCE_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AlternateDataSourceParameters").getter(CredentialPair.getter(CredentialPair::alternateDataSourceParameters)).setter(CredentialPair.setter(Builder::alternateDataSourceParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlternateDataSourceParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSourceParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USERNAME_FIELD, PASSWORD_FIELD, ALTERNATE_DATA_SOURCE_PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CredentialPair.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String username;
    private final String password;
    private final List<DataSourceParameters> alternateDataSourceParameters;

    private CredentialPair(BuilderImpl builder) {
        this.username = builder.username;
        this.password = builder.password;
        this.alternateDataSourceParameters = builder.alternateDataSourceParameters;
    }

    public final String username() {
        return this.username;
    }

    public final String password() {
        return this.password;
    }

    public final boolean hasAlternateDataSourceParameters() {
        return this.alternateDataSourceParameters != null && !(this.alternateDataSourceParameters instanceof SdkAutoConstructList);
    }

    public final List<DataSourceParameters> alternateDataSourceParameters() {
        return this.alternateDataSourceParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.password());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAlternateDataSourceParameters() ? this.alternateDataSourceParameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CredentialPair)) {
            return false;
        }
        CredentialPair other = (CredentialPair)obj;
        return Objects.equals(this.username(), other.username()) && Objects.equals(this.password(), other.password()) && this.hasAlternateDataSourceParameters() == other.hasAlternateDataSourceParameters() && Objects.equals(this.alternateDataSourceParameters(), other.alternateDataSourceParameters());
    }

    public final String toString() {
        return ToString.builder((String)"CredentialPair").add("Username", (Object)this.username()).add("Password", (Object)this.password()).add("AlternateDataSourceParameters", this.hasAlternateDataSourceParameters() ? this.alternateDataSourceParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "Password": {
                return Optional.ofNullable(clazz.cast(this.password()));
            }
            case "AlternateDataSourceParameters": {
                return Optional.ofNullable(clazz.cast(this.alternateDataSourceParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Username", USERNAME_FIELD);
        map.put("Password", PASSWORD_FIELD);
        map.put("AlternateDataSourceParameters", ALTERNATE_DATA_SOURCE_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CredentialPair, T> g) {
        return obj -> g.apply((CredentialPair)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String username;
        private String password;
        private List<DataSourceParameters> alternateDataSourceParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CredentialPair model) {
            this.username(model.username);
            this.password(model.password);
            this.alternateDataSourceParameters(model.alternateDataSourceParameters);
        }

        public final String getUsername() {
            return this.username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final String getPassword() {
            return this.password;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final List<DataSourceParameters.Builder> getAlternateDataSourceParameters() {
            List<DataSourceParameters.Builder> result = DataSourceParametersListCopier.copyToBuilder(this.alternateDataSourceParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAlternateDataSourceParameters(Collection<DataSourceParameters.BuilderImpl> alternateDataSourceParameters) {
            this.alternateDataSourceParameters = DataSourceParametersListCopier.copyFromBuilder(alternateDataSourceParameters);
        }

        @Override
        public final Builder alternateDataSourceParameters(Collection<DataSourceParameters> alternateDataSourceParameters) {
            this.alternateDataSourceParameters = DataSourceParametersListCopier.copy(alternateDataSourceParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alternateDataSourceParameters(DataSourceParameters ... alternateDataSourceParameters) {
            this.alternateDataSourceParameters(Arrays.asList(alternateDataSourceParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alternateDataSourceParameters(Consumer<DataSourceParameters.Builder> ... alternateDataSourceParameters) {
            this.alternateDataSourceParameters(Stream.of(alternateDataSourceParameters).map(c -> (DataSourceParameters)((DataSourceParameters.Builder)DataSourceParameters.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CredentialPair build() {
            return new CredentialPair(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CredentialPair> {
        public Builder username(String var1);

        public Builder password(String var1);

        public Builder alternateDataSourceParameters(Collection<DataSourceParameters> var1);

        public Builder alternateDataSourceParameters(DataSourceParameters ... var1);

        public Builder alternateDataSourceParameters(Consumer<DataSourceParameters.Builder> ... var1);
    }
}

