/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.DatabaseGroupListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RedshiftIAMParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RedshiftIAMParameters> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(RedshiftIAMParameters.getter(RedshiftIAMParameters::roleArn)).setter(RedshiftIAMParameters.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> DATABASE_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseUser").getter(RedshiftIAMParameters.getter(RedshiftIAMParameters::databaseUser)).setter(RedshiftIAMParameters.setter(Builder::databaseUser)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseUser").build()}).build();
    private static final SdkField<List<String>> DATABASE_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DatabaseGroups").getter(RedshiftIAMParameters.getter(RedshiftIAMParameters::databaseGroups)).setter(RedshiftIAMParameters.setter(Builder::databaseGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> AUTO_CREATE_DATABASE_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoCreateDatabaseUser").getter(RedshiftIAMParameters.getter(RedshiftIAMParameters::autoCreateDatabaseUser)).setter(RedshiftIAMParameters.setter(Builder::autoCreateDatabaseUser)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoCreateDatabaseUser").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, DATABASE_USER_FIELD, DATABASE_GROUPS_FIELD, AUTO_CREATE_DATABASE_USER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RedshiftIAMParameters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String roleArn;
    private final String databaseUser;
    private final List<String> databaseGroups;
    private final Boolean autoCreateDatabaseUser;

    private RedshiftIAMParameters(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.databaseUser = builder.databaseUser;
        this.databaseGroups = builder.databaseGroups;
        this.autoCreateDatabaseUser = builder.autoCreateDatabaseUser;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String databaseUser() {
        return this.databaseUser;
    }

    public final boolean hasDatabaseGroups() {
        return this.databaseGroups != null && !(this.databaseGroups instanceof SdkAutoConstructList);
    }

    public final List<String> databaseGroups() {
        return this.databaseGroups;
    }

    public final Boolean autoCreateDatabaseUser() {
        return this.autoCreateDatabaseUser;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDatabaseGroups() ? this.databaseGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.autoCreateDatabaseUser());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftIAMParameters)) {
            return false;
        }
        RedshiftIAMParameters other = (RedshiftIAMParameters)obj;
        return Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.databaseUser(), other.databaseUser()) && this.hasDatabaseGroups() == other.hasDatabaseGroups() && Objects.equals(this.databaseGroups(), other.databaseGroups()) && Objects.equals(this.autoCreateDatabaseUser(), other.autoCreateDatabaseUser());
    }

    public final String toString() {
        return ToString.builder((String)"RedshiftIAMParameters").add("RoleArn", (Object)this.roleArn()).add("DatabaseUser", (Object)this.databaseUser()).add("DatabaseGroups", this.hasDatabaseGroups() ? this.databaseGroups() : null).add("AutoCreateDatabaseUser", (Object)this.autoCreateDatabaseUser()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "DatabaseUser": {
                return Optional.ofNullable(clazz.cast(this.databaseUser()));
            }
            case "DatabaseGroups": {
                return Optional.ofNullable(clazz.cast(this.databaseGroups()));
            }
            case "AutoCreateDatabaseUser": {
                return Optional.ofNullable(clazz.cast(this.autoCreateDatabaseUser()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("DatabaseUser", DATABASE_USER_FIELD);
        map.put("DatabaseGroups", DATABASE_GROUPS_FIELD);
        map.put("AutoCreateDatabaseUser", AUTO_CREATE_DATABASE_USER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RedshiftIAMParameters, T> g) {
        return obj -> g.apply((RedshiftIAMParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleArn;
        private String databaseUser;
        private List<String> databaseGroups = DefaultSdkAutoConstructList.getInstance();
        private Boolean autoCreateDatabaseUser;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftIAMParameters model) {
            this.roleArn(model.roleArn);
            this.databaseUser(model.databaseUser);
            this.databaseGroups(model.databaseGroups);
            this.autoCreateDatabaseUser(model.autoCreateDatabaseUser);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getDatabaseUser() {
            return this.databaseUser;
        }

        public final void setDatabaseUser(String databaseUser) {
            this.databaseUser = databaseUser;
        }

        @Override
        public final Builder databaseUser(String databaseUser) {
            this.databaseUser = databaseUser;
            return this;
        }

        public final Collection<String> getDatabaseGroups() {
            if (this.databaseGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.databaseGroups;
        }

        public final void setDatabaseGroups(Collection<String> databaseGroups) {
            this.databaseGroups = DatabaseGroupListCopier.copy(databaseGroups);
        }

        @Override
        public final Builder databaseGroups(Collection<String> databaseGroups) {
            this.databaseGroups = DatabaseGroupListCopier.copy(databaseGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder databaseGroups(String ... databaseGroups) {
            this.databaseGroups(Arrays.asList(databaseGroups));
            return this;
        }

        public final Boolean getAutoCreateDatabaseUser() {
            return this.autoCreateDatabaseUser;
        }

        public final void setAutoCreateDatabaseUser(Boolean autoCreateDatabaseUser) {
            this.autoCreateDatabaseUser = autoCreateDatabaseUser;
        }

        @Override
        public final Builder autoCreateDatabaseUser(Boolean autoCreateDatabaseUser) {
            this.autoCreateDatabaseUser = autoCreateDatabaseUser;
            return this;
        }

        public RedshiftIAMParameters build() {
            return new RedshiftIAMParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RedshiftIAMParameters> {
        public Builder roleArn(String var1);

        public Builder databaseUser(String var1);

        public Builder databaseGroups(Collection<String> var1);

        public Builder databaseGroups(String ... var1);

        public Builder autoCreateDatabaseUser(Boolean var1);
    }
}

