/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.ColumnSort;
import software.amazon.awssdk.services.quicksight.model.FieldSort;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FieldSortOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FieldSortOptions> {
    private static final SdkField<FieldSort> FIELD_SORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FieldSort").getter(FieldSortOptions.getter(FieldSortOptions::fieldSort)).setter(FieldSortOptions.setter(Builder::fieldSort)).constructor(FieldSort::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldSort").build()}).build();
    private static final SdkField<ColumnSort> COLUMN_SORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ColumnSort").getter(FieldSortOptions.getter(FieldSortOptions::columnSort)).setter(FieldSortOptions.setter(Builder::columnSort)).constructor(ColumnSort::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnSort").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_SORT_FIELD, COLUMN_SORT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FieldSortOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final FieldSort fieldSort;
    private final ColumnSort columnSort;

    private FieldSortOptions(BuilderImpl builder) {
        this.fieldSort = builder.fieldSort;
        this.columnSort = builder.columnSort;
    }

    public final FieldSort fieldSort() {
        return this.fieldSort;
    }

    public final ColumnSort columnSort() {
        return this.columnSort;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldSort());
        hashCode = 31 * hashCode + Objects.hashCode(this.columnSort());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldSortOptions)) {
            return false;
        }
        FieldSortOptions other = (FieldSortOptions)obj;
        return Objects.equals(this.fieldSort(), other.fieldSort()) && Objects.equals(this.columnSort(), other.columnSort());
    }

    public final String toString() {
        return ToString.builder((String)"FieldSortOptions").add("FieldSort", (Object)this.fieldSort()).add("ColumnSort", (Object)this.columnSort()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FieldSort": {
                return Optional.ofNullable(clazz.cast(this.fieldSort()));
            }
            case "ColumnSort": {
                return Optional.ofNullable(clazz.cast(this.columnSort()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FieldSort", FIELD_SORT_FIELD);
        map.put("ColumnSort", COLUMN_SORT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FieldSortOptions, T> g) {
        return obj -> g.apply((FieldSortOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private FieldSort fieldSort;
        private ColumnSort columnSort;

        private BuilderImpl() {
        }

        private BuilderImpl(FieldSortOptions model) {
            this.fieldSort(model.fieldSort);
            this.columnSort(model.columnSort);
        }

        public final FieldSort.Builder getFieldSort() {
            return this.fieldSort != null ? this.fieldSort.toBuilder() : null;
        }

        public final void setFieldSort(FieldSort.BuilderImpl fieldSort) {
            this.fieldSort = fieldSort != null ? fieldSort.build() : null;
        }

        @Override
        public final Builder fieldSort(FieldSort fieldSort) {
            this.fieldSort = fieldSort;
            return this;
        }

        public final ColumnSort.Builder getColumnSort() {
            return this.columnSort != null ? this.columnSort.toBuilder() : null;
        }

        public final void setColumnSort(ColumnSort.BuilderImpl columnSort) {
            this.columnSort = columnSort != null ? columnSort.build() : null;
        }

        @Override
        public final Builder columnSort(ColumnSort columnSort) {
            this.columnSort = columnSort;
            return this;
        }

        public FieldSortOptions build() {
            return new FieldSortOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FieldSortOptions> {
        public Builder fieldSort(FieldSort var1);

        default public Builder fieldSort(Consumer<FieldSort.Builder> fieldSort) {
            return this.fieldSort((FieldSort)((FieldSort.Builder)FieldSort.builder().applyMutation(fieldSort)).build());
        }

        public Builder columnSort(ColumnSort var1);

        default public Builder columnSort(Consumer<ColumnSort.Builder> columnSort) {
            return this.columnSort((ColumnSort)((ColumnSort.Builder)ColumnSort.builder().applyMutation(columnSort)).build());
        }
    }
}

