/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.SnapshotFileFormatType;
import software.amazon.awssdk.services.quicksight.model.SnapshotFileSheetSelection;
import software.amazon.awssdk.services.quicksight.model.SnapshotFileSheetSelectionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SnapshotFile
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SnapshotFile> {
    private static final SdkField<List<SnapshotFileSheetSelection>> SHEET_SELECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SheetSelections").getter(SnapshotFile.getter(SnapshotFile::sheetSelections)).setter(SnapshotFile.setter(Builder::sheetSelections)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SheetSelections").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SnapshotFileSheetSelection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FORMAT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FormatType").getter(SnapshotFile.getter(SnapshotFile::formatTypeAsString)).setter(SnapshotFile.setter(Builder::formatType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FormatType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHEET_SELECTIONS_FIELD, FORMAT_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SnapshotFile.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<SnapshotFileSheetSelection> sheetSelections;
    private final String formatType;

    private SnapshotFile(BuilderImpl builder) {
        this.sheetSelections = builder.sheetSelections;
        this.formatType = builder.formatType;
    }

    public final boolean hasSheetSelections() {
        return this.sheetSelections != null && !(this.sheetSelections instanceof SdkAutoConstructList);
    }

    public final List<SnapshotFileSheetSelection> sheetSelections() {
        return this.sheetSelections;
    }

    public final SnapshotFileFormatType formatType() {
        return SnapshotFileFormatType.fromValue(this.formatType);
    }

    public final String formatTypeAsString() {
        return this.formatType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSheetSelections() ? this.sheetSelections() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.formatTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapshotFile)) {
            return false;
        }
        SnapshotFile other = (SnapshotFile)obj;
        return this.hasSheetSelections() == other.hasSheetSelections() && Objects.equals(this.sheetSelections(), other.sheetSelections()) && Objects.equals(this.formatTypeAsString(), other.formatTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SnapshotFile").add("SheetSelections", this.hasSheetSelections() ? this.sheetSelections() : null).add("FormatType", (Object)this.formatTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SheetSelections": {
                return Optional.ofNullable(clazz.cast(this.sheetSelections()));
            }
            case "FormatType": {
                return Optional.ofNullable(clazz.cast(this.formatTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SheetSelections", SHEET_SELECTIONS_FIELD);
        map.put("FormatType", FORMAT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SnapshotFile, T> g) {
        return obj -> g.apply((SnapshotFile)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<SnapshotFileSheetSelection> sheetSelections = DefaultSdkAutoConstructList.getInstance();
        private String formatType;

        private BuilderImpl() {
        }

        private BuilderImpl(SnapshotFile model) {
            this.sheetSelections(model.sheetSelections);
            this.formatType(model.formatType);
        }

        public final List<SnapshotFileSheetSelection.Builder> getSheetSelections() {
            List<SnapshotFileSheetSelection.Builder> result = SnapshotFileSheetSelectionListCopier.copyToBuilder(this.sheetSelections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSheetSelections(Collection<SnapshotFileSheetSelection.BuilderImpl> sheetSelections) {
            this.sheetSelections = SnapshotFileSheetSelectionListCopier.copyFromBuilder(sheetSelections);
        }

        @Override
        public final Builder sheetSelections(Collection<SnapshotFileSheetSelection> sheetSelections) {
            this.sheetSelections = SnapshotFileSheetSelectionListCopier.copy(sheetSelections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sheetSelections(SnapshotFileSheetSelection ... sheetSelections) {
            this.sheetSelections(Arrays.asList(sheetSelections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sheetSelections(Consumer<SnapshotFileSheetSelection.Builder> ... sheetSelections) {
            this.sheetSelections(Stream.of(sheetSelections).map(c -> (SnapshotFileSheetSelection)((SnapshotFileSheetSelection.Builder)SnapshotFileSheetSelection.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getFormatType() {
            return this.formatType;
        }

        public final void setFormatType(String formatType) {
            this.formatType = formatType;
        }

        @Override
        public final Builder formatType(String formatType) {
            this.formatType = formatType;
            return this;
        }

        @Override
        public final Builder formatType(SnapshotFileFormatType formatType) {
            this.formatType(formatType == null ? null : formatType.toString());
            return this;
        }

        public SnapshotFile build() {
            return new SnapshotFile(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SnapshotFile> {
        public Builder sheetSelections(Collection<SnapshotFileSheetSelection> var1);

        public Builder sheetSelections(SnapshotFileSheetSelection ... var1);

        public Builder sheetSelections(Consumer<SnapshotFileSheetSelection.Builder> ... var1);

        public Builder formatType(String var1);

        public Builder formatType(SnapshotFileFormatType var1);
    }
}

