/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.quicksight.model.AggregationFunctionParametersCopier;
import software.amazon.awssdk.services.quicksight.model.NamedEntityAggType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NamedEntityDefinitionMetric
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NamedEntityDefinitionMetric> {
    private static final SdkField<String> AGGREGATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Aggregation").getter(NamedEntityDefinitionMetric.getter(NamedEntityDefinitionMetric::aggregationAsString)).setter(NamedEntityDefinitionMetric.setter(Builder::aggregation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aggregation").build()}).build();
    private static final SdkField<Map<String, String>> AGGREGATION_FUNCTION_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("AggregationFunctionParameters").getter(NamedEntityDefinitionMetric.getter(NamedEntityDefinitionMetric::aggregationFunctionParameters)).setter(NamedEntityDefinitionMetric.setter(Builder::aggregationFunctionParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregationFunctionParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGGREGATION_FIELD, AGGREGATION_FUNCTION_PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NamedEntityDefinitionMetric.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String aggregation;
    private final Map<String, String> aggregationFunctionParameters;

    private NamedEntityDefinitionMetric(BuilderImpl builder) {
        this.aggregation = builder.aggregation;
        this.aggregationFunctionParameters = builder.aggregationFunctionParameters;
    }

    public final NamedEntityAggType aggregation() {
        return NamedEntityAggType.fromValue(this.aggregation);
    }

    public final String aggregationAsString() {
        return this.aggregation;
    }

    public final boolean hasAggregationFunctionParameters() {
        return this.aggregationFunctionParameters != null && !(this.aggregationFunctionParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> aggregationFunctionParameters() {
        return this.aggregationFunctionParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAggregationFunctionParameters() ? this.aggregationFunctionParameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NamedEntityDefinitionMetric)) {
            return false;
        }
        NamedEntityDefinitionMetric other = (NamedEntityDefinitionMetric)obj;
        return Objects.equals(this.aggregationAsString(), other.aggregationAsString()) && this.hasAggregationFunctionParameters() == other.hasAggregationFunctionParameters() && Objects.equals(this.aggregationFunctionParameters(), other.aggregationFunctionParameters());
    }

    public final String toString() {
        return ToString.builder((String)"NamedEntityDefinitionMetric").add("Aggregation", (Object)this.aggregationAsString()).add("AggregationFunctionParameters", this.hasAggregationFunctionParameters() ? this.aggregationFunctionParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Aggregation": {
                return Optional.ofNullable(clazz.cast(this.aggregationAsString()));
            }
            case "AggregationFunctionParameters": {
                return Optional.ofNullable(clazz.cast(this.aggregationFunctionParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Aggregation", AGGREGATION_FIELD);
        map.put("AggregationFunctionParameters", AGGREGATION_FUNCTION_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NamedEntityDefinitionMetric, T> g) {
        return obj -> g.apply((NamedEntityDefinitionMetric)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String aggregation;
        private Map<String, String> aggregationFunctionParameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NamedEntityDefinitionMetric model) {
            this.aggregation(model.aggregation);
            this.aggregationFunctionParameters(model.aggregationFunctionParameters);
        }

        public final String getAggregation() {
            return this.aggregation;
        }

        public final void setAggregation(String aggregation) {
            this.aggregation = aggregation;
        }

        @Override
        public final Builder aggregation(String aggregation) {
            this.aggregation = aggregation;
            return this;
        }

        @Override
        public final Builder aggregation(NamedEntityAggType aggregation) {
            this.aggregation(aggregation == null ? null : aggregation.toString());
            return this;
        }

        public final Map<String, String> getAggregationFunctionParameters() {
            if (this.aggregationFunctionParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.aggregationFunctionParameters;
        }

        public final void setAggregationFunctionParameters(Map<String, String> aggregationFunctionParameters) {
            this.aggregationFunctionParameters = AggregationFunctionParametersCopier.copy(aggregationFunctionParameters);
        }

        @Override
        public final Builder aggregationFunctionParameters(Map<String, String> aggregationFunctionParameters) {
            this.aggregationFunctionParameters = AggregationFunctionParametersCopier.copy(aggregationFunctionParameters);
            return this;
        }

        public NamedEntityDefinitionMetric build() {
            return new NamedEntityDefinitionMetric(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NamedEntityDefinitionMetric> {
        public Builder aggregation(String var1);

        public Builder aggregation(NamedEntityAggType var1);

        public Builder aggregationFunctionParameters(Map<String, String> var1);
    }
}

