/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.IntegerDefaultValues;
import software.amazon.awssdk.services.quicksight.model.IntegerValueWhenUnsetConfiguration;
import software.amazon.awssdk.services.quicksight.model.MappedDataSetParameter;
import software.amazon.awssdk.services.quicksight.model.MappedDataSetParametersCopier;
import software.amazon.awssdk.services.quicksight.model.ParameterValueType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IntegerParameterDeclaration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IntegerParameterDeclaration> {
    private static final SdkField<String> PARAMETER_VALUE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParameterValueType").getter(IntegerParameterDeclaration.getter(IntegerParameterDeclaration::parameterValueTypeAsString)).setter(IntegerParameterDeclaration.setter(Builder::parameterValueType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterValueType").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(IntegerParameterDeclaration.getter(IntegerParameterDeclaration::name)).setter(IntegerParameterDeclaration.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<IntegerDefaultValues> DEFAULT_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultValues").getter(IntegerParameterDeclaration.getter(IntegerParameterDeclaration::defaultValues)).setter(IntegerParameterDeclaration.setter(Builder::defaultValues)).constructor(IntegerDefaultValues::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValues").build()}).build();
    private static final SdkField<IntegerValueWhenUnsetConfiguration> VALUE_WHEN_UNSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ValueWhenUnset").getter(IntegerParameterDeclaration.getter(IntegerParameterDeclaration::valueWhenUnset)).setter(IntegerParameterDeclaration.setter(Builder::valueWhenUnset)).constructor(IntegerValueWhenUnsetConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueWhenUnset").build()}).build();
    private static final SdkField<List<MappedDataSetParameter>> MAPPED_DATA_SET_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MappedDataSetParameters").getter(IntegerParameterDeclaration.getter(IntegerParameterDeclaration::mappedDataSetParameters)).setter(IntegerParameterDeclaration.setter(Builder::mappedDataSetParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MappedDataSetParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MappedDataSetParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_VALUE_TYPE_FIELD, NAME_FIELD, DEFAULT_VALUES_FIELD, VALUE_WHEN_UNSET_FIELD, MAPPED_DATA_SET_PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IntegerParameterDeclaration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String parameterValueType;
    private final String name;
    private final IntegerDefaultValues defaultValues;
    private final IntegerValueWhenUnsetConfiguration valueWhenUnset;
    private final List<MappedDataSetParameter> mappedDataSetParameters;

    private IntegerParameterDeclaration(BuilderImpl builder) {
        this.parameterValueType = builder.parameterValueType;
        this.name = builder.name;
        this.defaultValues = builder.defaultValues;
        this.valueWhenUnset = builder.valueWhenUnset;
        this.mappedDataSetParameters = builder.mappedDataSetParameters;
    }

    public final ParameterValueType parameterValueType() {
        return ParameterValueType.fromValue(this.parameterValueType);
    }

    public final String parameterValueTypeAsString() {
        return this.parameterValueType;
    }

    public final String name() {
        return this.name;
    }

    public final IntegerDefaultValues defaultValues() {
        return this.defaultValues;
    }

    public final IntegerValueWhenUnsetConfiguration valueWhenUnset() {
        return this.valueWhenUnset;
    }

    public final boolean hasMappedDataSetParameters() {
        return this.mappedDataSetParameters != null && !(this.mappedDataSetParameters instanceof SdkAutoConstructList);
    }

    public final List<MappedDataSetParameter> mappedDataSetParameters() {
        return this.mappedDataSetParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterValueTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.valueWhenUnset());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMappedDataSetParameters() ? this.mappedDataSetParameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntegerParameterDeclaration)) {
            return false;
        }
        IntegerParameterDeclaration other = (IntegerParameterDeclaration)obj;
        return Objects.equals(this.parameterValueTypeAsString(), other.parameterValueTypeAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.defaultValues(), other.defaultValues()) && Objects.equals(this.valueWhenUnset(), other.valueWhenUnset()) && this.hasMappedDataSetParameters() == other.hasMappedDataSetParameters() && Objects.equals(this.mappedDataSetParameters(), other.mappedDataSetParameters());
    }

    public final String toString() {
        return ToString.builder((String)"IntegerParameterDeclaration").add("ParameterValueType", (Object)this.parameterValueTypeAsString()).add("Name", (Object)this.name()).add("DefaultValues", (Object)this.defaultValues()).add("ValueWhenUnset", (Object)this.valueWhenUnset()).add("MappedDataSetParameters", this.hasMappedDataSetParameters() ? this.mappedDataSetParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ParameterValueType": {
                return Optional.ofNullable(clazz.cast(this.parameterValueTypeAsString()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "DefaultValues": {
                return Optional.ofNullable(clazz.cast(this.defaultValues()));
            }
            case "ValueWhenUnset": {
                return Optional.ofNullable(clazz.cast(this.valueWhenUnset()));
            }
            case "MappedDataSetParameters": {
                return Optional.ofNullable(clazz.cast(this.mappedDataSetParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ParameterValueType", PARAMETER_VALUE_TYPE_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("DefaultValues", DEFAULT_VALUES_FIELD);
        map.put("ValueWhenUnset", VALUE_WHEN_UNSET_FIELD);
        map.put("MappedDataSetParameters", MAPPED_DATA_SET_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IntegerParameterDeclaration, T> g) {
        return obj -> g.apply((IntegerParameterDeclaration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String parameterValueType;
        private String name;
        private IntegerDefaultValues defaultValues;
        private IntegerValueWhenUnsetConfiguration valueWhenUnset;
        private List<MappedDataSetParameter> mappedDataSetParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IntegerParameterDeclaration model) {
            this.parameterValueType(model.parameterValueType);
            this.name(model.name);
            this.defaultValues(model.defaultValues);
            this.valueWhenUnset(model.valueWhenUnset);
            this.mappedDataSetParameters(model.mappedDataSetParameters);
        }

        public final String getParameterValueType() {
            return this.parameterValueType;
        }

        public final void setParameterValueType(String parameterValueType) {
            this.parameterValueType = parameterValueType;
        }

        @Override
        public final Builder parameterValueType(String parameterValueType) {
            this.parameterValueType = parameterValueType;
            return this;
        }

        @Override
        public final Builder parameterValueType(ParameterValueType parameterValueType) {
            this.parameterValueType(parameterValueType == null ? null : parameterValueType.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final IntegerDefaultValues.Builder getDefaultValues() {
            return this.defaultValues != null ? this.defaultValues.toBuilder() : null;
        }

        public final void setDefaultValues(IntegerDefaultValues.BuilderImpl defaultValues) {
            this.defaultValues = defaultValues != null ? defaultValues.build() : null;
        }

        @Override
        public final Builder defaultValues(IntegerDefaultValues defaultValues) {
            this.defaultValues = defaultValues;
            return this;
        }

        public final IntegerValueWhenUnsetConfiguration.Builder getValueWhenUnset() {
            return this.valueWhenUnset != null ? this.valueWhenUnset.toBuilder() : null;
        }

        public final void setValueWhenUnset(IntegerValueWhenUnsetConfiguration.BuilderImpl valueWhenUnset) {
            this.valueWhenUnset = valueWhenUnset != null ? valueWhenUnset.build() : null;
        }

        @Override
        public final Builder valueWhenUnset(IntegerValueWhenUnsetConfiguration valueWhenUnset) {
            this.valueWhenUnset = valueWhenUnset;
            return this;
        }

        public final List<MappedDataSetParameter.Builder> getMappedDataSetParameters() {
            List<MappedDataSetParameter.Builder> result = MappedDataSetParametersCopier.copyToBuilder(this.mappedDataSetParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMappedDataSetParameters(Collection<MappedDataSetParameter.BuilderImpl> mappedDataSetParameters) {
            this.mappedDataSetParameters = MappedDataSetParametersCopier.copyFromBuilder(mappedDataSetParameters);
        }

        @Override
        public final Builder mappedDataSetParameters(Collection<MappedDataSetParameter> mappedDataSetParameters) {
            this.mappedDataSetParameters = MappedDataSetParametersCopier.copy(mappedDataSetParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mappedDataSetParameters(MappedDataSetParameter ... mappedDataSetParameters) {
            this.mappedDataSetParameters(Arrays.asList(mappedDataSetParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mappedDataSetParameters(Consumer<MappedDataSetParameter.Builder> ... mappedDataSetParameters) {
            this.mappedDataSetParameters(Stream.of(mappedDataSetParameters).map(c -> (MappedDataSetParameter)((MappedDataSetParameter.Builder)MappedDataSetParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public IntegerParameterDeclaration build() {
            return new IntegerParameterDeclaration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IntegerParameterDeclaration> {
        public Builder parameterValueType(String var1);

        public Builder parameterValueType(ParameterValueType var1);

        public Builder name(String var1);

        public Builder defaultValues(IntegerDefaultValues var1);

        default public Builder defaultValues(Consumer<IntegerDefaultValues.Builder> defaultValues) {
            return this.defaultValues((IntegerDefaultValues)((IntegerDefaultValues.Builder)IntegerDefaultValues.builder().applyMutation(defaultValues)).build());
        }

        public Builder valueWhenUnset(IntegerValueWhenUnsetConfiguration var1);

        default public Builder valueWhenUnset(Consumer<IntegerValueWhenUnsetConfiguration.Builder> valueWhenUnset) {
            return this.valueWhenUnset((IntegerValueWhenUnsetConfiguration)((IntegerValueWhenUnsetConfiguration.Builder)IntegerValueWhenUnsetConfiguration.builder().applyMutation(valueWhenUnset)).build());
        }

        public Builder mappedDataSetParameters(Collection<MappedDataSetParameter> var1);

        public Builder mappedDataSetParameters(MappedDataSetParameter ... var1);

        public Builder mappedDataSetParameters(Consumer<MappedDataSetParameter.Builder> ... var1);
    }
}

