/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.AnchorType;
import software.amazon.awssdk.services.quicksight.model.TimeGranularity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Anchor
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Anchor> {
    private static final SdkField<String> ANCHOR_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnchorType").getter(Anchor.getter(Anchor::anchorTypeAsString)).setter(Anchor.setter(Builder::anchorType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnchorType").build()}).build();
    private static final SdkField<String> TIME_GRANULARITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimeGranularity").getter(Anchor.getter(Anchor::timeGranularityAsString)).setter(Anchor.setter(Builder::timeGranularity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeGranularity").build()}).build();
    private static final SdkField<Integer> OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Offset").getter(Anchor.getter(Anchor::offset)).setter(Anchor.setter(Builder::offset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Offset").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANCHOR_TYPE_FIELD, TIME_GRANULARITY_FIELD, OFFSET_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Anchor.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String anchorType;
    private final String timeGranularity;
    private final Integer offset;

    private Anchor(BuilderImpl builder) {
        this.anchorType = builder.anchorType;
        this.timeGranularity = builder.timeGranularity;
        this.offset = builder.offset;
    }

    public final AnchorType anchorType() {
        return AnchorType.fromValue(this.anchorType);
    }

    public final String anchorTypeAsString() {
        return this.anchorType;
    }

    public final TimeGranularity timeGranularity() {
        return TimeGranularity.fromValue(this.timeGranularity);
    }

    public final String timeGranularityAsString() {
        return this.timeGranularity;
    }

    public final Integer offset() {
        return this.offset;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.anchorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeGranularityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.offset());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Anchor)) {
            return false;
        }
        Anchor other = (Anchor)obj;
        return Objects.equals(this.anchorTypeAsString(), other.anchorTypeAsString()) && Objects.equals(this.timeGranularityAsString(), other.timeGranularityAsString()) && Objects.equals(this.offset(), other.offset());
    }

    public final String toString() {
        return ToString.builder((String)"Anchor").add("AnchorType", (Object)this.anchorTypeAsString()).add("TimeGranularity", (Object)this.timeGranularityAsString()).add("Offset", (Object)this.offset()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AnchorType": {
                return Optional.ofNullable(clazz.cast(this.anchorTypeAsString()));
            }
            case "TimeGranularity": {
                return Optional.ofNullable(clazz.cast(this.timeGranularityAsString()));
            }
            case "Offset": {
                return Optional.ofNullable(clazz.cast(this.offset()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AnchorType", ANCHOR_TYPE_FIELD);
        map.put("TimeGranularity", TIME_GRANULARITY_FIELD);
        map.put("Offset", OFFSET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Anchor, T> g) {
        return obj -> g.apply((Anchor)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String anchorType;
        private String timeGranularity;
        private Integer offset;

        private BuilderImpl() {
        }

        private BuilderImpl(Anchor model) {
            this.anchorType(model.anchorType);
            this.timeGranularity(model.timeGranularity);
            this.offset(model.offset);
        }

        public final String getAnchorType() {
            return this.anchorType;
        }

        public final void setAnchorType(String anchorType) {
            this.anchorType = anchorType;
        }

        @Override
        public final Builder anchorType(String anchorType) {
            this.anchorType = anchorType;
            return this;
        }

        @Override
        public final Builder anchorType(AnchorType anchorType) {
            this.anchorType(anchorType == null ? null : anchorType.toString());
            return this;
        }

        public final String getTimeGranularity() {
            return this.timeGranularity;
        }

        public final void setTimeGranularity(String timeGranularity) {
            this.timeGranularity = timeGranularity;
        }

        @Override
        public final Builder timeGranularity(String timeGranularity) {
            this.timeGranularity = timeGranularity;
            return this;
        }

        @Override
        public final Builder timeGranularity(TimeGranularity timeGranularity) {
            this.timeGranularity(timeGranularity == null ? null : timeGranularity.toString());
            return this;
        }

        public final Integer getOffset() {
            return this.offset;
        }

        public final void setOffset(Integer offset) {
            this.offset = offset;
        }

        @Override
        public final Builder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public Anchor build() {
            return new Anchor(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Anchor> {
        public Builder anchorType(String var1);

        public Builder anchorType(AnchorType var1);

        public Builder timeGranularity(String var1);

        public Builder timeGranularity(TimeGranularity var1);

        public Builder offset(Integer var1);
    }
}

