/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.GeospatialCoordinateBounds;
import software.amazon.awssdk.services.quicksight.model.GeospatialMapNavigation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GeospatialMapState
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GeospatialMapState> {
    private static final SdkField<GeospatialCoordinateBounds> BOUNDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Bounds").getter(GeospatialMapState.getter(GeospatialMapState::bounds)).setter(GeospatialMapState.setter(Builder::bounds)).constructor(GeospatialCoordinateBounds::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bounds").build()}).build();
    private static final SdkField<String> MAP_NAVIGATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MapNavigation").getter(GeospatialMapState.getter(GeospatialMapState::mapNavigationAsString)).setter(GeospatialMapState.setter(Builder::mapNavigation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MapNavigation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOUNDS_FIELD, MAP_NAVIGATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GeospatialMapState.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final GeospatialCoordinateBounds bounds;
    private final String mapNavigation;

    private GeospatialMapState(BuilderImpl builder) {
        this.bounds = builder.bounds;
        this.mapNavigation = builder.mapNavigation;
    }

    public final GeospatialCoordinateBounds bounds() {
        return this.bounds;
    }

    public final GeospatialMapNavigation mapNavigation() {
        return GeospatialMapNavigation.fromValue(this.mapNavigation);
    }

    public final String mapNavigationAsString() {
        return this.mapNavigation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bounds());
        hashCode = 31 * hashCode + Objects.hashCode(this.mapNavigationAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeospatialMapState)) {
            return false;
        }
        GeospatialMapState other = (GeospatialMapState)obj;
        return Objects.equals(this.bounds(), other.bounds()) && Objects.equals(this.mapNavigationAsString(), other.mapNavigationAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GeospatialMapState").add("Bounds", (Object)this.bounds()).add("MapNavigation", (Object)this.mapNavigationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bounds": {
                return Optional.ofNullable(clazz.cast(this.bounds()));
            }
            case "MapNavigation": {
                return Optional.ofNullable(clazz.cast(this.mapNavigationAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Bounds", BOUNDS_FIELD);
        map.put("MapNavigation", MAP_NAVIGATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GeospatialMapState, T> g) {
        return obj -> g.apply((GeospatialMapState)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private GeospatialCoordinateBounds bounds;
        private String mapNavigation;

        private BuilderImpl() {
        }

        private BuilderImpl(GeospatialMapState model) {
            this.bounds(model.bounds);
            this.mapNavigation(model.mapNavigation);
        }

        public final GeospatialCoordinateBounds.Builder getBounds() {
            return this.bounds != null ? this.bounds.toBuilder() : null;
        }

        public final void setBounds(GeospatialCoordinateBounds.BuilderImpl bounds) {
            this.bounds = bounds != null ? bounds.build() : null;
        }

        @Override
        public final Builder bounds(GeospatialCoordinateBounds bounds) {
            this.bounds = bounds;
            return this;
        }

        public final String getMapNavigation() {
            return this.mapNavigation;
        }

        public final void setMapNavigation(String mapNavigation) {
            this.mapNavigation = mapNavigation;
        }

        @Override
        public final Builder mapNavigation(String mapNavigation) {
            this.mapNavigation = mapNavigation;
            return this;
        }

        @Override
        public final Builder mapNavigation(GeospatialMapNavigation mapNavigation) {
            this.mapNavigation(mapNavigation == null ? null : mapNavigation.toString());
            return this;
        }

        public GeospatialMapState build() {
            return new GeospatialMapState(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GeospatialMapState> {
        public Builder bounds(GeospatialCoordinateBounds var1);

        default public Builder bounds(Consumer<GeospatialCoordinateBounds.Builder> bounds) {
            return this.bounds((GeospatialCoordinateBounds)((GeospatialCoordinateBounds.Builder)GeospatialCoordinateBounds.builder().applyMutation(bounds)).build());
        }

        public Builder mapNavigation(String var1);

        public Builder mapNavigation(GeospatialMapNavigation var1);
    }
}

