/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AggType {
    SUM("SUM"),
    MIN("MIN"),
    MAX("MAX"),
    COUNT("COUNT"),
    AVERAGE("AVERAGE"),
    DISTINCT_COUNT("DISTINCT_COUNT"),
    STDEV("STDEV"),
    STDEVP("STDEVP"),
    VAR("VAR"),
    VARP("VARP"),
    PERCENTILE("PERCENTILE"),
    MEDIAN("MEDIAN"),
    PTD_SUM("PTD_SUM"),
    PTD_MIN("PTD_MIN"),
    PTD_MAX("PTD_MAX"),
    PTD_COUNT("PTD_COUNT"),
    PTD_DISTINCT_COUNT("PTD_DISTINCT_COUNT"),
    PTD_AVERAGE("PTD_AVERAGE"),
    COLUMN("COLUMN"),
    CUSTOM("CUSTOM"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AggType> VALUE_MAP;
    private final String value;

    private AggType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AggType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AggType> knownValues() {
        EnumSet<AggType> knownValues = EnumSet.allOf(AggType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AggType.class, AggType::toString);
    }
}

