/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LayoutElementType {
    VISUAL("VISUAL"),
    FILTER_CONTROL("FILTER_CONTROL"),
    PARAMETER_CONTROL("PARAMETER_CONTROL"),
    TEXT_BOX("TEXT_BOX"),
    IMAGE("IMAGE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LayoutElementType> VALUE_MAP;
    private final String value;

    private LayoutElementType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LayoutElementType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LayoutElementType> knownValues() {
        EnumSet<LayoutElementType> knownValues = EnumSet.allOf(LayoutElementType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LayoutElementType.class, LayoutElementType::toString);
    }
}

