/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.TimeGranularity;
import software.amazon.awssdk.services.quicksight.model.WidgetStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExcludePeriodConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExcludePeriodConfiguration> {
    private static final SdkField<Integer> AMOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Amount").getter(ExcludePeriodConfiguration.getter(ExcludePeriodConfiguration::amount)).setter(ExcludePeriodConfiguration.setter(Builder::amount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Amount").build()}).build();
    private static final SdkField<String> GRANULARITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Granularity").getter(ExcludePeriodConfiguration.getter(ExcludePeriodConfiguration::granularityAsString)).setter(ExcludePeriodConfiguration.setter(Builder::granularity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Granularity").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ExcludePeriodConfiguration.getter(ExcludePeriodConfiguration::statusAsString)).setter(ExcludePeriodConfiguration.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMOUNT_FIELD, GRANULARITY_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExcludePeriodConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer amount;
    private final String granularity;
    private final String status;

    private ExcludePeriodConfiguration(BuilderImpl builder) {
        this.amount = builder.amount;
        this.granularity = builder.granularity;
        this.status = builder.status;
    }

    public final Integer amount() {
        return this.amount;
    }

    public final TimeGranularity granularity() {
        return TimeGranularity.fromValue(this.granularity);
    }

    public final String granularityAsString() {
        return this.granularity;
    }

    public final WidgetStatus status() {
        return WidgetStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.amount());
        hashCode = 31 * hashCode + Objects.hashCode(this.granularityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExcludePeriodConfiguration)) {
            return false;
        }
        ExcludePeriodConfiguration other = (ExcludePeriodConfiguration)obj;
        return Objects.equals(this.amount(), other.amount()) && Objects.equals(this.granularityAsString(), other.granularityAsString()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ExcludePeriodConfiguration").add("Amount", (Object)this.amount()).add("Granularity", (Object)this.granularityAsString()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Amount": {
                return Optional.ofNullable(clazz.cast(this.amount()));
            }
            case "Granularity": {
                return Optional.ofNullable(clazz.cast(this.granularityAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Amount", AMOUNT_FIELD);
        map.put("Granularity", GRANULARITY_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExcludePeriodConfiguration, T> g) {
        return obj -> g.apply((ExcludePeriodConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer amount;
        private String granularity;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ExcludePeriodConfiguration model) {
            this.amount(model.amount);
            this.granularity(model.granularity);
            this.status(model.status);
        }

        public final Integer getAmount() {
            return this.amount;
        }

        public final void setAmount(Integer amount) {
            this.amount = amount;
        }

        @Override
        public final Builder amount(Integer amount) {
            this.amount = amount;
            return this;
        }

        public final String getGranularity() {
            return this.granularity;
        }

        public final void setGranularity(String granularity) {
            this.granularity = granularity;
        }

        @Override
        public final Builder granularity(String granularity) {
            this.granularity = granularity;
            return this;
        }

        @Override
        public final Builder granularity(TimeGranularity granularity) {
            this.granularity(granularity == null ? null : granularity.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WidgetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public ExcludePeriodConfiguration build() {
            return new ExcludePeriodConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExcludePeriodConfiguration> {
        public Builder amount(Integer var1);

        public Builder granularity(String var1);

        public Builder granularity(TimeGranularity var1);

        public Builder status(String var1);

        public Builder status(WidgetStatus var1);
    }
}

