/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.TopicScheduleType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TopicRefreshSchedule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TopicRefreshSchedule> {
    private static final SdkField<Boolean> IS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsEnabled").getter(TopicRefreshSchedule.getter(TopicRefreshSchedule::isEnabled)).setter(TopicRefreshSchedule.setter(Builder::isEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsEnabled").build()}).build();
    private static final SdkField<Boolean> BASED_ON_SPICE_SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("BasedOnSpiceSchedule").getter(TopicRefreshSchedule.getter(TopicRefreshSchedule::basedOnSpiceSchedule)).setter(TopicRefreshSchedule.setter(Builder::basedOnSpiceSchedule)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BasedOnSpiceSchedule").build()}).build();
    private static final SdkField<Instant> STARTING_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartingAt").getter(TopicRefreshSchedule.getter(TopicRefreshSchedule::startingAt)).setter(TopicRefreshSchedule.setter(Builder::startingAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartingAt").build()}).build();
    private static final SdkField<String> TIMEZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Timezone").getter(TopicRefreshSchedule.getter(TopicRefreshSchedule::timezone)).setter(TopicRefreshSchedule.setter(Builder::timezone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timezone").build()}).build();
    private static final SdkField<String> REPEAT_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RepeatAt").getter(TopicRefreshSchedule.getter(TopicRefreshSchedule::repeatAt)).setter(TopicRefreshSchedule.setter(Builder::repeatAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepeatAt").build()}).build();
    private static final SdkField<String> TOPIC_SCHEDULE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TopicScheduleType").getter(TopicRefreshSchedule.getter(TopicRefreshSchedule::topicScheduleTypeAsString)).setter(TopicRefreshSchedule.setter(Builder::topicScheduleType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicScheduleType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_ENABLED_FIELD, BASED_ON_SPICE_SCHEDULE_FIELD, STARTING_AT_FIELD, TIMEZONE_FIELD, REPEAT_AT_FIELD, TOPIC_SCHEDULE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("IsEnabled", IS_ENABLED_FIELD);
            this.put("BasedOnSpiceSchedule", BASED_ON_SPICE_SCHEDULE_FIELD);
            this.put("StartingAt", STARTING_AT_FIELD);
            this.put("Timezone", TIMEZONE_FIELD);
            this.put("RepeatAt", REPEAT_AT_FIELD);
            this.put("TopicScheduleType", TOPIC_SCHEDULE_TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Boolean isEnabled;
    private final Boolean basedOnSpiceSchedule;
    private final Instant startingAt;
    private final String timezone;
    private final String repeatAt;
    private final String topicScheduleType;

    private TopicRefreshSchedule(BuilderImpl builder) {
        this.isEnabled = builder.isEnabled;
        this.basedOnSpiceSchedule = builder.basedOnSpiceSchedule;
        this.startingAt = builder.startingAt;
        this.timezone = builder.timezone;
        this.repeatAt = builder.repeatAt;
        this.topicScheduleType = builder.topicScheduleType;
    }

    public final Boolean isEnabled() {
        return this.isEnabled;
    }

    public final Boolean basedOnSpiceSchedule() {
        return this.basedOnSpiceSchedule;
    }

    public final Instant startingAt() {
        return this.startingAt;
    }

    public final String timezone() {
        return this.timezone;
    }

    public final String repeatAt() {
        return this.repeatAt;
    }

    public final TopicScheduleType topicScheduleType() {
        return TopicScheduleType.fromValue(this.topicScheduleType);
    }

    public final String topicScheduleTypeAsString() {
        return this.topicScheduleType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.isEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.basedOnSpiceSchedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.startingAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.timezone());
        hashCode = 31 * hashCode + Objects.hashCode(this.repeatAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.topicScheduleTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicRefreshSchedule)) {
            return false;
        }
        TopicRefreshSchedule other = (TopicRefreshSchedule)obj;
        return Objects.equals(this.isEnabled(), other.isEnabled()) && Objects.equals(this.basedOnSpiceSchedule(), other.basedOnSpiceSchedule()) && Objects.equals(this.startingAt(), other.startingAt()) && Objects.equals(this.timezone(), other.timezone()) && Objects.equals(this.repeatAt(), other.repeatAt()) && Objects.equals(this.topicScheduleTypeAsString(), other.topicScheduleTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TopicRefreshSchedule").add("IsEnabled", (Object)this.isEnabled()).add("BasedOnSpiceSchedule", (Object)this.basedOnSpiceSchedule()).add("StartingAt", (Object)this.startingAt()).add("Timezone", (Object)this.timezone()).add("RepeatAt", (Object)this.repeatAt()).add("TopicScheduleType", (Object)this.topicScheduleTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IsEnabled": {
                return Optional.ofNullable(clazz.cast(this.isEnabled()));
            }
            case "BasedOnSpiceSchedule": {
                return Optional.ofNullable(clazz.cast(this.basedOnSpiceSchedule()));
            }
            case "StartingAt": {
                return Optional.ofNullable(clazz.cast(this.startingAt()));
            }
            case "Timezone": {
                return Optional.ofNullable(clazz.cast(this.timezone()));
            }
            case "RepeatAt": {
                return Optional.ofNullable(clazz.cast(this.repeatAt()));
            }
            case "TopicScheduleType": {
                return Optional.ofNullable(clazz.cast(this.topicScheduleTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TopicRefreshSchedule, T> g) {
        return obj -> g.apply((TopicRefreshSchedule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean isEnabled;
        private Boolean basedOnSpiceSchedule;
        private Instant startingAt;
        private String timezone;
        private String repeatAt;
        private String topicScheduleType;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicRefreshSchedule model) {
            this.isEnabled(model.isEnabled);
            this.basedOnSpiceSchedule(model.basedOnSpiceSchedule);
            this.startingAt(model.startingAt);
            this.timezone(model.timezone);
            this.repeatAt(model.repeatAt);
            this.topicScheduleType(model.topicScheduleType);
        }

        public final Boolean getIsEnabled() {
            return this.isEnabled;
        }

        public final void setIsEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
        }

        @Override
        public final Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            return this;
        }

        public final Boolean getBasedOnSpiceSchedule() {
            return this.basedOnSpiceSchedule;
        }

        public final void setBasedOnSpiceSchedule(Boolean basedOnSpiceSchedule) {
            this.basedOnSpiceSchedule = basedOnSpiceSchedule;
        }

        @Override
        public final Builder basedOnSpiceSchedule(Boolean basedOnSpiceSchedule) {
            this.basedOnSpiceSchedule = basedOnSpiceSchedule;
            return this;
        }

        public final Instant getStartingAt() {
            return this.startingAt;
        }

        public final void setStartingAt(Instant startingAt) {
            this.startingAt = startingAt;
        }

        @Override
        public final Builder startingAt(Instant startingAt) {
            this.startingAt = startingAt;
            return this;
        }

        public final String getTimezone() {
            return this.timezone;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final String getRepeatAt() {
            return this.repeatAt;
        }

        public final void setRepeatAt(String repeatAt) {
            this.repeatAt = repeatAt;
        }

        @Override
        public final Builder repeatAt(String repeatAt) {
            this.repeatAt = repeatAt;
            return this;
        }

        public final String getTopicScheduleType() {
            return this.topicScheduleType;
        }

        public final void setTopicScheduleType(String topicScheduleType) {
            this.topicScheduleType = topicScheduleType;
        }

        @Override
        public final Builder topicScheduleType(String topicScheduleType) {
            this.topicScheduleType = topicScheduleType;
            return this;
        }

        @Override
        public final Builder topicScheduleType(TopicScheduleType topicScheduleType) {
            this.topicScheduleType(topicScheduleType == null ? null : topicScheduleType.toString());
            return this;
        }

        public TopicRefreshSchedule build() {
            return new TopicRefreshSchedule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TopicRefreshSchedule> {
        public Builder isEnabled(Boolean var1);

        public Builder basedOnSpiceSchedule(Boolean var1);

        public Builder startingAt(Instant var1);

        public Builder timezone(String var1);

        public Builder repeatAt(String var1);

        public Builder topicScheduleType(String var1);

        public Builder topicScheduleType(TopicScheduleType var1);
    }
}

