/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.AggregationSortConfiguration;
import software.amazon.awssdk.services.quicksight.model.AggregationSortConfigurationListCopier;
import software.amazon.awssdk.services.quicksight.model.ColumnIdentifier;
import software.amazon.awssdk.services.quicksight.model.DefaultFilterControlConfiguration;
import software.amazon.awssdk.services.quicksight.model.TimeGranularity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TopBottomFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TopBottomFilter> {
    private static final SdkField<String> FILTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FilterId").getter(TopBottomFilter.getter(TopBottomFilter::filterId)).setter(TopBottomFilter.setter(Builder::filterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterId").build()}).build();
    private static final SdkField<ColumnIdentifier> COLUMN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Column").getter(TopBottomFilter.getter(TopBottomFilter::column)).setter(TopBottomFilter.setter(Builder::column)).constructor(ColumnIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Column").build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Limit").getter(TopBottomFilter.getter(TopBottomFilter::limit)).setter(TopBottomFilter.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()}).build();
    private static final SdkField<List<AggregationSortConfiguration>> AGGREGATION_SORT_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AggregationSortConfigurations").getter(TopBottomFilter.getter(TopBottomFilter::aggregationSortConfigurations)).setter(TopBottomFilter.setter(Builder::aggregationSortConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregationSortConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AggregationSortConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TIME_GRANULARITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimeGranularity").getter(TopBottomFilter.getter(TopBottomFilter::timeGranularityAsString)).setter(TopBottomFilter.setter(Builder::timeGranularity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeGranularity").build()}).build();
    private static final SdkField<String> PARAMETER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParameterName").getter(TopBottomFilter.getter(TopBottomFilter::parameterName)).setter(TopBottomFilter.setter(Builder::parameterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterName").build()}).build();
    private static final SdkField<DefaultFilterControlConfiguration> DEFAULT_FILTER_CONTROL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultFilterControlConfiguration").getter(TopBottomFilter.getter(TopBottomFilter::defaultFilterControlConfiguration)).setter(TopBottomFilter.setter(Builder::defaultFilterControlConfiguration)).constructor(DefaultFilterControlConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultFilterControlConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_ID_FIELD, COLUMN_FIELD, LIMIT_FIELD, AGGREGATION_SORT_CONFIGURATIONS_FIELD, TIME_GRANULARITY_FIELD, PARAMETER_NAME_FIELD, DEFAULT_FILTER_CONTROL_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("FilterId", FILTER_ID_FIELD);
            this.put("Column", COLUMN_FIELD);
            this.put("Limit", LIMIT_FIELD);
            this.put("AggregationSortConfigurations", AGGREGATION_SORT_CONFIGURATIONS_FIELD);
            this.put("TimeGranularity", TIME_GRANULARITY_FIELD);
            this.put("ParameterName", PARAMETER_NAME_FIELD);
            this.put("DefaultFilterControlConfiguration", DEFAULT_FILTER_CONTROL_CONFIGURATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String filterId;
    private final ColumnIdentifier column;
    private final Integer limit;
    private final List<AggregationSortConfiguration> aggregationSortConfigurations;
    private final String timeGranularity;
    private final String parameterName;
    private final DefaultFilterControlConfiguration defaultFilterControlConfiguration;

    private TopBottomFilter(BuilderImpl builder) {
        this.filterId = builder.filterId;
        this.column = builder.column;
        this.limit = builder.limit;
        this.aggregationSortConfigurations = builder.aggregationSortConfigurations;
        this.timeGranularity = builder.timeGranularity;
        this.parameterName = builder.parameterName;
        this.defaultFilterControlConfiguration = builder.defaultFilterControlConfiguration;
    }

    public final String filterId() {
        return this.filterId;
    }

    public final ColumnIdentifier column() {
        return this.column;
    }

    public final Integer limit() {
        return this.limit;
    }

    public final boolean hasAggregationSortConfigurations() {
        return this.aggregationSortConfigurations != null && !(this.aggregationSortConfigurations instanceof SdkAutoConstructList);
    }

    public final List<AggregationSortConfiguration> aggregationSortConfigurations() {
        return this.aggregationSortConfigurations;
    }

    public final TimeGranularity timeGranularity() {
        return TimeGranularity.fromValue(this.timeGranularity);
    }

    public final String timeGranularityAsString() {
        return this.timeGranularity;
    }

    public final String parameterName() {
        return this.parameterName;
    }

    public final DefaultFilterControlConfiguration defaultFilterControlConfiguration() {
        return this.defaultFilterControlConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.column());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAggregationSortConfigurations() ? this.aggregationSortConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.timeGranularityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultFilterControlConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopBottomFilter)) {
            return false;
        }
        TopBottomFilter other = (TopBottomFilter)obj;
        return Objects.equals(this.filterId(), other.filterId()) && Objects.equals(this.column(), other.column()) && Objects.equals(this.limit(), other.limit()) && this.hasAggregationSortConfigurations() == other.hasAggregationSortConfigurations() && Objects.equals(this.aggregationSortConfigurations(), other.aggregationSortConfigurations()) && Objects.equals(this.timeGranularityAsString(), other.timeGranularityAsString()) && Objects.equals(this.parameterName(), other.parameterName()) && Objects.equals(this.defaultFilterControlConfiguration(), other.defaultFilterControlConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"TopBottomFilter").add("FilterId", (Object)this.filterId()).add("Column", (Object)this.column()).add("Limit", (Object)this.limit()).add("AggregationSortConfigurations", this.hasAggregationSortConfigurations() ? this.aggregationSortConfigurations() : null).add("TimeGranularity", (Object)this.timeGranularityAsString()).add("ParameterName", (Object)this.parameterName()).add("DefaultFilterControlConfiguration", (Object)this.defaultFilterControlConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FilterId": {
                return Optional.ofNullable(clazz.cast(this.filterId()));
            }
            case "Column": {
                return Optional.ofNullable(clazz.cast(this.column()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "AggregationSortConfigurations": {
                return Optional.ofNullable(clazz.cast(this.aggregationSortConfigurations()));
            }
            case "TimeGranularity": {
                return Optional.ofNullable(clazz.cast(this.timeGranularityAsString()));
            }
            case "ParameterName": {
                return Optional.ofNullable(clazz.cast(this.parameterName()));
            }
            case "DefaultFilterControlConfiguration": {
                return Optional.ofNullable(clazz.cast(this.defaultFilterControlConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TopBottomFilter, T> g) {
        return obj -> g.apply((TopBottomFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String filterId;
        private ColumnIdentifier column;
        private Integer limit;
        private List<AggregationSortConfiguration> aggregationSortConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String timeGranularity;
        private String parameterName;
        private DefaultFilterControlConfiguration defaultFilterControlConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(TopBottomFilter model) {
            this.filterId(model.filterId);
            this.column(model.column);
            this.limit(model.limit);
            this.aggregationSortConfigurations(model.aggregationSortConfigurations);
            this.timeGranularity(model.timeGranularity);
            this.parameterName(model.parameterName);
            this.defaultFilterControlConfiguration(model.defaultFilterControlConfiguration);
        }

        public final String getFilterId() {
            return this.filterId;
        }

        public final void setFilterId(String filterId) {
            this.filterId = filterId;
        }

        @Override
        public final Builder filterId(String filterId) {
            this.filterId = filterId;
            return this;
        }

        public final ColumnIdentifier.Builder getColumn() {
            return this.column != null ? this.column.toBuilder() : null;
        }

        public final void setColumn(ColumnIdentifier.BuilderImpl column) {
            this.column = column != null ? column.build() : null;
        }

        @Override
        public final Builder column(ColumnIdentifier column) {
            this.column = column;
            return this;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final List<AggregationSortConfiguration.Builder> getAggregationSortConfigurations() {
            List<AggregationSortConfiguration.Builder> result = AggregationSortConfigurationListCopier.copyToBuilder(this.aggregationSortConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAggregationSortConfigurations(Collection<AggregationSortConfiguration.BuilderImpl> aggregationSortConfigurations) {
            this.aggregationSortConfigurations = AggregationSortConfigurationListCopier.copyFromBuilder(aggregationSortConfigurations);
        }

        @Override
        public final Builder aggregationSortConfigurations(Collection<AggregationSortConfiguration> aggregationSortConfigurations) {
            this.aggregationSortConfigurations = AggregationSortConfigurationListCopier.copy(aggregationSortConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregationSortConfigurations(AggregationSortConfiguration ... aggregationSortConfigurations) {
            this.aggregationSortConfigurations(Arrays.asList(aggregationSortConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregationSortConfigurations(Consumer<AggregationSortConfiguration.Builder> ... aggregationSortConfigurations) {
            this.aggregationSortConfigurations(Stream.of(aggregationSortConfigurations).map(c -> (AggregationSortConfiguration)((AggregationSortConfiguration.Builder)AggregationSortConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTimeGranularity() {
            return this.timeGranularity;
        }

        public final void setTimeGranularity(String timeGranularity) {
            this.timeGranularity = timeGranularity;
        }

        @Override
        public final Builder timeGranularity(String timeGranularity) {
            this.timeGranularity = timeGranularity;
            return this;
        }

        @Override
        public final Builder timeGranularity(TimeGranularity timeGranularity) {
            this.timeGranularity(timeGranularity == null ? null : timeGranularity.toString());
            return this;
        }

        public final String getParameterName() {
            return this.parameterName;
        }

        public final void setParameterName(String parameterName) {
            this.parameterName = parameterName;
        }

        @Override
        public final Builder parameterName(String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        public final DefaultFilterControlConfiguration.Builder getDefaultFilterControlConfiguration() {
            return this.defaultFilterControlConfiguration != null ? this.defaultFilterControlConfiguration.toBuilder() : null;
        }

        public final void setDefaultFilterControlConfiguration(DefaultFilterControlConfiguration.BuilderImpl defaultFilterControlConfiguration) {
            this.defaultFilterControlConfiguration = defaultFilterControlConfiguration != null ? defaultFilterControlConfiguration.build() : null;
        }

        @Override
        public final Builder defaultFilterControlConfiguration(DefaultFilterControlConfiguration defaultFilterControlConfiguration) {
            this.defaultFilterControlConfiguration = defaultFilterControlConfiguration;
            return this;
        }

        public TopBottomFilter build() {
            return new TopBottomFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TopBottomFilter> {
        public Builder filterId(String var1);

        public Builder column(ColumnIdentifier var1);

        default public Builder column(Consumer<ColumnIdentifier.Builder> column) {
            return this.column((ColumnIdentifier)((ColumnIdentifier.Builder)ColumnIdentifier.builder().applyMutation(column)).build());
        }

        public Builder limit(Integer var1);

        public Builder aggregationSortConfigurations(Collection<AggregationSortConfiguration> var1);

        public Builder aggregationSortConfigurations(AggregationSortConfiguration ... var1);

        public Builder aggregationSortConfigurations(Consumer<AggregationSortConfiguration.Builder> ... var1);

        public Builder timeGranularity(String var1);

        public Builder timeGranularity(TimeGranularity var1);

        public Builder parameterName(String var1);

        public Builder defaultFilterControlConfiguration(DefaultFilterControlConfiguration var1);

        default public Builder defaultFilterControlConfiguration(Consumer<DefaultFilterControlConfiguration.Builder> defaultFilterControlConfiguration) {
            return this.defaultFilterControlConfiguration((DefaultFilterControlConfiguration)((DefaultFilterControlConfiguration.Builder)DefaultFilterControlConfiguration.builder().applyMutation(defaultFilterControlConfiguration)).build());
        }
    }
}

