/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.AssetBundleImportFailureAction;
import software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobOverrideParameters;
import software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobOverridePermissions;
import software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobOverrideTags;
import software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobOverrideValidationStrategy;
import software.amazon.awssdk.services.quicksight.model.AssetBundleImportSource;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartAssetBundleImportJobRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, StartAssetBundleImportJobRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(StartAssetBundleImportJobRequest.getter(StartAssetBundleImportJobRequest::awsAccountId)).setter(StartAssetBundleImportJobRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> ASSET_BUNDLE_IMPORT_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssetBundleImportJobId").getter(StartAssetBundleImportJobRequest.getter(StartAssetBundleImportJobRequest::assetBundleImportJobId)).setter(StartAssetBundleImportJobRequest.setter(Builder::assetBundleImportJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssetBundleImportJobId").build()}).build();
    private static final SdkField<AssetBundleImportSource> ASSET_BUNDLE_IMPORT_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AssetBundleImportSource").getter(StartAssetBundleImportJobRequest.getter(StartAssetBundleImportJobRequest::assetBundleImportSource)).setter(StartAssetBundleImportJobRequest.setter(Builder::assetBundleImportSource)).constructor(AssetBundleImportSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssetBundleImportSource").build()}).build();
    private static final SdkField<AssetBundleImportJobOverrideParameters> OVERRIDE_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OverrideParameters").getter(StartAssetBundleImportJobRequest.getter(StartAssetBundleImportJobRequest::overrideParameters)).setter(StartAssetBundleImportJobRequest.setter(Builder::overrideParameters)).constructor(AssetBundleImportJobOverrideParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverrideParameters").build()}).build();
    private static final SdkField<String> FAILURE_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureAction").getter(StartAssetBundleImportJobRequest.getter(StartAssetBundleImportJobRequest::failureActionAsString)).setter(StartAssetBundleImportJobRequest.setter(Builder::failureAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureAction").build()}).build();
    private static final SdkField<AssetBundleImportJobOverridePermissions> OVERRIDE_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OverridePermissions").getter(StartAssetBundleImportJobRequest.getter(StartAssetBundleImportJobRequest::overridePermissions)).setter(StartAssetBundleImportJobRequest.setter(Builder::overridePermissions)).constructor(AssetBundleImportJobOverridePermissions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverridePermissions").build()}).build();
    private static final SdkField<AssetBundleImportJobOverrideTags> OVERRIDE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OverrideTags").getter(StartAssetBundleImportJobRequest.getter(StartAssetBundleImportJobRequest::overrideTags)).setter(StartAssetBundleImportJobRequest.setter(Builder::overrideTags)).constructor(AssetBundleImportJobOverrideTags::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverrideTags").build()}).build();
    private static final SdkField<AssetBundleImportJobOverrideValidationStrategy> OVERRIDE_VALIDATION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OverrideValidationStrategy").getter(StartAssetBundleImportJobRequest.getter(StartAssetBundleImportJobRequest::overrideValidationStrategy)).setter(StartAssetBundleImportJobRequest.setter(Builder::overrideValidationStrategy)).constructor(AssetBundleImportJobOverrideValidationStrategy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverrideValidationStrategy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, ASSET_BUNDLE_IMPORT_JOB_ID_FIELD, ASSET_BUNDLE_IMPORT_SOURCE_FIELD, OVERRIDE_PARAMETERS_FIELD, FAILURE_ACTION_FIELD, OVERRIDE_PERMISSIONS_FIELD, OVERRIDE_TAGS_FIELD, OVERRIDE_VALIDATION_STRATEGY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
            this.put("AssetBundleImportJobId", ASSET_BUNDLE_IMPORT_JOB_ID_FIELD);
            this.put("AssetBundleImportSource", ASSET_BUNDLE_IMPORT_SOURCE_FIELD);
            this.put("OverrideParameters", OVERRIDE_PARAMETERS_FIELD);
            this.put("FailureAction", FAILURE_ACTION_FIELD);
            this.put("OverridePermissions", OVERRIDE_PERMISSIONS_FIELD);
            this.put("OverrideTags", OVERRIDE_TAGS_FIELD);
            this.put("OverrideValidationStrategy", OVERRIDE_VALIDATION_STRATEGY_FIELD);
        }
    });
    private final String awsAccountId;
    private final String assetBundleImportJobId;
    private final AssetBundleImportSource assetBundleImportSource;
    private final AssetBundleImportJobOverrideParameters overrideParameters;
    private final String failureAction;
    private final AssetBundleImportJobOverridePermissions overridePermissions;
    private final AssetBundleImportJobOverrideTags overrideTags;
    private final AssetBundleImportJobOverrideValidationStrategy overrideValidationStrategy;

    private StartAssetBundleImportJobRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.assetBundleImportJobId = builder.assetBundleImportJobId;
        this.assetBundleImportSource = builder.assetBundleImportSource;
        this.overrideParameters = builder.overrideParameters;
        this.failureAction = builder.failureAction;
        this.overridePermissions = builder.overridePermissions;
        this.overrideTags = builder.overrideTags;
        this.overrideValidationStrategy = builder.overrideValidationStrategy;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String assetBundleImportJobId() {
        return this.assetBundleImportJobId;
    }

    public final AssetBundleImportSource assetBundleImportSource() {
        return this.assetBundleImportSource;
    }

    public final AssetBundleImportJobOverrideParameters overrideParameters() {
        return this.overrideParameters;
    }

    public final AssetBundleImportFailureAction failureAction() {
        return AssetBundleImportFailureAction.fromValue(this.failureAction);
    }

    public final String failureActionAsString() {
        return this.failureAction;
    }

    public final AssetBundleImportJobOverridePermissions overridePermissions() {
        return this.overridePermissions;
    }

    public final AssetBundleImportJobOverrideTags overrideTags() {
        return this.overrideTags;
    }

    public final AssetBundleImportJobOverrideValidationStrategy overrideValidationStrategy() {
        return this.overrideValidationStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetBundleImportJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetBundleImportSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.overrideParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.overridePermissions());
        hashCode = 31 * hashCode + Objects.hashCode(this.overrideTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.overrideValidationStrategy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartAssetBundleImportJobRequest)) {
            return false;
        }
        StartAssetBundleImportJobRequest other = (StartAssetBundleImportJobRequest)((Object)obj);
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.assetBundleImportJobId(), other.assetBundleImportJobId()) && Objects.equals(this.assetBundleImportSource(), other.assetBundleImportSource()) && Objects.equals(this.overrideParameters(), other.overrideParameters()) && Objects.equals(this.failureActionAsString(), other.failureActionAsString()) && Objects.equals(this.overridePermissions(), other.overridePermissions()) && Objects.equals(this.overrideTags(), other.overrideTags()) && Objects.equals(this.overrideValidationStrategy(), other.overrideValidationStrategy());
    }

    public final String toString() {
        return ToString.builder((String)"StartAssetBundleImportJobRequest").add("AwsAccountId", (Object)this.awsAccountId()).add("AssetBundleImportJobId", (Object)this.assetBundleImportJobId()).add("AssetBundleImportSource", (Object)this.assetBundleImportSource()).add("OverrideParameters", (Object)this.overrideParameters()).add("FailureAction", (Object)this.failureActionAsString()).add("OverridePermissions", (Object)this.overridePermissions()).add("OverrideTags", (Object)this.overrideTags()).add("OverrideValidationStrategy", (Object)this.overrideValidationStrategy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "AssetBundleImportJobId": {
                return Optional.ofNullable(clazz.cast(this.assetBundleImportJobId()));
            }
            case "AssetBundleImportSource": {
                return Optional.ofNullable(clazz.cast(this.assetBundleImportSource()));
            }
            case "OverrideParameters": {
                return Optional.ofNullable(clazz.cast(this.overrideParameters()));
            }
            case "FailureAction": {
                return Optional.ofNullable(clazz.cast(this.failureActionAsString()));
            }
            case "OverridePermissions": {
                return Optional.ofNullable(clazz.cast(this.overridePermissions()));
            }
            case "OverrideTags": {
                return Optional.ofNullable(clazz.cast(this.overrideTags()));
            }
            case "OverrideValidationStrategy": {
                return Optional.ofNullable(clazz.cast(this.overrideValidationStrategy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartAssetBundleImportJobRequest, T> g) {
        return obj -> g.apply((StartAssetBundleImportJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String assetBundleImportJobId;
        private AssetBundleImportSource assetBundleImportSource;
        private AssetBundleImportJobOverrideParameters overrideParameters;
        private String failureAction;
        private AssetBundleImportJobOverridePermissions overridePermissions;
        private AssetBundleImportJobOverrideTags overrideTags;
        private AssetBundleImportJobOverrideValidationStrategy overrideValidationStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(StartAssetBundleImportJobRequest model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.assetBundleImportJobId(model.assetBundleImportJobId);
            this.assetBundleImportSource(model.assetBundleImportSource);
            this.overrideParameters(model.overrideParameters);
            this.failureAction(model.failureAction);
            this.overridePermissions(model.overridePermissions);
            this.overrideTags(model.overrideTags);
            this.overrideValidationStrategy(model.overrideValidationStrategy);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getAssetBundleImportJobId() {
            return this.assetBundleImportJobId;
        }

        public final void setAssetBundleImportJobId(String assetBundleImportJobId) {
            this.assetBundleImportJobId = assetBundleImportJobId;
        }

        @Override
        public final Builder assetBundleImportJobId(String assetBundleImportJobId) {
            this.assetBundleImportJobId = assetBundleImportJobId;
            return this;
        }

        public final AssetBundleImportSource.Builder getAssetBundleImportSource() {
            return this.assetBundleImportSource != null ? this.assetBundleImportSource.toBuilder() : null;
        }

        public final void setAssetBundleImportSource(AssetBundleImportSource.BuilderImpl assetBundleImportSource) {
            this.assetBundleImportSource = assetBundleImportSource != null ? assetBundleImportSource.build() : null;
        }

        @Override
        public final Builder assetBundleImportSource(AssetBundleImportSource assetBundleImportSource) {
            this.assetBundleImportSource = assetBundleImportSource;
            return this;
        }

        public final AssetBundleImportJobOverrideParameters.Builder getOverrideParameters() {
            return this.overrideParameters != null ? this.overrideParameters.toBuilder() : null;
        }

        public final void setOverrideParameters(AssetBundleImportJobOverrideParameters.BuilderImpl overrideParameters) {
            this.overrideParameters = overrideParameters != null ? overrideParameters.build() : null;
        }

        @Override
        public final Builder overrideParameters(AssetBundleImportJobOverrideParameters overrideParameters) {
            this.overrideParameters = overrideParameters;
            return this;
        }

        public final String getFailureAction() {
            return this.failureAction;
        }

        public final void setFailureAction(String failureAction) {
            this.failureAction = failureAction;
        }

        @Override
        public final Builder failureAction(String failureAction) {
            this.failureAction = failureAction;
            return this;
        }

        @Override
        public final Builder failureAction(AssetBundleImportFailureAction failureAction) {
            this.failureAction(failureAction == null ? null : failureAction.toString());
            return this;
        }

        public final AssetBundleImportJobOverridePermissions.Builder getOverridePermissions() {
            return this.overridePermissions != null ? this.overridePermissions.toBuilder() : null;
        }

        public final void setOverridePermissions(AssetBundleImportJobOverridePermissions.BuilderImpl overridePermissions) {
            this.overridePermissions = overridePermissions != null ? overridePermissions.build() : null;
        }

        @Override
        public final Builder overridePermissions(AssetBundleImportJobOverridePermissions overridePermissions) {
            this.overridePermissions = overridePermissions;
            return this;
        }

        public final AssetBundleImportJobOverrideTags.Builder getOverrideTags() {
            return this.overrideTags != null ? this.overrideTags.toBuilder() : null;
        }

        public final void setOverrideTags(AssetBundleImportJobOverrideTags.BuilderImpl overrideTags) {
            this.overrideTags = overrideTags != null ? overrideTags.build() : null;
        }

        @Override
        public final Builder overrideTags(AssetBundleImportJobOverrideTags overrideTags) {
            this.overrideTags = overrideTags;
            return this;
        }

        public final AssetBundleImportJobOverrideValidationStrategy.Builder getOverrideValidationStrategy() {
            return this.overrideValidationStrategy != null ? this.overrideValidationStrategy.toBuilder() : null;
        }

        public final void setOverrideValidationStrategy(AssetBundleImportJobOverrideValidationStrategy.BuilderImpl overrideValidationStrategy) {
            this.overrideValidationStrategy = overrideValidationStrategy != null ? overrideValidationStrategy.build() : null;
        }

        @Override
        public final Builder overrideValidationStrategy(AssetBundleImportJobOverrideValidationStrategy overrideValidationStrategy) {
            this.overrideValidationStrategy = overrideValidationStrategy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartAssetBundleImportJobRequest build() {
            return new StartAssetBundleImportJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartAssetBundleImportJobRequest> {
        public Builder awsAccountId(String var1);

        public Builder assetBundleImportJobId(String var1);

        public Builder assetBundleImportSource(AssetBundleImportSource var1);

        default public Builder assetBundleImportSource(Consumer<AssetBundleImportSource.Builder> assetBundleImportSource) {
            return this.assetBundleImportSource((AssetBundleImportSource)((AssetBundleImportSource.Builder)AssetBundleImportSource.builder().applyMutation(assetBundleImportSource)).build());
        }

        public Builder overrideParameters(AssetBundleImportJobOverrideParameters var1);

        default public Builder overrideParameters(Consumer<AssetBundleImportJobOverrideParameters.Builder> overrideParameters) {
            return this.overrideParameters((AssetBundleImportJobOverrideParameters)((AssetBundleImportJobOverrideParameters.Builder)AssetBundleImportJobOverrideParameters.builder().applyMutation(overrideParameters)).build());
        }

        public Builder failureAction(String var1);

        public Builder failureAction(AssetBundleImportFailureAction var1);

        public Builder overridePermissions(AssetBundleImportJobOverridePermissions var1);

        default public Builder overridePermissions(Consumer<AssetBundleImportJobOverridePermissions.Builder> overridePermissions) {
            return this.overridePermissions((AssetBundleImportJobOverridePermissions)((AssetBundleImportJobOverridePermissions.Builder)AssetBundleImportJobOverridePermissions.builder().applyMutation(overridePermissions)).build());
        }

        public Builder overrideTags(AssetBundleImportJobOverrideTags var1);

        default public Builder overrideTags(Consumer<AssetBundleImportJobOverrideTags.Builder> overrideTags) {
            return this.overrideTags((AssetBundleImportJobOverrideTags)((AssetBundleImportJobOverrideTags.Builder)AssetBundleImportJobOverrideTags.builder().applyMutation(overrideTags)).build());
        }

        public Builder overrideValidationStrategy(AssetBundleImportJobOverrideValidationStrategy var1);

        default public Builder overrideValidationStrategy(Consumer<AssetBundleImportJobOverrideValidationStrategy.Builder> overrideValidationStrategy) {
            return this.overrideValidationStrategy((AssetBundleImportJobOverrideValidationStrategy)((AssetBundleImportJobOverrideValidationStrategy.Builder)AssetBundleImportJobOverrideValidationStrategy.builder().applyMutation(overrideValidationStrategy)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

