/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.quicksight.model.AssignmentStatus;
import software.amazon.awssdk.services.quicksight.model.IdentityMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IAMPolicyAssignment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IAMPolicyAssignment> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(IAMPolicyAssignment.getter(IAMPolicyAssignment::awsAccountId)).setter(IAMPolicyAssignment.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> ASSIGNMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssignmentId").getter(IAMPolicyAssignment.getter(IAMPolicyAssignment::assignmentId)).setter(IAMPolicyAssignment.setter(Builder::assignmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignmentId").build()}).build();
    private static final SdkField<String> ASSIGNMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssignmentName").getter(IAMPolicyAssignment.getter(IAMPolicyAssignment::assignmentName)).setter(IAMPolicyAssignment.setter(Builder::assignmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignmentName").build()}).build();
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyArn").getter(IAMPolicyAssignment.getter(IAMPolicyAssignment::policyArn)).setter(IAMPolicyAssignment.setter(Builder::policyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyArn").build()}).build();
    private static final SdkField<Map<String, List<String>>> IDENTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Identities").getter(IAMPolicyAssignment.getter(IAMPolicyAssignment::identities)).setter(IAMPolicyAssignment.setter(Builder::identities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identities").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> ASSIGNMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssignmentStatus").getter(IAMPolicyAssignment.getter(IAMPolicyAssignment::assignmentStatusAsString)).setter(IAMPolicyAssignment.setter(Builder::assignmentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignmentStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, ASSIGNMENT_ID_FIELD, ASSIGNMENT_NAME_FIELD, POLICY_ARN_FIELD, IDENTITIES_FIELD, ASSIGNMENT_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
            this.put("AssignmentId", ASSIGNMENT_ID_FIELD);
            this.put("AssignmentName", ASSIGNMENT_NAME_FIELD);
            this.put("PolicyArn", POLICY_ARN_FIELD);
            this.put("Identities", IDENTITIES_FIELD);
            this.put("AssignmentStatus", ASSIGNMENT_STATUS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String awsAccountId;
    private final String assignmentId;
    private final String assignmentName;
    private final String policyArn;
    private final Map<String, List<String>> identities;
    private final String assignmentStatus;

    private IAMPolicyAssignment(BuilderImpl builder) {
        this.awsAccountId = builder.awsAccountId;
        this.assignmentId = builder.assignmentId;
        this.assignmentName = builder.assignmentName;
        this.policyArn = builder.policyArn;
        this.identities = builder.identities;
        this.assignmentStatus = builder.assignmentStatus;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String assignmentId() {
        return this.assignmentId;
    }

    public final String assignmentName() {
        return this.assignmentName;
    }

    public final String policyArn() {
        return this.policyArn;
    }

    public final boolean hasIdentities() {
        return this.identities != null && !(this.identities instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> identities() {
        return this.identities;
    }

    public final AssignmentStatus assignmentStatus() {
        return AssignmentStatus.fromValue(this.assignmentStatus);
    }

    public final String assignmentStatusAsString() {
        return this.assignmentStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assignmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assignmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIdentities() ? this.identities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.assignmentStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IAMPolicyAssignment)) {
            return false;
        }
        IAMPolicyAssignment other = (IAMPolicyAssignment)obj;
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.assignmentId(), other.assignmentId()) && Objects.equals(this.assignmentName(), other.assignmentName()) && Objects.equals(this.policyArn(), other.policyArn()) && this.hasIdentities() == other.hasIdentities() && Objects.equals(this.identities(), other.identities()) && Objects.equals(this.assignmentStatusAsString(), other.assignmentStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"IAMPolicyAssignment").add("AwsAccountId", (Object)this.awsAccountId()).add("AssignmentId", (Object)this.assignmentId()).add("AssignmentName", (Object)this.assignmentName()).add("PolicyArn", (Object)this.policyArn()).add("Identities", this.hasIdentities() ? this.identities() : null).add("AssignmentStatus", (Object)this.assignmentStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "AssignmentId": {
                return Optional.ofNullable(clazz.cast(this.assignmentId()));
            }
            case "AssignmentName": {
                return Optional.ofNullable(clazz.cast(this.assignmentName()));
            }
            case "PolicyArn": {
                return Optional.ofNullable(clazz.cast(this.policyArn()));
            }
            case "Identities": {
                return Optional.ofNullable(clazz.cast(this.identities()));
            }
            case "AssignmentStatus": {
                return Optional.ofNullable(clazz.cast(this.assignmentStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<IAMPolicyAssignment, T> g) {
        return obj -> g.apply((IAMPolicyAssignment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String assignmentId;
        private String assignmentName;
        private String policyArn;
        private Map<String, List<String>> identities = DefaultSdkAutoConstructMap.getInstance();
        private String assignmentStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(IAMPolicyAssignment model) {
            this.awsAccountId(model.awsAccountId);
            this.assignmentId(model.assignmentId);
            this.assignmentName(model.assignmentName);
            this.policyArn(model.policyArn);
            this.identities(model.identities);
            this.assignmentStatus(model.assignmentStatus);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getAssignmentId() {
            return this.assignmentId;
        }

        public final void setAssignmentId(String assignmentId) {
            this.assignmentId = assignmentId;
        }

        @Override
        public final Builder assignmentId(String assignmentId) {
            this.assignmentId = assignmentId;
            return this;
        }

        public final String getAssignmentName() {
            return this.assignmentName;
        }

        public final void setAssignmentName(String assignmentName) {
            this.assignmentName = assignmentName;
        }

        @Override
        public final Builder assignmentName(String assignmentName) {
            this.assignmentName = assignmentName;
            return this;
        }

        public final String getPolicyArn() {
            return this.policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getIdentities() {
            if (this.identities instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.identities;
        }

        public final void setIdentities(Map<String, ? extends Collection<String>> identities) {
            this.identities = IdentityMapCopier.copy(identities);
        }

        @Override
        public final Builder identities(Map<String, ? extends Collection<String>> identities) {
            this.identities = IdentityMapCopier.copy(identities);
            return this;
        }

        public final String getAssignmentStatus() {
            return this.assignmentStatus;
        }

        public final void setAssignmentStatus(String assignmentStatus) {
            this.assignmentStatus = assignmentStatus;
        }

        @Override
        public final Builder assignmentStatus(String assignmentStatus) {
            this.assignmentStatus = assignmentStatus;
            return this;
        }

        @Override
        public final Builder assignmentStatus(AssignmentStatus assignmentStatus) {
            this.assignmentStatus(assignmentStatus == null ? null : assignmentStatus.toString());
            return this;
        }

        public IAMPolicyAssignment build() {
            return new IAMPolicyAssignment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IAMPolicyAssignment> {
        public Builder awsAccountId(String var1);

        public Builder assignmentId(String var1);

        public Builder assignmentName(String var1);

        public Builder policyArn(String var1);

        public Builder identities(Map<String, ? extends Collection<String>> var1);

        public Builder assignmentStatus(String var1);

        public Builder assignmentStatus(AssignmentStatus var1);
    }
}

