/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.KeyRegistrationCopier;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.services.quicksight.model.RegisteredCustomerManagedKey;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeKeyRegistrationResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, DescribeKeyRegistrationResponse> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(DescribeKeyRegistrationResponse.getter(DescribeKeyRegistrationResponse::awsAccountId)).setter(DescribeKeyRegistrationResponse.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsAccountId").build()}).build();
    private static final SdkField<List<RegisteredCustomerManagedKey>> KEY_REGISTRATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("KeyRegistration").getter(DescribeKeyRegistrationResponse.getter(DescribeKeyRegistrationResponse::keyRegistration)).setter(DescribeKeyRegistrationResponse.setter(Builder::keyRegistration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyRegistration").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RegisteredCustomerManagedKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(DescribeKeyRegistrationResponse.getter(DescribeKeyRegistrationResponse::requestId)).setter(DescribeKeyRegistrationResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(DescribeKeyRegistrationResponse.getter(DescribeKeyRegistrationResponse::status)).setter(DescribeKeyRegistrationResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, KEY_REGISTRATION_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
            this.put("KeyRegistration", KEY_REGISTRATION_FIELD);
            this.put("RequestId", REQUEST_ID_FIELD);
            this.put("Status", STATUS_FIELD);
        }
    });
    private final String awsAccountId;
    private final List<RegisteredCustomerManagedKey> keyRegistration;
    private final String requestId;
    private final Integer status;

    private DescribeKeyRegistrationResponse(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.keyRegistration = builder.keyRegistration;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final boolean hasKeyRegistration() {
        return this.keyRegistration != null && !(this.keyRegistration instanceof SdkAutoConstructList);
    }

    public final List<RegisteredCustomerManagedKey> keyRegistration() {
        return this.keyRegistration;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final Integer status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKeyRegistration() ? this.keyRegistration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeKeyRegistrationResponse)) {
            return false;
        }
        DescribeKeyRegistrationResponse other = (DescribeKeyRegistrationResponse)((Object)obj);
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && this.hasKeyRegistration() == other.hasKeyRegistration() && Objects.equals(this.keyRegistration(), other.keyRegistration()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeKeyRegistrationResponse").add("AwsAccountId", (Object)this.awsAccountId()).add("KeyRegistration", this.hasKeyRegistration() ? this.keyRegistration() : null).add("RequestId", (Object)this.requestId()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "KeyRegistration": {
                return Optional.ofNullable(clazz.cast(this.keyRegistration()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeKeyRegistrationResponse, T> g) {
        return obj -> g.apply((DescribeKeyRegistrationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private List<RegisteredCustomerManagedKey> keyRegistration = DefaultSdkAutoConstructList.getInstance();
        private String requestId;
        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeKeyRegistrationResponse model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.keyRegistration(model.keyRegistration);
            this.requestId(model.requestId);
            this.status(model.status);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final List<RegisteredCustomerManagedKey.Builder> getKeyRegistration() {
            List<RegisteredCustomerManagedKey.Builder> result = KeyRegistrationCopier.copyToBuilder(this.keyRegistration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setKeyRegistration(Collection<RegisteredCustomerManagedKey.BuilderImpl> keyRegistration) {
            this.keyRegistration = KeyRegistrationCopier.copyFromBuilder(keyRegistration);
        }

        @Override
        public final Builder keyRegistration(Collection<RegisteredCustomerManagedKey> keyRegistration) {
            this.keyRegistration = KeyRegistrationCopier.copy(keyRegistration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyRegistration(RegisteredCustomerManagedKey ... keyRegistration) {
            this.keyRegistration(Arrays.asList(keyRegistration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyRegistration(Consumer<RegisteredCustomerManagedKey.Builder> ... keyRegistration) {
            this.keyRegistration(Stream.of(keyRegistration).map(c -> (RegisteredCustomerManagedKey)((RegisteredCustomerManagedKey.Builder)RegisteredCustomerManagedKey.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        @Override
        public DescribeKeyRegistrationResponse build() {
            return new DescribeKeyRegistrationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeKeyRegistrationResponse> {
        public Builder awsAccountId(String var1);

        public Builder keyRegistration(Collection<RegisteredCustomerManagedKey> var1);

        public Builder keyRegistration(RegisteredCustomerManagedKey ... var1);

        public Builder keyRegistration(Consumer<RegisteredCustomerManagedKey.Builder> ... var1);

        public Builder requestId(String var1);

        public Builder status(Integer var1);
    }
}

