/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.ColumnOrderingType;
import software.amazon.awssdk.services.quicksight.model.StringListCopier;
import software.amazon.awssdk.services.quicksight.model.UndefinedSpecifiedValueType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComparativeOrder
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComparativeOrder> {
    private static final SdkField<String> USE_ORDERING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UseOrdering").getter(ComparativeOrder.getter(ComparativeOrder::useOrderingAsString)).setter(ComparativeOrder.setter(Builder::useOrdering)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseOrdering").build()}).build();
    private static final SdkField<List<String>> SPECIFED_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SpecifedOrder").getter(ComparativeOrder.getter(ComparativeOrder::specifedOrder)).setter(ComparativeOrder.setter(Builder::specifedOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpecifedOrder").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TREAT_UNDEFINED_SPECIFIED_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TreatUndefinedSpecifiedValues").getter(ComparativeOrder.getter(ComparativeOrder::treatUndefinedSpecifiedValuesAsString)).setter(ComparativeOrder.setter(Builder::treatUndefinedSpecifiedValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TreatUndefinedSpecifiedValues").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USE_ORDERING_FIELD, SPECIFED_ORDER_FIELD, TREAT_UNDEFINED_SPECIFIED_VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("UseOrdering", USE_ORDERING_FIELD);
            this.put("SpecifedOrder", SPECIFED_ORDER_FIELD);
            this.put("TreatUndefinedSpecifiedValues", TREAT_UNDEFINED_SPECIFIED_VALUES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String useOrdering;
    private final List<String> specifedOrder;
    private final String treatUndefinedSpecifiedValues;

    private ComparativeOrder(BuilderImpl builder) {
        this.useOrdering = builder.useOrdering;
        this.specifedOrder = builder.specifedOrder;
        this.treatUndefinedSpecifiedValues = builder.treatUndefinedSpecifiedValues;
    }

    public final ColumnOrderingType useOrdering() {
        return ColumnOrderingType.fromValue(this.useOrdering);
    }

    public final String useOrderingAsString() {
        return this.useOrdering;
    }

    public final boolean hasSpecifedOrder() {
        return this.specifedOrder != null && !(this.specifedOrder instanceof SdkAutoConstructList);
    }

    public final List<String> specifedOrder() {
        return this.specifedOrder;
    }

    public final UndefinedSpecifiedValueType treatUndefinedSpecifiedValues() {
        return UndefinedSpecifiedValueType.fromValue(this.treatUndefinedSpecifiedValues);
    }

    public final String treatUndefinedSpecifiedValuesAsString() {
        return this.treatUndefinedSpecifiedValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.useOrderingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSpecifedOrder() ? this.specifedOrder() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.treatUndefinedSpecifiedValuesAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComparativeOrder)) {
            return false;
        }
        ComparativeOrder other = (ComparativeOrder)obj;
        return Objects.equals(this.useOrderingAsString(), other.useOrderingAsString()) && this.hasSpecifedOrder() == other.hasSpecifedOrder() && Objects.equals(this.specifedOrder(), other.specifedOrder()) && Objects.equals(this.treatUndefinedSpecifiedValuesAsString(), other.treatUndefinedSpecifiedValuesAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ComparativeOrder").add("UseOrdering", (Object)this.useOrderingAsString()).add("SpecifedOrder", this.hasSpecifedOrder() ? this.specifedOrder() : null).add("TreatUndefinedSpecifiedValues", (Object)this.treatUndefinedSpecifiedValuesAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UseOrdering": {
                return Optional.ofNullable(clazz.cast(this.useOrderingAsString()));
            }
            case "SpecifedOrder": {
                return Optional.ofNullable(clazz.cast(this.specifedOrder()));
            }
            case "TreatUndefinedSpecifiedValues": {
                return Optional.ofNullable(clazz.cast(this.treatUndefinedSpecifiedValuesAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ComparativeOrder, T> g) {
        return obj -> g.apply((ComparativeOrder)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String useOrdering;
        private List<String> specifedOrder = DefaultSdkAutoConstructList.getInstance();
        private String treatUndefinedSpecifiedValues;

        private BuilderImpl() {
        }

        private BuilderImpl(ComparativeOrder model) {
            this.useOrdering(model.useOrdering);
            this.specifedOrder(model.specifedOrder);
            this.treatUndefinedSpecifiedValues(model.treatUndefinedSpecifiedValues);
        }

        public final String getUseOrdering() {
            return this.useOrdering;
        }

        public final void setUseOrdering(String useOrdering) {
            this.useOrdering = useOrdering;
        }

        @Override
        public final Builder useOrdering(String useOrdering) {
            this.useOrdering = useOrdering;
            return this;
        }

        @Override
        public final Builder useOrdering(ColumnOrderingType useOrdering) {
            this.useOrdering(useOrdering == null ? null : useOrdering.toString());
            return this;
        }

        public final Collection<String> getSpecifedOrder() {
            if (this.specifedOrder instanceof SdkAutoConstructList) {
                return null;
            }
            return this.specifedOrder;
        }

        public final void setSpecifedOrder(Collection<String> specifedOrder) {
            this.specifedOrder = StringListCopier.copy(specifedOrder);
        }

        @Override
        public final Builder specifedOrder(Collection<String> specifedOrder) {
            this.specifedOrder = StringListCopier.copy(specifedOrder);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder specifedOrder(String ... specifedOrder) {
            this.specifedOrder(Arrays.asList(specifedOrder));
            return this;
        }

        public final String getTreatUndefinedSpecifiedValues() {
            return this.treatUndefinedSpecifiedValues;
        }

        public final void setTreatUndefinedSpecifiedValues(String treatUndefinedSpecifiedValues) {
            this.treatUndefinedSpecifiedValues = treatUndefinedSpecifiedValues;
        }

        @Override
        public final Builder treatUndefinedSpecifiedValues(String treatUndefinedSpecifiedValues) {
            this.treatUndefinedSpecifiedValues = treatUndefinedSpecifiedValues;
            return this;
        }

        @Override
        public final Builder treatUndefinedSpecifiedValues(UndefinedSpecifiedValueType treatUndefinedSpecifiedValues) {
            this.treatUndefinedSpecifiedValues(treatUndefinedSpecifiedValues == null ? null : treatUndefinedSpecifiedValues.toString());
            return this;
        }

        public ComparativeOrder build() {
            return new ComparativeOrder(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComparativeOrder> {
        public Builder useOrdering(String var1);

        public Builder useOrdering(ColumnOrderingType var1);

        public Builder specifedOrder(Collection<String> var1);

        public Builder specifedOrder(String ... var1);

        public Builder treatUndefinedSpecifiedValues(String var1);

        public Builder treatUndefinedSpecifiedValues(UndefinedSpecifiedValueType var1);
    }
}

