/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.ColorFillType;
import software.amazon.awssdk.services.quicksight.model.ColorScaleColorListCopier;
import software.amazon.awssdk.services.quicksight.model.DataColor;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ColorScale
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ColorScale> {
    private static final SdkField<List<DataColor>> COLORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Colors").getter(ColorScale.getter(ColorScale::colors)).setter(ColorScale.setter(Builder::colors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Colors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataColor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> COLOR_FILL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ColorFillType").getter(ColorScale.getter(ColorScale::colorFillTypeAsString)).setter(ColorScale.setter(Builder::colorFillType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColorFillType").build()}).build();
    private static final SdkField<DataColor> NULL_VALUE_COLOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NullValueColor").getter(ColorScale.getter(ColorScale::nullValueColor)).setter(ColorScale.setter(Builder::nullValueColor)).constructor(DataColor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NullValueColor").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLORS_FIELD, COLOR_FILL_TYPE_FIELD, NULL_VALUE_COLOR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Colors", COLORS_FIELD);
            this.put("ColorFillType", COLOR_FILL_TYPE_FIELD);
            this.put("NullValueColor", NULL_VALUE_COLOR_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<DataColor> colors;
    private final String colorFillType;
    private final DataColor nullValueColor;

    private ColorScale(BuilderImpl builder) {
        this.colors = builder.colors;
        this.colorFillType = builder.colorFillType;
        this.nullValueColor = builder.nullValueColor;
    }

    public final boolean hasColors() {
        return this.colors != null && !(this.colors instanceof SdkAutoConstructList);
    }

    public final List<DataColor> colors() {
        return this.colors;
    }

    public final ColorFillType colorFillType() {
        return ColorFillType.fromValue(this.colorFillType);
    }

    public final String colorFillTypeAsString() {
        return this.colorFillType;
    }

    public final DataColor nullValueColor() {
        return this.nullValueColor;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColors() ? this.colors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.colorFillTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nullValueColor());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColorScale)) {
            return false;
        }
        ColorScale other = (ColorScale)obj;
        return this.hasColors() == other.hasColors() && Objects.equals(this.colors(), other.colors()) && Objects.equals(this.colorFillTypeAsString(), other.colorFillTypeAsString()) && Objects.equals(this.nullValueColor(), other.nullValueColor());
    }

    public final String toString() {
        return ToString.builder((String)"ColorScale").add("Colors", this.hasColors() ? this.colors() : null).add("ColorFillType", (Object)this.colorFillTypeAsString()).add("NullValueColor", (Object)this.nullValueColor()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Colors": {
                return Optional.ofNullable(clazz.cast(this.colors()));
            }
            case "ColorFillType": {
                return Optional.ofNullable(clazz.cast(this.colorFillTypeAsString()));
            }
            case "NullValueColor": {
                return Optional.ofNullable(clazz.cast(this.nullValueColor()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ColorScale, T> g) {
        return obj -> g.apply((ColorScale)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<DataColor> colors = DefaultSdkAutoConstructList.getInstance();
        private String colorFillType;
        private DataColor nullValueColor;

        private BuilderImpl() {
        }

        private BuilderImpl(ColorScale model) {
            this.colors(model.colors);
            this.colorFillType(model.colorFillType);
            this.nullValueColor(model.nullValueColor);
        }

        public final List<DataColor.Builder> getColors() {
            List<DataColor.Builder> result = ColorScaleColorListCopier.copyToBuilder(this.colors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColors(Collection<DataColor.BuilderImpl> colors) {
            this.colors = ColorScaleColorListCopier.copyFromBuilder(colors);
        }

        @Override
        public final Builder colors(Collection<DataColor> colors) {
            this.colors = ColorScaleColorListCopier.copy(colors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder colors(DataColor ... colors) {
            this.colors(Arrays.asList(colors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder colors(Consumer<DataColor.Builder> ... colors) {
            this.colors(Stream.of(colors).map(c -> (DataColor)((DataColor.Builder)DataColor.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getColorFillType() {
            return this.colorFillType;
        }

        public final void setColorFillType(String colorFillType) {
            this.colorFillType = colorFillType;
        }

        @Override
        public final Builder colorFillType(String colorFillType) {
            this.colorFillType = colorFillType;
            return this;
        }

        @Override
        public final Builder colorFillType(ColorFillType colorFillType) {
            this.colorFillType(colorFillType == null ? null : colorFillType.toString());
            return this;
        }

        public final DataColor.Builder getNullValueColor() {
            return this.nullValueColor != null ? this.nullValueColor.toBuilder() : null;
        }

        public final void setNullValueColor(DataColor.BuilderImpl nullValueColor) {
            this.nullValueColor = nullValueColor != null ? nullValueColor.build() : null;
        }

        @Override
        public final Builder nullValueColor(DataColor nullValueColor) {
            this.nullValueColor = nullValueColor;
            return this;
        }

        public ColorScale build() {
            return new ColorScale(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ColorScale> {
        public Builder colors(Collection<DataColor> var1);

        public Builder colors(DataColor ... var1);

        public Builder colors(Consumer<DataColor.Builder> ... var1);

        public Builder colorFillType(String var1);

        public Builder colorFillType(ColorFillType var1);

        public Builder nullValueColor(DataColor var1);

        default public Builder nullValueColor(Consumer<DataColor.Builder> nullValueColor) {
            return this.nullValueColor((DataColor)((DataColor.Builder)DataColor.builder().applyMutation(nullValueColor)).build());
        }
    }
}

