/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.AssetBundleExportJobDataSetPropertyToOverride;
import software.amazon.awssdk.services.quicksight.model.AssetBundleExportJobDataSetPropertyToOverrideListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssetBundleExportJobDataSetOverrideProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssetBundleExportJobDataSetOverrideProperties> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(AssetBundleExportJobDataSetOverrideProperties.getter(AssetBundleExportJobDataSetOverrideProperties::arn)).setter(AssetBundleExportJobDataSetOverrideProperties.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<List<String>> PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Properties").getter(AssetBundleExportJobDataSetOverrideProperties.getter(AssetBundleExportJobDataSetOverrideProperties::propertiesAsStrings)).setter(AssetBundleExportJobDataSetOverrideProperties.setter(Builder::propertiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Properties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Arn", ARN_FIELD);
            this.put("Properties", PROPERTIES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final List<String> properties;

    private AssetBundleExportJobDataSetOverrideProperties(BuilderImpl builder) {
        this.arn = builder.arn;
        this.properties = builder.properties;
    }

    public final String arn() {
        return this.arn;
    }

    public final List<AssetBundleExportJobDataSetPropertyToOverride> properties() {
        return AssetBundleExportJobDataSetPropertyToOverrideListCopier.copyStringToEnum(this.properties);
    }

    public final boolean hasProperties() {
        return this.properties != null && !(this.properties instanceof SdkAutoConstructList);
    }

    public final List<String> propertiesAsStrings() {
        return this.properties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProperties() ? this.propertiesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetBundleExportJobDataSetOverrideProperties)) {
            return false;
        }
        AssetBundleExportJobDataSetOverrideProperties other = (AssetBundleExportJobDataSetOverrideProperties)obj;
        return Objects.equals(this.arn(), other.arn()) && this.hasProperties() == other.hasProperties() && Objects.equals(this.propertiesAsStrings(), other.propertiesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"AssetBundleExportJobDataSetOverrideProperties").add("Arn", (Object)this.arn()).add("Properties", this.hasProperties() ? this.propertiesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Properties": {
                return Optional.ofNullable(clazz.cast(this.propertiesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AssetBundleExportJobDataSetOverrideProperties, T> g) {
        return obj -> g.apply((AssetBundleExportJobDataSetOverrideProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private List<String> properties = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssetBundleExportJobDataSetOverrideProperties model) {
            this.arn(model.arn);
            this.propertiesWithStrings(model.properties);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Collection<String> getProperties() {
            if (this.properties instanceof SdkAutoConstructList) {
                return null;
            }
            return this.properties;
        }

        public final void setProperties(Collection<String> properties) {
            this.properties = AssetBundleExportJobDataSetPropertyToOverrideListCopier.copy(properties);
        }

        @Override
        public final Builder propertiesWithStrings(Collection<String> properties) {
            this.properties = AssetBundleExportJobDataSetPropertyToOverrideListCopier.copy(properties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertiesWithStrings(String ... properties) {
            this.propertiesWithStrings(Arrays.asList(properties));
            return this;
        }

        @Override
        public final Builder properties(Collection<AssetBundleExportJobDataSetPropertyToOverride> properties) {
            this.properties = AssetBundleExportJobDataSetPropertyToOverrideListCopier.copyEnumToString(properties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder properties(AssetBundleExportJobDataSetPropertyToOverride ... properties) {
            this.properties(Arrays.asList(properties));
            return this;
        }

        public AssetBundleExportJobDataSetOverrideProperties build() {
            return new AssetBundleExportJobDataSetOverrideProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssetBundleExportJobDataSetOverrideProperties> {
        public Builder arn(String var1);

        public Builder propertiesWithStrings(Collection<String> var1);

        public Builder propertiesWithStrings(String ... var1);

        public Builder properties(Collection<AssetBundleExportJobDataSetPropertyToOverride> var1);

        public Builder properties(AssetBundleExportJobDataSetPropertyToOverride ... var1);
    }
}

