/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.IdentityCenterConfiguration;
import software.amazon.awssdk.services.quicksight.model.RedshiftIAMParameters;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RedshiftParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RedshiftParameters> {
    private static final SdkField<String> HOST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Host").getter(RedshiftParameters.getter(RedshiftParameters::host)).setter(RedshiftParameters.setter(Builder::host)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Host").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(RedshiftParameters.getter(RedshiftParameters::port)).setter(RedshiftParameters.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> DATABASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Database").getter(RedshiftParameters.getter(RedshiftParameters::database)).setter(RedshiftParameters.setter(Builder::database)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()}).build();
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterId").getter(RedshiftParameters.getter(RedshiftParameters::clusterId)).setter(RedshiftParameters.setter(Builder::clusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterId").build()}).build();
    private static final SdkField<RedshiftIAMParameters> IAM_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IAMParameters").getter(RedshiftParameters.getter(RedshiftParameters::iamParameters)).setter(RedshiftParameters.setter(Builder::iamParameters)).constructor(RedshiftIAMParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IAMParameters").build()}).build();
    private static final SdkField<IdentityCenterConfiguration> IDENTITY_CENTER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IdentityCenterConfiguration").getter(RedshiftParameters.getter(RedshiftParameters::identityCenterConfiguration)).setter(RedshiftParameters.setter(Builder::identityCenterConfiguration)).constructor(IdentityCenterConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityCenterConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_FIELD, PORT_FIELD, DATABASE_FIELD, CLUSTER_ID_FIELD, IAM_PARAMETERS_FIELD, IDENTITY_CENTER_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String host;
    private final Integer port;
    private final String database;
    private final String clusterId;
    private final RedshiftIAMParameters iamParameters;
    private final IdentityCenterConfiguration identityCenterConfiguration;

    private RedshiftParameters(BuilderImpl builder) {
        this.host = builder.host;
        this.port = builder.port;
        this.database = builder.database;
        this.clusterId = builder.clusterId;
        this.iamParameters = builder.iamParameters;
        this.identityCenterConfiguration = builder.identityCenterConfiguration;
    }

    public final String host() {
        return this.host;
    }

    public final Integer port() {
        return this.port;
    }

    public final String database() {
        return this.database;
    }

    public final String clusterId() {
        return this.clusterId;
    }

    public final RedshiftIAMParameters iamParameters() {
        return this.iamParameters;
    }

    public final IdentityCenterConfiguration identityCenterConfiguration() {
        return this.identityCenterConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.host());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.database());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityCenterConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftParameters)) {
            return false;
        }
        RedshiftParameters other = (RedshiftParameters)obj;
        return Objects.equals(this.host(), other.host()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.database(), other.database()) && Objects.equals(this.clusterId(), other.clusterId()) && Objects.equals(this.iamParameters(), other.iamParameters()) && Objects.equals(this.identityCenterConfiguration(), other.identityCenterConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"RedshiftParameters").add("Host", (Object)this.host()).add("Port", (Object)this.port()).add("Database", (Object)this.database()).add("ClusterId", (Object)this.clusterId()).add("IAMParameters", (Object)this.iamParameters()).add("IdentityCenterConfiguration", (Object)this.identityCenterConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Host": {
                return Optional.ofNullable(clazz.cast(this.host()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "Database": {
                return Optional.ofNullable(clazz.cast(this.database()));
            }
            case "ClusterId": {
                return Optional.ofNullable(clazz.cast(this.clusterId()));
            }
            case "IAMParameters": {
                return Optional.ofNullable(clazz.cast(this.iamParameters()));
            }
            case "IdentityCenterConfiguration": {
                return Optional.ofNullable(clazz.cast(this.identityCenterConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RedshiftParameters, T> g) {
        return obj -> g.apply((RedshiftParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String host;
        private Integer port;
        private String database;
        private String clusterId;
        private RedshiftIAMParameters iamParameters;
        private IdentityCenterConfiguration identityCenterConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftParameters model) {
            this.host(model.host);
            this.port(model.port);
            this.database(model.database);
            this.clusterId(model.clusterId);
            this.iamParameters(model.iamParameters);
            this.identityCenterConfiguration(model.identityCenterConfiguration);
        }

        public final String getHost() {
            return this.host;
        }

        public final void setHost(String host) {
            this.host = host;
        }

        @Override
        public final Builder host(String host) {
            this.host = host;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getDatabase() {
            return this.database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final RedshiftIAMParameters.Builder getIamParameters() {
            return this.iamParameters != null ? this.iamParameters.toBuilder() : null;
        }

        public final void setIamParameters(RedshiftIAMParameters.BuilderImpl iamParameters) {
            this.iamParameters = iamParameters != null ? iamParameters.build() : null;
        }

        @Override
        public final Builder iamParameters(RedshiftIAMParameters iamParameters) {
            this.iamParameters = iamParameters;
            return this;
        }

        public final IdentityCenterConfiguration.Builder getIdentityCenterConfiguration() {
            return this.identityCenterConfiguration != null ? this.identityCenterConfiguration.toBuilder() : null;
        }

        public final void setIdentityCenterConfiguration(IdentityCenterConfiguration.BuilderImpl identityCenterConfiguration) {
            this.identityCenterConfiguration = identityCenterConfiguration != null ? identityCenterConfiguration.build() : null;
        }

        @Override
        public final Builder identityCenterConfiguration(IdentityCenterConfiguration identityCenterConfiguration) {
            this.identityCenterConfiguration = identityCenterConfiguration;
            return this;
        }

        public RedshiftParameters build() {
            return new RedshiftParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RedshiftParameters> {
        public Builder host(String var1);

        public Builder port(Integer var1);

        public Builder database(String var1);

        public Builder clusterId(String var1);

        public Builder iamParameters(RedshiftIAMParameters var1);

        default public Builder iamParameters(Consumer<RedshiftIAMParameters.Builder> iamParameters) {
            return this.iamParameters((RedshiftIAMParameters)((RedshiftIAMParameters.Builder)RedshiftIAMParameters.builder().applyMutation(iamParameters)).build());
        }

        public Builder identityCenterConfiguration(IdentityCenterConfiguration var1);

        default public Builder identityCenterConfiguration(Consumer<IdentityCenterConfiguration.Builder> identityCenterConfiguration) {
            return this.identityCenterConfiguration((IdentityCenterConfiguration)((IdentityCenterConfiguration.Builder)IdentityCenterConfiguration.builder().applyMutation(identityCenterConfiguration)).build());
        }
    }
}

