/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.AxisLinearScale;
import software.amazon.awssdk.services.quicksight.model.AxisLogarithmicScale;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AxisScale
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AxisScale> {
    private static final SdkField<AxisLinearScale> LINEAR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Linear").getter(AxisScale.getter(AxisScale::linear)).setter(AxisScale.setter(Builder::linear)).constructor(AxisLinearScale::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Linear").build()}).build();
    private static final SdkField<AxisLogarithmicScale> LOGARITHMIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Logarithmic").getter(AxisScale.getter(AxisScale::logarithmic)).setter(AxisScale.setter(Builder::logarithmic)).constructor(AxisLogarithmicScale::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Logarithmic").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LINEAR_FIELD, LOGARITHMIC_FIELD));
    private static final long serialVersionUID = 1L;
    private final AxisLinearScale linear;
    private final AxisLogarithmicScale logarithmic;

    private AxisScale(BuilderImpl builder) {
        this.linear = builder.linear;
        this.logarithmic = builder.logarithmic;
    }

    public final AxisLinearScale linear() {
        return this.linear;
    }

    public final AxisLogarithmicScale logarithmic() {
        return this.logarithmic;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.linear());
        hashCode = 31 * hashCode + Objects.hashCode(this.logarithmic());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AxisScale)) {
            return false;
        }
        AxisScale other = (AxisScale)obj;
        return Objects.equals(this.linear(), other.linear()) && Objects.equals(this.logarithmic(), other.logarithmic());
    }

    public final String toString() {
        return ToString.builder((String)"AxisScale").add("Linear", (Object)this.linear()).add("Logarithmic", (Object)this.logarithmic()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Linear": {
                return Optional.ofNullable(clazz.cast(this.linear()));
            }
            case "Logarithmic": {
                return Optional.ofNullable(clazz.cast(this.logarithmic()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AxisScale, T> g) {
        return obj -> g.apply((AxisScale)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AxisLinearScale linear;
        private AxisLogarithmicScale logarithmic;

        private BuilderImpl() {
        }

        private BuilderImpl(AxisScale model) {
            this.linear(model.linear);
            this.logarithmic(model.logarithmic);
        }

        public final AxisLinearScale.Builder getLinear() {
            return this.linear != null ? this.linear.toBuilder() : null;
        }

        public final void setLinear(AxisLinearScale.BuilderImpl linear) {
            this.linear = linear != null ? linear.build() : null;
        }

        @Override
        public final Builder linear(AxisLinearScale linear) {
            this.linear = linear;
            return this;
        }

        public final AxisLogarithmicScale.Builder getLogarithmic() {
            return this.logarithmic != null ? this.logarithmic.toBuilder() : null;
        }

        public final void setLogarithmic(AxisLogarithmicScale.BuilderImpl logarithmic) {
            this.logarithmic = logarithmic != null ? logarithmic.build() : null;
        }

        @Override
        public final Builder logarithmic(AxisLogarithmicScale logarithmic) {
            this.logarithmic = logarithmic;
            return this;
        }

        public AxisScale build() {
            return new AxisScale(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AxisScale> {
        public Builder linear(AxisLinearScale var1);

        default public Builder linear(Consumer<AxisLinearScale.Builder> linear) {
            return this.linear((AxisLinearScale)((AxisLinearScale.Builder)AxisLinearScale.builder().applyMutation(linear)).build());
        }

        public Builder logarithmic(AxisLogarithmicScale var1);

        default public Builder logarithmic(Consumer<AxisLogarithmicScale.Builder> logarithmic) {
            return this.logarithmic((AxisLogarithmicScale)((AxisLogarithmicScale.Builder)AxisLogarithmicScale.builder().applyMutation(logarithmic)).build());
        }
    }
}

