/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.KeyRegistrationCopier;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.services.quicksight.model.RegisteredCustomerManagedKey;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateKeyRegistrationRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, UpdateKeyRegistrationRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(UpdateKeyRegistrationRequest.getter(UpdateKeyRegistrationRequest::awsAccountId)).setter(UpdateKeyRegistrationRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<List<RegisteredCustomerManagedKey>> KEY_REGISTRATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("KeyRegistration").getter(UpdateKeyRegistrationRequest.getter(UpdateKeyRegistrationRequest::keyRegistration)).setter(UpdateKeyRegistrationRequest.setter(Builder::keyRegistration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyRegistration").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RegisteredCustomerManagedKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, KEY_REGISTRATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
            this.put("KeyRegistration", KEY_REGISTRATION_FIELD);
        }
    });
    private final String awsAccountId;
    private final List<RegisteredCustomerManagedKey> keyRegistration;

    private UpdateKeyRegistrationRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.keyRegistration = builder.keyRegistration;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final boolean hasKeyRegistration() {
        return this.keyRegistration != null && !(this.keyRegistration instanceof SdkAutoConstructList);
    }

    public final List<RegisteredCustomerManagedKey> keyRegistration() {
        return this.keyRegistration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKeyRegistration() ? this.keyRegistration() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateKeyRegistrationRequest)) {
            return false;
        }
        UpdateKeyRegistrationRequest other = (UpdateKeyRegistrationRequest)((Object)obj);
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && this.hasKeyRegistration() == other.hasKeyRegistration() && Objects.equals(this.keyRegistration(), other.keyRegistration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateKeyRegistrationRequest").add("AwsAccountId", (Object)this.awsAccountId()).add("KeyRegistration", this.hasKeyRegistration() ? this.keyRegistration() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "KeyRegistration": {
                return Optional.ofNullable(clazz.cast(this.keyRegistration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateKeyRegistrationRequest, T> g) {
        return obj -> g.apply((UpdateKeyRegistrationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private List<RegisteredCustomerManagedKey> keyRegistration = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateKeyRegistrationRequest model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.keyRegistration(model.keyRegistration);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final List<RegisteredCustomerManagedKey.Builder> getKeyRegistration() {
            List<RegisteredCustomerManagedKey.Builder> result = KeyRegistrationCopier.copyToBuilder(this.keyRegistration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setKeyRegistration(Collection<RegisteredCustomerManagedKey.BuilderImpl> keyRegistration) {
            this.keyRegistration = KeyRegistrationCopier.copyFromBuilder(keyRegistration);
        }

        @Override
        public final Builder keyRegistration(Collection<RegisteredCustomerManagedKey> keyRegistration) {
            this.keyRegistration = KeyRegistrationCopier.copy(keyRegistration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyRegistration(RegisteredCustomerManagedKey ... keyRegistration) {
            this.keyRegistration(Arrays.asList(keyRegistration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyRegistration(Consumer<RegisteredCustomerManagedKey.Builder> ... keyRegistration) {
            this.keyRegistration(Stream.of(keyRegistration).map(c -> (RegisteredCustomerManagedKey)((RegisteredCustomerManagedKey.Builder)RegisteredCustomerManagedKey.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateKeyRegistrationRequest build() {
            return new UpdateKeyRegistrationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateKeyRegistrationRequest> {
        public Builder awsAccountId(String var1);

        public Builder keyRegistration(Collection<RegisteredCustomerManagedKey> var1);

        public Builder keyRegistration(RegisteredCustomerManagedKey ... var1);

        public Builder keyRegistration(Consumer<RegisteredCustomerManagedKey.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

