/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.FieldSortOptions;
import software.amazon.awssdk.services.quicksight.model.FieldSortOptionsListCopier;
import software.amazon.awssdk.services.quicksight.model.ItemsLimitConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TreeMapSortConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TreeMapSortConfiguration> {
    private static final SdkField<List<FieldSortOptions>> TREE_MAP_SORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TreeMapSort").getter(TreeMapSortConfiguration.getter(TreeMapSortConfiguration::treeMapSort)).setter(TreeMapSortConfiguration.setter(Builder::treeMapSort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TreeMapSort").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FieldSortOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ItemsLimitConfiguration> TREE_MAP_GROUP_ITEMS_LIMIT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TreeMapGroupItemsLimitConfiguration").getter(TreeMapSortConfiguration.getter(TreeMapSortConfiguration::treeMapGroupItemsLimitConfiguration)).setter(TreeMapSortConfiguration.setter(Builder::treeMapGroupItemsLimitConfiguration)).constructor(ItemsLimitConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TreeMapGroupItemsLimitConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TREE_MAP_SORT_FIELD, TREE_MAP_GROUP_ITEMS_LIMIT_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TreeMapSort", TREE_MAP_SORT_FIELD);
            this.put("TreeMapGroupItemsLimitConfiguration", TREE_MAP_GROUP_ITEMS_LIMIT_CONFIGURATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<FieldSortOptions> treeMapSort;
    private final ItemsLimitConfiguration treeMapGroupItemsLimitConfiguration;

    private TreeMapSortConfiguration(BuilderImpl builder) {
        this.treeMapSort = builder.treeMapSort;
        this.treeMapGroupItemsLimitConfiguration = builder.treeMapGroupItemsLimitConfiguration;
    }

    public final boolean hasTreeMapSort() {
        return this.treeMapSort != null && !(this.treeMapSort instanceof SdkAutoConstructList);
    }

    public final List<FieldSortOptions> treeMapSort() {
        return this.treeMapSort;
    }

    public final ItemsLimitConfiguration treeMapGroupItemsLimitConfiguration() {
        return this.treeMapGroupItemsLimitConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTreeMapSort() ? this.treeMapSort() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.treeMapGroupItemsLimitConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TreeMapSortConfiguration)) {
            return false;
        }
        TreeMapSortConfiguration other = (TreeMapSortConfiguration)obj;
        return this.hasTreeMapSort() == other.hasTreeMapSort() && Objects.equals(this.treeMapSort(), other.treeMapSort()) && Objects.equals(this.treeMapGroupItemsLimitConfiguration(), other.treeMapGroupItemsLimitConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"TreeMapSortConfiguration").add("TreeMapSort", this.hasTreeMapSort() ? this.treeMapSort() : null).add("TreeMapGroupItemsLimitConfiguration", (Object)this.treeMapGroupItemsLimitConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TreeMapSort": {
                return Optional.ofNullable(clazz.cast(this.treeMapSort()));
            }
            case "TreeMapGroupItemsLimitConfiguration": {
                return Optional.ofNullable(clazz.cast(this.treeMapGroupItemsLimitConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TreeMapSortConfiguration, T> g) {
        return obj -> g.apply((TreeMapSortConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<FieldSortOptions> treeMapSort = DefaultSdkAutoConstructList.getInstance();
        private ItemsLimitConfiguration treeMapGroupItemsLimitConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(TreeMapSortConfiguration model) {
            this.treeMapSort(model.treeMapSort);
            this.treeMapGroupItemsLimitConfiguration(model.treeMapGroupItemsLimitConfiguration);
        }

        public final List<FieldSortOptions.Builder> getTreeMapSort() {
            List<FieldSortOptions.Builder> result = FieldSortOptionsListCopier.copyToBuilder(this.treeMapSort);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTreeMapSort(Collection<FieldSortOptions.BuilderImpl> treeMapSort) {
            this.treeMapSort = FieldSortOptionsListCopier.copyFromBuilder(treeMapSort);
        }

        @Override
        public final Builder treeMapSort(Collection<FieldSortOptions> treeMapSort) {
            this.treeMapSort = FieldSortOptionsListCopier.copy(treeMapSort);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder treeMapSort(FieldSortOptions ... treeMapSort) {
            this.treeMapSort(Arrays.asList(treeMapSort));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder treeMapSort(Consumer<FieldSortOptions.Builder> ... treeMapSort) {
            this.treeMapSort(Stream.of(treeMapSort).map(c -> (FieldSortOptions)((FieldSortOptions.Builder)FieldSortOptions.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ItemsLimitConfiguration.Builder getTreeMapGroupItemsLimitConfiguration() {
            return this.treeMapGroupItemsLimitConfiguration != null ? this.treeMapGroupItemsLimitConfiguration.toBuilder() : null;
        }

        public final void setTreeMapGroupItemsLimitConfiguration(ItemsLimitConfiguration.BuilderImpl treeMapGroupItemsLimitConfiguration) {
            this.treeMapGroupItemsLimitConfiguration = treeMapGroupItemsLimitConfiguration != null ? treeMapGroupItemsLimitConfiguration.build() : null;
        }

        @Override
        public final Builder treeMapGroupItemsLimitConfiguration(ItemsLimitConfiguration treeMapGroupItemsLimitConfiguration) {
            this.treeMapGroupItemsLimitConfiguration = treeMapGroupItemsLimitConfiguration;
            return this;
        }

        public TreeMapSortConfiguration build() {
            return new TreeMapSortConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TreeMapSortConfiguration> {
        public Builder treeMapSort(Collection<FieldSortOptions> var1);

        public Builder treeMapSort(FieldSortOptions ... var1);

        public Builder treeMapSort(Consumer<FieldSortOptions.Builder> ... var1);

        public Builder treeMapGroupItemsLimitConfiguration(ItemsLimitConfiguration var1);

        default public Builder treeMapGroupItemsLimitConfiguration(Consumer<ItemsLimitConfiguration.Builder> treeMapGroupItemsLimitConfiguration) {
            return this.treeMapGroupItemsLimitConfiguration((ItemsLimitConfiguration)((ItemsLimitConfiguration.Builder)ItemsLimitConfiguration.builder().applyMutation(treeMapGroupItemsLimitConfiguration)).build());
        }
    }
}

