/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.StaticFileS3SourceOptions;
import software.amazon.awssdk.services.quicksight.model.StaticFileUrlSourceOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StaticFileSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StaticFileSource> {
    private static final SdkField<StaticFileUrlSourceOptions> URL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UrlOptions").getter(StaticFileSource.getter(StaticFileSource::urlOptions)).setter(StaticFileSource.setter(Builder::urlOptions)).constructor(StaticFileUrlSourceOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UrlOptions").build()}).build();
    private static final SdkField<StaticFileS3SourceOptions> S3_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3Options").getter(StaticFileSource.getter(StaticFileSource::s3Options)).setter(StaticFileSource.setter(Builder::s3Options)).constructor(StaticFileS3SourceOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Options").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URL_OPTIONS_FIELD, S3_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("UrlOptions", URL_OPTIONS_FIELD);
            this.put("S3Options", S3_OPTIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final StaticFileUrlSourceOptions urlOptions;
    private final StaticFileS3SourceOptions s3Options;

    private StaticFileSource(BuilderImpl builder) {
        this.urlOptions = builder.urlOptions;
        this.s3Options = builder.s3Options;
    }

    public final StaticFileUrlSourceOptions urlOptions() {
        return this.urlOptions;
    }

    public final StaticFileS3SourceOptions s3Options() {
        return this.s3Options;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.urlOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Options());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StaticFileSource)) {
            return false;
        }
        StaticFileSource other = (StaticFileSource)obj;
        return Objects.equals(this.urlOptions(), other.urlOptions()) && Objects.equals(this.s3Options(), other.s3Options());
    }

    public final String toString() {
        return ToString.builder((String)"StaticFileSource").add("UrlOptions", (Object)this.urlOptions()).add("S3Options", (Object)this.s3Options()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UrlOptions": {
                return Optional.ofNullable(clazz.cast(this.urlOptions()));
            }
            case "S3Options": {
                return Optional.ofNullable(clazz.cast(this.s3Options()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StaticFileSource, T> g) {
        return obj -> g.apply((StaticFileSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private StaticFileUrlSourceOptions urlOptions;
        private StaticFileS3SourceOptions s3Options;

        private BuilderImpl() {
        }

        private BuilderImpl(StaticFileSource model) {
            this.urlOptions(model.urlOptions);
            this.s3Options(model.s3Options);
        }

        public final StaticFileUrlSourceOptions.Builder getUrlOptions() {
            return this.urlOptions != null ? this.urlOptions.toBuilder() : null;
        }

        public final void setUrlOptions(StaticFileUrlSourceOptions.BuilderImpl urlOptions) {
            this.urlOptions = urlOptions != null ? urlOptions.build() : null;
        }

        @Override
        public final Builder urlOptions(StaticFileUrlSourceOptions urlOptions) {
            this.urlOptions = urlOptions;
            return this;
        }

        public final StaticFileS3SourceOptions.Builder getS3Options() {
            return this.s3Options != null ? this.s3Options.toBuilder() : null;
        }

        public final void setS3Options(StaticFileS3SourceOptions.BuilderImpl s3Options) {
            this.s3Options = s3Options != null ? s3Options.build() : null;
        }

        @Override
        public final Builder s3Options(StaticFileS3SourceOptions s3Options) {
            this.s3Options = s3Options;
            return this;
        }

        public StaticFileSource build() {
            return new StaticFileSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StaticFileSource> {
        public Builder urlOptions(StaticFileUrlSourceOptions var1);

        default public Builder urlOptions(Consumer<StaticFileUrlSourceOptions.Builder> urlOptions) {
            return this.urlOptions((StaticFileUrlSourceOptions)((StaticFileUrlSourceOptions.Builder)StaticFileUrlSourceOptions.builder().applyMutation(urlOptions)).build());
        }

        public Builder s3Options(StaticFileS3SourceOptions var1);

        default public Builder s3Options(Consumer<StaticFileS3SourceOptions.Builder> s3Options) {
            return this.s3Options((StaticFileS3SourceOptions)((StaticFileS3SourceOptions.Builder)StaticFileS3SourceOptions.builder().applyMutation(s3Options)).build());
        }
    }
}

