/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.DataSourceSummary;
import software.amazon.awssdk.services.quicksight.model.DataSourceSummaryListCopier;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchDataSourcesResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, SearchDataSourcesResponse> {
    private static final SdkField<List<DataSourceSummary>> DATA_SOURCE_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DataSourceSummaries").getter(SearchDataSourcesResponse.getter(SearchDataSourcesResponse::dataSourceSummaries)).setter(SearchDataSourcesResponse.setter(Builder::dataSourceSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSourceSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(SearchDataSourcesResponse.getter(SearchDataSourcesResponse::nextToken)).setter(SearchDataSourcesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(SearchDataSourcesResponse.getter(SearchDataSourcesResponse::status)).setter(SearchDataSourcesResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(SearchDataSourcesResponse.getter(SearchDataSourcesResponse::requestId)).setter(SearchDataSourcesResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_SUMMARIES_FIELD, NEXT_TOKEN_FIELD, STATUS_FIELD, REQUEST_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DataSourceSummaries", DATA_SOURCE_SUMMARIES_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("RequestId", REQUEST_ID_FIELD);
        }
    });
    private final List<DataSourceSummary> dataSourceSummaries;
    private final String nextToken;
    private final Integer status;
    private final String requestId;

    private SearchDataSourcesResponse(BuilderImpl builder) {
        super(builder);
        this.dataSourceSummaries = builder.dataSourceSummaries;
        this.nextToken = builder.nextToken;
        this.status = builder.status;
        this.requestId = builder.requestId;
    }

    public final boolean hasDataSourceSummaries() {
        return this.dataSourceSummaries != null && !(this.dataSourceSummaries instanceof SdkAutoConstructList);
    }

    public final List<DataSourceSummary> dataSourceSummaries() {
        return this.dataSourceSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer status() {
        return this.status;
    }

    public final String requestId() {
        return this.requestId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataSourceSummaries() ? this.dataSourceSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchDataSourcesResponse)) {
            return false;
        }
        SearchDataSourcesResponse other = (SearchDataSourcesResponse)((Object)obj);
        return this.hasDataSourceSummaries() == other.hasDataSourceSummaries() && Objects.equals(this.dataSourceSummaries(), other.dataSourceSummaries()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.requestId(), other.requestId());
    }

    public final String toString() {
        return ToString.builder((String)"SearchDataSourcesResponse").add("DataSourceSummaries", this.hasDataSourceSummaries() ? this.dataSourceSummaries() : null).add("NextToken", (Object)this.nextToken()).add("Status", (Object)this.status()).add("RequestId", (Object)this.requestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSourceSummaries": {
                return Optional.ofNullable(clazz.cast(this.dataSourceSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SearchDataSourcesResponse, T> g) {
        return obj -> g.apply((SearchDataSourcesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private List<DataSourceSummary> dataSourceSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer status;
        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchDataSourcesResponse model) {
            super(model);
            this.dataSourceSummaries(model.dataSourceSummaries);
            this.nextToken(model.nextToken);
            this.status(model.status);
            this.requestId(model.requestId);
        }

        public final List<DataSourceSummary.Builder> getDataSourceSummaries() {
            List<DataSourceSummary.Builder> result = DataSourceSummaryListCopier.copyToBuilder(this.dataSourceSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataSourceSummaries(Collection<DataSourceSummary.BuilderImpl> dataSourceSummaries) {
            this.dataSourceSummaries = DataSourceSummaryListCopier.copyFromBuilder(dataSourceSummaries);
        }

        @Override
        public final Builder dataSourceSummaries(Collection<DataSourceSummary> dataSourceSummaries) {
            this.dataSourceSummaries = DataSourceSummaryListCopier.copy(dataSourceSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSourceSummaries(DataSourceSummary ... dataSourceSummaries) {
            this.dataSourceSummaries(Arrays.asList(dataSourceSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSourceSummaries(Consumer<DataSourceSummary.Builder> ... dataSourceSummaries) {
            this.dataSourceSummaries(Stream.of(dataSourceSummaries).map(c -> (DataSourceSummary)((DataSourceSummary.Builder)DataSourceSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public SearchDataSourcesResponse build() {
            return new SearchDataSourcesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchDataSourcesResponse> {
        public Builder dataSourceSummaries(Collection<DataSourceSummary> var1);

        public Builder dataSourceSummaries(DataSourceSummary ... var1);

        public Builder dataSourceSummaries(Consumer<DataSourceSummary.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder status(Integer var1);

        public Builder requestId(String var1);
    }
}

