/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.JoinInstruction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LogicalTableSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LogicalTableSource> {
    private static final SdkField<JoinInstruction> JOIN_INSTRUCTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("JoinInstruction").getter(LogicalTableSource.getter(LogicalTableSource::joinInstruction)).setter(LogicalTableSource.setter(Builder::joinInstruction)).constructor(JoinInstruction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JoinInstruction").build()}).build();
    private static final SdkField<String> PHYSICAL_TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PhysicalTableId").getter(LogicalTableSource.getter(LogicalTableSource::physicalTableId)).setter(LogicalTableSource.setter(Builder::physicalTableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhysicalTableId").build()}).build();
    private static final SdkField<String> DATA_SET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSetArn").getter(LogicalTableSource.getter(LogicalTableSource::dataSetArn)).setter(LogicalTableSource.setter(Builder::dataSetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOIN_INSTRUCTION_FIELD, PHYSICAL_TABLE_ID_FIELD, DATA_SET_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("JoinInstruction", JOIN_INSTRUCTION_FIELD);
            this.put("PhysicalTableId", PHYSICAL_TABLE_ID_FIELD);
            this.put("DataSetArn", DATA_SET_ARN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final JoinInstruction joinInstruction;
    private final String physicalTableId;
    private final String dataSetArn;

    private LogicalTableSource(BuilderImpl builder) {
        this.joinInstruction = builder.joinInstruction;
        this.physicalTableId = builder.physicalTableId;
        this.dataSetArn = builder.dataSetArn;
    }

    public final JoinInstruction joinInstruction() {
        return this.joinInstruction;
    }

    public final String physicalTableId() {
        return this.physicalTableId;
    }

    public final String dataSetArn() {
        return this.dataSetArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.joinInstruction());
        hashCode = 31 * hashCode + Objects.hashCode(this.physicalTableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSetArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogicalTableSource)) {
            return false;
        }
        LogicalTableSource other = (LogicalTableSource)obj;
        return Objects.equals(this.joinInstruction(), other.joinInstruction()) && Objects.equals(this.physicalTableId(), other.physicalTableId()) && Objects.equals(this.dataSetArn(), other.dataSetArn());
    }

    public final String toString() {
        return ToString.builder((String)"LogicalTableSource").add("JoinInstruction", (Object)this.joinInstruction()).add("PhysicalTableId", (Object)this.physicalTableId()).add("DataSetArn", (Object)this.dataSetArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JoinInstruction": {
                return Optional.ofNullable(clazz.cast(this.joinInstruction()));
            }
            case "PhysicalTableId": {
                return Optional.ofNullable(clazz.cast(this.physicalTableId()));
            }
            case "DataSetArn": {
                return Optional.ofNullable(clazz.cast(this.dataSetArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LogicalTableSource, T> g) {
        return obj -> g.apply((LogicalTableSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private JoinInstruction joinInstruction;
        private String physicalTableId;
        private String dataSetArn;

        private BuilderImpl() {
        }

        private BuilderImpl(LogicalTableSource model) {
            this.joinInstruction(model.joinInstruction);
            this.physicalTableId(model.physicalTableId);
            this.dataSetArn(model.dataSetArn);
        }

        public final JoinInstruction.Builder getJoinInstruction() {
            return this.joinInstruction != null ? this.joinInstruction.toBuilder() : null;
        }

        public final void setJoinInstruction(JoinInstruction.BuilderImpl joinInstruction) {
            this.joinInstruction = joinInstruction != null ? joinInstruction.build() : null;
        }

        @Override
        public final Builder joinInstruction(JoinInstruction joinInstruction) {
            this.joinInstruction = joinInstruction;
            return this;
        }

        public final String getPhysicalTableId() {
            return this.physicalTableId;
        }

        public final void setPhysicalTableId(String physicalTableId) {
            this.physicalTableId = physicalTableId;
        }

        @Override
        public final Builder physicalTableId(String physicalTableId) {
            this.physicalTableId = physicalTableId;
            return this;
        }

        public final String getDataSetArn() {
            return this.dataSetArn;
        }

        public final void setDataSetArn(String dataSetArn) {
            this.dataSetArn = dataSetArn;
        }

        @Override
        public final Builder dataSetArn(String dataSetArn) {
            this.dataSetArn = dataSetArn;
            return this;
        }

        public LogicalTableSource build() {
            return new LogicalTableSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LogicalTableSource> {
        public Builder joinInstruction(JoinInstruction var1);

        default public Builder joinInstruction(Consumer<JoinInstruction.Builder> joinInstruction) {
            return this.joinInstruction((JoinInstruction)((JoinInstruction.Builder)JoinInstruction.builder().applyMutation(joinInstruction)).build());
        }

        public Builder physicalTableId(String var1);

        public Builder dataSetArn(String var1);
    }
}

