/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.BaseMapStyleType;
import software.amazon.awssdk.services.quicksight.model.Visibility;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GeospatialMapStyle
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GeospatialMapStyle> {
    private static final SdkField<String> BASE_MAP_STYLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BaseMapStyle").getter(GeospatialMapStyle.getter(GeospatialMapStyle::baseMapStyleAsString)).setter(GeospatialMapStyle.setter(Builder::baseMapStyle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseMapStyle").build()}).build();
    private static final SdkField<String> BACKGROUND_COLOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackgroundColor").getter(GeospatialMapStyle.getter(GeospatialMapStyle::backgroundColor)).setter(GeospatialMapStyle.setter(Builder::backgroundColor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackgroundColor").build()}).build();
    private static final SdkField<String> BASE_MAP_VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BaseMapVisibility").getter(GeospatialMapStyle.getter(GeospatialMapStyle::baseMapVisibilityAsString)).setter(GeospatialMapStyle.setter(Builder::baseMapVisibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseMapVisibility").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASE_MAP_STYLE_FIELD, BACKGROUND_COLOR_FIELD, BASE_MAP_VISIBILITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("BaseMapStyle", BASE_MAP_STYLE_FIELD);
            this.put("BackgroundColor", BACKGROUND_COLOR_FIELD);
            this.put("BaseMapVisibility", BASE_MAP_VISIBILITY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String baseMapStyle;
    private final String backgroundColor;
    private final String baseMapVisibility;

    private GeospatialMapStyle(BuilderImpl builder) {
        this.baseMapStyle = builder.baseMapStyle;
        this.backgroundColor = builder.backgroundColor;
        this.baseMapVisibility = builder.baseMapVisibility;
    }

    public final BaseMapStyleType baseMapStyle() {
        return BaseMapStyleType.fromValue(this.baseMapStyle);
    }

    public final String baseMapStyleAsString() {
        return this.baseMapStyle;
    }

    public final String backgroundColor() {
        return this.backgroundColor;
    }

    public final Visibility baseMapVisibility() {
        return Visibility.fromValue(this.baseMapVisibility);
    }

    public final String baseMapVisibilityAsString() {
        return this.baseMapVisibility;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.baseMapStyleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.backgroundColor());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseMapVisibilityAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeospatialMapStyle)) {
            return false;
        }
        GeospatialMapStyle other = (GeospatialMapStyle)obj;
        return Objects.equals(this.baseMapStyleAsString(), other.baseMapStyleAsString()) && Objects.equals(this.backgroundColor(), other.backgroundColor()) && Objects.equals(this.baseMapVisibilityAsString(), other.baseMapVisibilityAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GeospatialMapStyle").add("BaseMapStyle", (Object)this.baseMapStyleAsString()).add("BackgroundColor", (Object)this.backgroundColor()).add("BaseMapVisibility", (Object)this.baseMapVisibilityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BaseMapStyle": {
                return Optional.ofNullable(clazz.cast(this.baseMapStyleAsString()));
            }
            case "BackgroundColor": {
                return Optional.ofNullable(clazz.cast(this.backgroundColor()));
            }
            case "BaseMapVisibility": {
                return Optional.ofNullable(clazz.cast(this.baseMapVisibilityAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GeospatialMapStyle, T> g) {
        return obj -> g.apply((GeospatialMapStyle)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String baseMapStyle;
        private String backgroundColor;
        private String baseMapVisibility;

        private BuilderImpl() {
        }

        private BuilderImpl(GeospatialMapStyle model) {
            this.baseMapStyle(model.baseMapStyle);
            this.backgroundColor(model.backgroundColor);
            this.baseMapVisibility(model.baseMapVisibility);
        }

        public final String getBaseMapStyle() {
            return this.baseMapStyle;
        }

        public final void setBaseMapStyle(String baseMapStyle) {
            this.baseMapStyle = baseMapStyle;
        }

        @Override
        public final Builder baseMapStyle(String baseMapStyle) {
            this.baseMapStyle = baseMapStyle;
            return this;
        }

        @Override
        public final Builder baseMapStyle(BaseMapStyleType baseMapStyle) {
            this.baseMapStyle(baseMapStyle == null ? null : baseMapStyle.toString());
            return this;
        }

        public final String getBackgroundColor() {
            return this.backgroundColor;
        }

        public final void setBackgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
        }

        @Override
        public final Builder backgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public final String getBaseMapVisibility() {
            return this.baseMapVisibility;
        }

        public final void setBaseMapVisibility(String baseMapVisibility) {
            this.baseMapVisibility = baseMapVisibility;
        }

        @Override
        public final Builder baseMapVisibility(String baseMapVisibility) {
            this.baseMapVisibility = baseMapVisibility;
            return this;
        }

        @Override
        public final Builder baseMapVisibility(Visibility baseMapVisibility) {
            this.baseMapVisibility(baseMapVisibility == null ? null : baseMapVisibility.toString());
            return this;
        }

        public GeospatialMapStyle build() {
            return new GeospatialMapStyle(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GeospatialMapStyle> {
        public Builder baseMapStyle(String var1);

        public Builder baseMapStyle(BaseMapStyleType var1);

        public Builder backgroundColor(String var1);

        public Builder baseMapVisibility(String var1);

        public Builder baseMapVisibility(Visibility var1);
    }
}

