/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CellValueSynonym
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CellValueSynonym> {
    private static final SdkField<String> CELL_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CellValue").getter(CellValueSynonym.getter(CellValueSynonym::cellValue)).setter(CellValueSynonym.setter(Builder::cellValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CellValue").build()}).build();
    private static final SdkField<List<String>> SYNONYMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Synonyms").getter(CellValueSynonym.getter(CellValueSynonym::synonyms)).setter(CellValueSynonym.setter(Builder::synonyms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Synonyms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CELL_VALUE_FIELD, SYNONYMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CellValue", CELL_VALUE_FIELD);
            this.put("Synonyms", SYNONYMS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String cellValue;
    private final List<String> synonyms;

    private CellValueSynonym(BuilderImpl builder) {
        this.cellValue = builder.cellValue;
        this.synonyms = builder.synonyms;
    }

    public final String cellValue() {
        return this.cellValue;
    }

    public final boolean hasSynonyms() {
        return this.synonyms != null && !(this.synonyms instanceof SdkAutoConstructList);
    }

    public final List<String> synonyms() {
        return this.synonyms;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cellValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSynonyms() ? this.synonyms() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CellValueSynonym)) {
            return false;
        }
        CellValueSynonym other = (CellValueSynonym)obj;
        return Objects.equals(this.cellValue(), other.cellValue()) && this.hasSynonyms() == other.hasSynonyms() && Objects.equals(this.synonyms(), other.synonyms());
    }

    public final String toString() {
        return ToString.builder((String)"CellValueSynonym").add("CellValue", (Object)this.cellValue()).add("Synonyms", this.hasSynonyms() ? this.synonyms() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CellValue": {
                return Optional.ofNullable(clazz.cast(this.cellValue()));
            }
            case "Synonyms": {
                return Optional.ofNullable(clazz.cast(this.synonyms()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CellValueSynonym, T> g) {
        return obj -> g.apply((CellValueSynonym)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String cellValue;
        private List<String> synonyms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CellValueSynonym model) {
            this.cellValue(model.cellValue);
            this.synonyms(model.synonyms);
        }

        public final String getCellValue() {
            return this.cellValue;
        }

        public final void setCellValue(String cellValue) {
            this.cellValue = cellValue;
        }

        @Override
        public final Builder cellValue(String cellValue) {
            this.cellValue = cellValue;
            return this;
        }

        public final Collection<String> getSynonyms() {
            if (this.synonyms instanceof SdkAutoConstructList) {
                return null;
            }
            return this.synonyms;
        }

        public final void setSynonyms(Collection<String> synonyms) {
            this.synonyms = StringListCopier.copy(synonyms);
        }

        @Override
        public final Builder synonyms(Collection<String> synonyms) {
            this.synonyms = StringListCopier.copy(synonyms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder synonyms(String ... synonyms) {
            this.synonyms(Arrays.asList(synonyms));
            return this;
        }

        public CellValueSynonym build() {
            return new CellValueSynonym(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CellValueSynonym> {
        public Builder cellValue(String var1);

        public Builder synonyms(Collection<String> var1);

        public Builder synonyms(String ... var1);
    }
}

