/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.CascadingControlSource;
import software.amazon.awssdk.services.quicksight.model.CascadingControlSourceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CascadingControlConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CascadingControlConfiguration> {
    private static final SdkField<List<CascadingControlSource>> SOURCE_CONTROLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SourceControls").getter(CascadingControlConfiguration.getter(CascadingControlConfiguration::sourceControls)).setter(CascadingControlConfiguration.setter(Builder::sourceControls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceControls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CascadingControlSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_CONTROLS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("SourceControls", SOURCE_CONTROLS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<CascadingControlSource> sourceControls;

    private CascadingControlConfiguration(BuilderImpl builder) {
        this.sourceControls = builder.sourceControls;
    }

    public final boolean hasSourceControls() {
        return this.sourceControls != null && !(this.sourceControls instanceof SdkAutoConstructList);
    }

    public final List<CascadingControlSource> sourceControls() {
        return this.sourceControls;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceControls() ? this.sourceControls() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CascadingControlConfiguration)) {
            return false;
        }
        CascadingControlConfiguration other = (CascadingControlConfiguration)obj;
        return this.hasSourceControls() == other.hasSourceControls() && Objects.equals(this.sourceControls(), other.sourceControls());
    }

    public final String toString() {
        return ToString.builder((String)"CascadingControlConfiguration").add("SourceControls", this.hasSourceControls() ? this.sourceControls() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceControls": {
                return Optional.ofNullable(clazz.cast(this.sourceControls()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CascadingControlConfiguration, T> g) {
        return obj -> g.apply((CascadingControlConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<CascadingControlSource> sourceControls = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CascadingControlConfiguration model) {
            this.sourceControls(model.sourceControls);
        }

        public final List<CascadingControlSource.Builder> getSourceControls() {
            List<CascadingControlSource.Builder> result = CascadingControlSourceListCopier.copyToBuilder(this.sourceControls);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceControls(Collection<CascadingControlSource.BuilderImpl> sourceControls) {
            this.sourceControls = CascadingControlSourceListCopier.copyFromBuilder(sourceControls);
        }

        @Override
        public final Builder sourceControls(Collection<CascadingControlSource> sourceControls) {
            this.sourceControls = CascadingControlSourceListCopier.copy(sourceControls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceControls(CascadingControlSource ... sourceControls) {
            this.sourceControls(Arrays.asList(sourceControls));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceControls(Consumer<CascadingControlSource.Builder> ... sourceControls) {
            this.sourceControls(Stream.of(sourceControls).map(c -> (CascadingControlSource)((CascadingControlSource.Builder)CascadingControlSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CascadingControlConfiguration build() {
            return new CascadingControlConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CascadingControlConfiguration> {
        public Builder sourceControls(Collection<CascadingControlSource> var1);

        public Builder sourceControls(CascadingControlSource ... var1);

        public Builder sourceControls(Consumer<CascadingControlSource.Builder> ... var1);
    }
}

