/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.AggregationFunction;
import software.amazon.awssdk.services.quicksight.model.ColumnIdentifier;
import software.amazon.awssdk.services.quicksight.model.NumericalAggregationFunction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReferenceLineDynamicDataConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReferenceLineDynamicDataConfiguration> {
    private static final SdkField<ColumnIdentifier> COLUMN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Column").getter(ReferenceLineDynamicDataConfiguration.getter(ReferenceLineDynamicDataConfiguration::column)).setter(ReferenceLineDynamicDataConfiguration.setter(Builder::column)).constructor(ColumnIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Column").build()}).build();
    private static final SdkField<AggregationFunction> MEASURE_AGGREGATION_FUNCTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MeasureAggregationFunction").getter(ReferenceLineDynamicDataConfiguration.getter(ReferenceLineDynamicDataConfiguration::measureAggregationFunction)).setter(ReferenceLineDynamicDataConfiguration.setter(Builder::measureAggregationFunction)).constructor(AggregationFunction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeasureAggregationFunction").build()}).build();
    private static final SdkField<NumericalAggregationFunction> CALCULATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Calculation").getter(ReferenceLineDynamicDataConfiguration.getter(ReferenceLineDynamicDataConfiguration::calculation)).setter(ReferenceLineDynamicDataConfiguration.setter(Builder::calculation)).constructor(NumericalAggregationFunction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Calculation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_FIELD, MEASURE_AGGREGATION_FUNCTION_FIELD, CALCULATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Column", COLUMN_FIELD);
            this.put("MeasureAggregationFunction", MEASURE_AGGREGATION_FUNCTION_FIELD);
            this.put("Calculation", CALCULATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final ColumnIdentifier column;
    private final AggregationFunction measureAggregationFunction;
    private final NumericalAggregationFunction calculation;

    private ReferenceLineDynamicDataConfiguration(BuilderImpl builder) {
        this.column = builder.column;
        this.measureAggregationFunction = builder.measureAggregationFunction;
        this.calculation = builder.calculation;
    }

    public final ColumnIdentifier column() {
        return this.column;
    }

    public final AggregationFunction measureAggregationFunction() {
        return this.measureAggregationFunction;
    }

    public final NumericalAggregationFunction calculation() {
        return this.calculation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.column());
        hashCode = 31 * hashCode + Objects.hashCode(this.measureAggregationFunction());
        hashCode = 31 * hashCode + Objects.hashCode(this.calculation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReferenceLineDynamicDataConfiguration)) {
            return false;
        }
        ReferenceLineDynamicDataConfiguration other = (ReferenceLineDynamicDataConfiguration)obj;
        return Objects.equals(this.column(), other.column()) && Objects.equals(this.measureAggregationFunction(), other.measureAggregationFunction()) && Objects.equals(this.calculation(), other.calculation());
    }

    public final String toString() {
        return ToString.builder((String)"ReferenceLineDynamicDataConfiguration").add("Column", (Object)this.column()).add("MeasureAggregationFunction", (Object)this.measureAggregationFunction()).add("Calculation", (Object)this.calculation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Column": {
                return Optional.ofNullable(clazz.cast(this.column()));
            }
            case "MeasureAggregationFunction": {
                return Optional.ofNullable(clazz.cast(this.measureAggregationFunction()));
            }
            case "Calculation": {
                return Optional.ofNullable(clazz.cast(this.calculation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ReferenceLineDynamicDataConfiguration, T> g) {
        return obj -> g.apply((ReferenceLineDynamicDataConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ColumnIdentifier column;
        private AggregationFunction measureAggregationFunction;
        private NumericalAggregationFunction calculation;

        private BuilderImpl() {
        }

        private BuilderImpl(ReferenceLineDynamicDataConfiguration model) {
            this.column(model.column);
            this.measureAggregationFunction(model.measureAggregationFunction);
            this.calculation(model.calculation);
        }

        public final ColumnIdentifier.Builder getColumn() {
            return this.column != null ? this.column.toBuilder() : null;
        }

        public final void setColumn(ColumnIdentifier.BuilderImpl column) {
            this.column = column != null ? column.build() : null;
        }

        @Override
        public final Builder column(ColumnIdentifier column) {
            this.column = column;
            return this;
        }

        public final AggregationFunction.Builder getMeasureAggregationFunction() {
            return this.measureAggregationFunction != null ? this.measureAggregationFunction.toBuilder() : null;
        }

        public final void setMeasureAggregationFunction(AggregationFunction.BuilderImpl measureAggregationFunction) {
            this.measureAggregationFunction = measureAggregationFunction != null ? measureAggregationFunction.build() : null;
        }

        @Override
        public final Builder measureAggregationFunction(AggregationFunction measureAggregationFunction) {
            this.measureAggregationFunction = measureAggregationFunction;
            return this;
        }

        public final NumericalAggregationFunction.Builder getCalculation() {
            return this.calculation != null ? this.calculation.toBuilder() : null;
        }

        public final void setCalculation(NumericalAggregationFunction.BuilderImpl calculation) {
            this.calculation = calculation != null ? calculation.build() : null;
        }

        @Override
        public final Builder calculation(NumericalAggregationFunction calculation) {
            this.calculation = calculation;
            return this;
        }

        public ReferenceLineDynamicDataConfiguration build() {
            return new ReferenceLineDynamicDataConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReferenceLineDynamicDataConfiguration> {
        public Builder column(ColumnIdentifier var1);

        default public Builder column(Consumer<ColumnIdentifier.Builder> column) {
            return this.column((ColumnIdentifier)((ColumnIdentifier.Builder)ColumnIdentifier.builder().applyMutation(column)).build());
        }

        public Builder measureAggregationFunction(AggregationFunction var1);

        default public Builder measureAggregationFunction(Consumer<AggregationFunction.Builder> measureAggregationFunction) {
            return this.measureAggregationFunction((AggregationFunction)((AggregationFunction.Builder)AggregationFunction.builder().applyMutation(measureAggregationFunction)).build());
        }

        public Builder calculation(NumericalAggregationFunction var1);

        default public Builder calculation(Consumer<NumericalAggregationFunction.Builder> calculation) {
            return this.calculation((NumericalAggregationFunction)((NumericalAggregationFunction.Builder)NumericalAggregationFunction.builder().applyMutation(calculation)).build());
        }
    }
}

