/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.FreeFormLayoutCanvasSizeOptions;
import software.amazon.awssdk.services.quicksight.model.FreeFormLayoutElement;
import software.amazon.awssdk.services.quicksight.model.FreeFromLayoutElementListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FreeFormLayoutConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FreeFormLayoutConfiguration> {
    private static final SdkField<List<FreeFormLayoutElement>> ELEMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Elements").getter(FreeFormLayoutConfiguration.getter(FreeFormLayoutConfiguration::elements)).setter(FreeFormLayoutConfiguration.setter(Builder::elements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Elements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FreeFormLayoutElement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<FreeFormLayoutCanvasSizeOptions> CANVAS_SIZE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CanvasSizeOptions").getter(FreeFormLayoutConfiguration.getter(FreeFormLayoutConfiguration::canvasSizeOptions)).setter(FreeFormLayoutConfiguration.setter(Builder::canvasSizeOptions)).constructor(FreeFormLayoutCanvasSizeOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CanvasSizeOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ELEMENTS_FIELD, CANVAS_SIZE_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Elements", ELEMENTS_FIELD);
            this.put("CanvasSizeOptions", CANVAS_SIZE_OPTIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<FreeFormLayoutElement> elements;
    private final FreeFormLayoutCanvasSizeOptions canvasSizeOptions;

    private FreeFormLayoutConfiguration(BuilderImpl builder) {
        this.elements = builder.elements;
        this.canvasSizeOptions = builder.canvasSizeOptions;
    }

    public final boolean hasElements() {
        return this.elements != null && !(this.elements instanceof SdkAutoConstructList);
    }

    public final List<FreeFormLayoutElement> elements() {
        return this.elements;
    }

    public final FreeFormLayoutCanvasSizeOptions canvasSizeOptions() {
        return this.canvasSizeOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasElements() ? this.elements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.canvasSizeOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FreeFormLayoutConfiguration)) {
            return false;
        }
        FreeFormLayoutConfiguration other = (FreeFormLayoutConfiguration)obj;
        return this.hasElements() == other.hasElements() && Objects.equals(this.elements(), other.elements()) && Objects.equals(this.canvasSizeOptions(), other.canvasSizeOptions());
    }

    public final String toString() {
        return ToString.builder((String)"FreeFormLayoutConfiguration").add("Elements", this.hasElements() ? this.elements() : null).add("CanvasSizeOptions", (Object)this.canvasSizeOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Elements": {
                return Optional.ofNullable(clazz.cast(this.elements()));
            }
            case "CanvasSizeOptions": {
                return Optional.ofNullable(clazz.cast(this.canvasSizeOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FreeFormLayoutConfiguration, T> g) {
        return obj -> g.apply((FreeFormLayoutConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<FreeFormLayoutElement> elements = DefaultSdkAutoConstructList.getInstance();
        private FreeFormLayoutCanvasSizeOptions canvasSizeOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(FreeFormLayoutConfiguration model) {
            this.elements(model.elements);
            this.canvasSizeOptions(model.canvasSizeOptions);
        }

        public final List<FreeFormLayoutElement.Builder> getElements() {
            List<FreeFormLayoutElement.Builder> result = FreeFromLayoutElementListCopier.copyToBuilder(this.elements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setElements(Collection<FreeFormLayoutElement.BuilderImpl> elements) {
            this.elements = FreeFromLayoutElementListCopier.copyFromBuilder(elements);
        }

        @Override
        public final Builder elements(Collection<FreeFormLayoutElement> elements) {
            this.elements = FreeFromLayoutElementListCopier.copy(elements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elements(FreeFormLayoutElement ... elements) {
            this.elements(Arrays.asList(elements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elements(Consumer<FreeFormLayoutElement.Builder> ... elements) {
            this.elements(Stream.of(elements).map(c -> (FreeFormLayoutElement)((FreeFormLayoutElement.Builder)FreeFormLayoutElement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final FreeFormLayoutCanvasSizeOptions.Builder getCanvasSizeOptions() {
            return this.canvasSizeOptions != null ? this.canvasSizeOptions.toBuilder() : null;
        }

        public final void setCanvasSizeOptions(FreeFormLayoutCanvasSizeOptions.BuilderImpl canvasSizeOptions) {
            this.canvasSizeOptions = canvasSizeOptions != null ? canvasSizeOptions.build() : null;
        }

        @Override
        public final Builder canvasSizeOptions(FreeFormLayoutCanvasSizeOptions canvasSizeOptions) {
            this.canvasSizeOptions = canvasSizeOptions;
            return this;
        }

        public FreeFormLayoutConfiguration build() {
            return new FreeFormLayoutConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FreeFormLayoutConfiguration> {
        public Builder elements(Collection<FreeFormLayoutElement> var1);

        public Builder elements(FreeFormLayoutElement ... var1);

        public Builder elements(Consumer<FreeFormLayoutElement.Builder> ... var1);

        public Builder canvasSizeOptions(FreeFormLayoutCanvasSizeOptions var1);

        default public Builder canvasSizeOptions(Consumer<FreeFormLayoutCanvasSizeOptions.Builder> canvasSizeOptions) {
            return this.canvasSizeOptions((FreeFormLayoutCanvasSizeOptions)((FreeFormLayoutCanvasSizeOptions.Builder)FreeFormLayoutCanvasSizeOptions.builder().applyMutation(canvasSizeOptions)).build());
        }
    }
}

