/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.CategoryFilterMatchOperator;
import software.amazon.awssdk.services.quicksight.model.CategoryFilterSelectAllOptions;
import software.amazon.awssdk.services.quicksight.model.FilterNullOption;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomFilterConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomFilterConfiguration> {
    private static final SdkField<String> MATCH_OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MatchOperator").getter(CustomFilterConfiguration.getter(CustomFilterConfiguration::matchOperatorAsString)).setter(CustomFilterConfiguration.setter(Builder::matchOperator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchOperator").build()}).build();
    private static final SdkField<String> CATEGORY_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CategoryValue").getter(CustomFilterConfiguration.getter(CustomFilterConfiguration::categoryValue)).setter(CustomFilterConfiguration.setter(Builder::categoryValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryValue").build()}).build();
    private static final SdkField<String> SELECT_ALL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SelectAllOptions").getter(CustomFilterConfiguration.getter(CustomFilterConfiguration::selectAllOptionsAsString)).setter(CustomFilterConfiguration.setter(Builder::selectAllOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectAllOptions").build()}).build();
    private static final SdkField<String> PARAMETER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParameterName").getter(CustomFilterConfiguration.getter(CustomFilterConfiguration::parameterName)).setter(CustomFilterConfiguration.setter(Builder::parameterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterName").build()}).build();
    private static final SdkField<String> NULL_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NullOption").getter(CustomFilterConfiguration.getter(CustomFilterConfiguration::nullOptionAsString)).setter(CustomFilterConfiguration.setter(Builder::nullOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NullOption").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MATCH_OPERATOR_FIELD, CATEGORY_VALUE_FIELD, SELECT_ALL_OPTIONS_FIELD, PARAMETER_NAME_FIELD, NULL_OPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("MatchOperator", MATCH_OPERATOR_FIELD);
            this.put("CategoryValue", CATEGORY_VALUE_FIELD);
            this.put("SelectAllOptions", SELECT_ALL_OPTIONS_FIELD);
            this.put("ParameterName", PARAMETER_NAME_FIELD);
            this.put("NullOption", NULL_OPTION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String matchOperator;
    private final String categoryValue;
    private final String selectAllOptions;
    private final String parameterName;
    private final String nullOption;

    private CustomFilterConfiguration(BuilderImpl builder) {
        this.matchOperator = builder.matchOperator;
        this.categoryValue = builder.categoryValue;
        this.selectAllOptions = builder.selectAllOptions;
        this.parameterName = builder.parameterName;
        this.nullOption = builder.nullOption;
    }

    public final CategoryFilterMatchOperator matchOperator() {
        return CategoryFilterMatchOperator.fromValue(this.matchOperator);
    }

    public final String matchOperatorAsString() {
        return this.matchOperator;
    }

    public final String categoryValue() {
        return this.categoryValue;
    }

    public final CategoryFilterSelectAllOptions selectAllOptions() {
        return CategoryFilterSelectAllOptions.fromValue(this.selectAllOptions);
    }

    public final String selectAllOptionsAsString() {
        return this.selectAllOptions;
    }

    public final String parameterName() {
        return this.parameterName;
    }

    public final FilterNullOption nullOption() {
        return FilterNullOption.fromValue(this.nullOption);
    }

    public final String nullOptionAsString() {
        return this.nullOption;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.matchOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectAllOptionsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nullOptionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomFilterConfiguration)) {
            return false;
        }
        CustomFilterConfiguration other = (CustomFilterConfiguration)obj;
        return Objects.equals(this.matchOperatorAsString(), other.matchOperatorAsString()) && Objects.equals(this.categoryValue(), other.categoryValue()) && Objects.equals(this.selectAllOptionsAsString(), other.selectAllOptionsAsString()) && Objects.equals(this.parameterName(), other.parameterName()) && Objects.equals(this.nullOptionAsString(), other.nullOptionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CustomFilterConfiguration").add("MatchOperator", (Object)this.matchOperatorAsString()).add("CategoryValue", (Object)this.categoryValue()).add("SelectAllOptions", (Object)this.selectAllOptionsAsString()).add("ParameterName", (Object)this.parameterName()).add("NullOption", (Object)this.nullOptionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MatchOperator": {
                return Optional.ofNullable(clazz.cast(this.matchOperatorAsString()));
            }
            case "CategoryValue": {
                return Optional.ofNullable(clazz.cast(this.categoryValue()));
            }
            case "SelectAllOptions": {
                return Optional.ofNullable(clazz.cast(this.selectAllOptionsAsString()));
            }
            case "ParameterName": {
                return Optional.ofNullable(clazz.cast(this.parameterName()));
            }
            case "NullOption": {
                return Optional.ofNullable(clazz.cast(this.nullOptionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CustomFilterConfiguration, T> g) {
        return obj -> g.apply((CustomFilterConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String matchOperator;
        private String categoryValue;
        private String selectAllOptions;
        private String parameterName;
        private String nullOption;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomFilterConfiguration model) {
            this.matchOperator(model.matchOperator);
            this.categoryValue(model.categoryValue);
            this.selectAllOptions(model.selectAllOptions);
            this.parameterName(model.parameterName);
            this.nullOption(model.nullOption);
        }

        public final String getMatchOperator() {
            return this.matchOperator;
        }

        public final void setMatchOperator(String matchOperator) {
            this.matchOperator = matchOperator;
        }

        @Override
        public final Builder matchOperator(String matchOperator) {
            this.matchOperator = matchOperator;
            return this;
        }

        @Override
        public final Builder matchOperator(CategoryFilterMatchOperator matchOperator) {
            this.matchOperator(matchOperator == null ? null : matchOperator.toString());
            return this;
        }

        public final String getCategoryValue() {
            return this.categoryValue;
        }

        public final void setCategoryValue(String categoryValue) {
            this.categoryValue = categoryValue;
        }

        @Override
        public final Builder categoryValue(String categoryValue) {
            this.categoryValue = categoryValue;
            return this;
        }

        public final String getSelectAllOptions() {
            return this.selectAllOptions;
        }

        public final void setSelectAllOptions(String selectAllOptions) {
            this.selectAllOptions = selectAllOptions;
        }

        @Override
        public final Builder selectAllOptions(String selectAllOptions) {
            this.selectAllOptions = selectAllOptions;
            return this;
        }

        @Override
        public final Builder selectAllOptions(CategoryFilterSelectAllOptions selectAllOptions) {
            this.selectAllOptions(selectAllOptions == null ? null : selectAllOptions.toString());
            return this;
        }

        public final String getParameterName() {
            return this.parameterName;
        }

        public final void setParameterName(String parameterName) {
            this.parameterName = parameterName;
        }

        @Override
        public final Builder parameterName(String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        public final String getNullOption() {
            return this.nullOption;
        }

        public final void setNullOption(String nullOption) {
            this.nullOption = nullOption;
        }

        @Override
        public final Builder nullOption(String nullOption) {
            this.nullOption = nullOption;
            return this;
        }

        @Override
        public final Builder nullOption(FilterNullOption nullOption) {
            this.nullOption(nullOption == null ? null : nullOption.toString());
            return this;
        }

        public CustomFilterConfiguration build() {
            return new CustomFilterConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomFilterConfiguration> {
        public Builder matchOperator(String var1);

        public Builder matchOperator(CategoryFilterMatchOperator var1);

        public Builder categoryValue(String var1);

        public Builder selectAllOptions(String var1);

        public Builder selectAllOptions(CategoryFilterSelectAllOptions var1);

        public Builder parameterName(String var1);

        public Builder nullOption(String var1);

        public Builder nullOption(FilterNullOption var1);
    }
}

