/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.AssetBundleRestrictiveResourceIdListCopier;
import software.amazon.awssdk.services.quicksight.model.Tag;
import software.amazon.awssdk.services.quicksight.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssetBundleImportJobAnalysisOverrideTags
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssetBundleImportJobAnalysisOverrideTags> {
    private static final SdkField<List<String>> ANALYSIS_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AnalysisIds").getter(AssetBundleImportJobAnalysisOverrideTags.getter(AssetBundleImportJobAnalysisOverrideTags::analysisIds)).setter(AssetBundleImportJobAnalysisOverrideTags.setter(Builder::analysisIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(AssetBundleImportJobAnalysisOverrideTags.getter(AssetBundleImportJobAnalysisOverrideTags::tags)).setter(AssetBundleImportJobAnalysisOverrideTags.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYSIS_IDS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AnalysisIds", ANALYSIS_IDS_FIELD);
            this.put("Tags", TAGS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> analysisIds;
    private final List<Tag> tags;

    private AssetBundleImportJobAnalysisOverrideTags(BuilderImpl builder) {
        this.analysisIds = builder.analysisIds;
        this.tags = builder.tags;
    }

    public final boolean hasAnalysisIds() {
        return this.analysisIds != null && !(this.analysisIds instanceof SdkAutoConstructList);
    }

    public final List<String> analysisIds() {
        return this.analysisIds;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnalysisIds() ? this.analysisIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetBundleImportJobAnalysisOverrideTags)) {
            return false;
        }
        AssetBundleImportJobAnalysisOverrideTags other = (AssetBundleImportJobAnalysisOverrideTags)obj;
        return this.hasAnalysisIds() == other.hasAnalysisIds() && Objects.equals(this.analysisIds(), other.analysisIds()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"AssetBundleImportJobAnalysisOverrideTags").add("AnalysisIds", this.hasAnalysisIds() ? this.analysisIds() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AnalysisIds": {
                return Optional.ofNullable(clazz.cast(this.analysisIds()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AssetBundleImportJobAnalysisOverrideTags, T> g) {
        return obj -> g.apply((AssetBundleImportJobAnalysisOverrideTags)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> analysisIds = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssetBundleImportJobAnalysisOverrideTags model) {
            this.analysisIds(model.analysisIds);
            this.tags(model.tags);
        }

        public final Collection<String> getAnalysisIds() {
            if (this.analysisIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.analysisIds;
        }

        public final void setAnalysisIds(Collection<String> analysisIds) {
            this.analysisIds = AssetBundleRestrictiveResourceIdListCopier.copy(analysisIds);
        }

        @Override
        public final Builder analysisIds(Collection<String> analysisIds) {
            this.analysisIds = AssetBundleRestrictiveResourceIdListCopier.copy(analysisIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisIds(String ... analysisIds) {
            this.analysisIds(Arrays.asList(analysisIds));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AssetBundleImportJobAnalysisOverrideTags build() {
            return new AssetBundleImportJobAnalysisOverrideTags(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssetBundleImportJobAnalysisOverrideTags> {
        public Builder analysisIds(Collection<String> var1);

        public Builder analysisIds(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

