/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.Folder;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFolderResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, DescribeFolderResponse> {
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(DescribeFolderResponse.getter(DescribeFolderResponse::status)).setter(DescribeFolderResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final SdkField<Folder> FOLDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Folder").getter(DescribeFolderResponse.getter(DescribeFolderResponse::folder)).setter(DescribeFolderResponse.setter(Builder::folder)).constructor(Folder::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Folder").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(DescribeFolderResponse.getter(DescribeFolderResponse::requestId)).setter(DescribeFolderResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, FOLDER_FIELD, REQUEST_ID_FIELD));
    private final Integer status;
    private final Folder folder;
    private final String requestId;

    private DescribeFolderResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.folder = builder.folder;
        this.requestId = builder.requestId;
    }

    public final Integer status() {
        return this.status;
    }

    public final Folder folder() {
        return this.folder;
    }

    public final String requestId() {
        return this.requestId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.folder());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFolderResponse)) {
            return false;
        }
        DescribeFolderResponse other = (DescribeFolderResponse)((Object)obj);
        return Objects.equals(this.status(), other.status()) && Objects.equals(this.folder(), other.folder()) && Objects.equals(this.requestId(), other.requestId());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeFolderResponse").add("Status", (Object)this.status()).add("Folder", (Object)this.folder()).add("RequestId", (Object)this.requestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "Folder": {
                return Optional.ofNullable(clazz.cast(this.folder()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFolderResponse, T> g) {
        return obj -> g.apply((DescribeFolderResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private Integer status;
        private Folder folder;
        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFolderResponse model) {
            super(model);
            this.status(model.status);
            this.folder(model.folder);
            this.requestId(model.requestId);
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final Folder.Builder getFolder() {
            return this.folder != null ? this.folder.toBuilder() : null;
        }

        public final void setFolder(Folder.BuilderImpl folder) {
            this.folder = folder != null ? folder.build() : null;
        }

        @Override
        public final Builder folder(Folder folder) {
            this.folder = folder;
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public DescribeFolderResponse build() {
            return new DescribeFolderResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeFolderResponse> {
        public Builder status(Integer var1);

        public Builder folder(Folder var1);

        default public Builder folder(Consumer<Folder.Builder> folder) {
            return this.folder((Folder)((Folder.Builder)Folder.builder().applyMutation(folder)).build());
        }

        public Builder requestId(String var1);
    }
}

