/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.DataPathValue;
import software.amazon.awssdk.services.quicksight.model.TimeGranularity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataPathColor
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataPathColor> {
    private static final SdkField<DataPathValue> ELEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Element").getter(DataPathColor.getter(DataPathColor::element)).setter(DataPathColor.setter(Builder::element)).constructor(DataPathValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Element").build()}).build();
    private static final SdkField<String> COLOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Color").getter(DataPathColor.getter(DataPathColor::color)).setter(DataPathColor.setter(Builder::color)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Color").build()}).build();
    private static final SdkField<String> TIME_GRANULARITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimeGranularity").getter(DataPathColor.getter(DataPathColor::timeGranularityAsString)).setter(DataPathColor.setter(Builder::timeGranularity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeGranularity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ELEMENT_FIELD, COLOR_FIELD, TIME_GRANULARITY_FIELD));
    private static final long serialVersionUID = 1L;
    private final DataPathValue element;
    private final String color;
    private final String timeGranularity;

    private DataPathColor(BuilderImpl builder) {
        this.element = builder.element;
        this.color = builder.color;
        this.timeGranularity = builder.timeGranularity;
    }

    public final DataPathValue element() {
        return this.element;
    }

    public final String color() {
        return this.color;
    }

    public final TimeGranularity timeGranularity() {
        return TimeGranularity.fromValue(this.timeGranularity);
    }

    public final String timeGranularityAsString() {
        return this.timeGranularity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.element());
        hashCode = 31 * hashCode + Objects.hashCode(this.color());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeGranularityAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataPathColor)) {
            return false;
        }
        DataPathColor other = (DataPathColor)obj;
        return Objects.equals(this.element(), other.element()) && Objects.equals(this.color(), other.color()) && Objects.equals(this.timeGranularityAsString(), other.timeGranularityAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DataPathColor").add("Element", (Object)this.element()).add("Color", (Object)this.color()).add("TimeGranularity", (Object)this.timeGranularityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Element": {
                return Optional.ofNullable(clazz.cast(this.element()));
            }
            case "Color": {
                return Optional.ofNullable(clazz.cast(this.color()));
            }
            case "TimeGranularity": {
                return Optional.ofNullable(clazz.cast(this.timeGranularityAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataPathColor, T> g) {
        return obj -> g.apply((DataPathColor)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DataPathValue element;
        private String color;
        private String timeGranularity;

        private BuilderImpl() {
        }

        private BuilderImpl(DataPathColor model) {
            this.element(model.element);
            this.color(model.color);
            this.timeGranularity(model.timeGranularity);
        }

        public final DataPathValue.Builder getElement() {
            return this.element != null ? this.element.toBuilder() : null;
        }

        public final void setElement(DataPathValue.BuilderImpl element) {
            this.element = element != null ? element.build() : null;
        }

        @Override
        public final Builder element(DataPathValue element) {
            this.element = element;
            return this;
        }

        public final String getColor() {
            return this.color;
        }

        public final void setColor(String color) {
            this.color = color;
        }

        @Override
        public final Builder color(String color) {
            this.color = color;
            return this;
        }

        public final String getTimeGranularity() {
            return this.timeGranularity;
        }

        public final void setTimeGranularity(String timeGranularity) {
            this.timeGranularity = timeGranularity;
        }

        @Override
        public final Builder timeGranularity(String timeGranularity) {
            this.timeGranularity = timeGranularity;
            return this;
        }

        @Override
        public final Builder timeGranularity(TimeGranularity timeGranularity) {
            this.timeGranularity(timeGranularity == null ? null : timeGranularity.toString());
            return this;
        }

        public DataPathColor build() {
            return new DataPathColor(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataPathColor> {
        public Builder element(DataPathValue var1);

        default public Builder element(Consumer<DataPathValue.Builder> element) {
            return this.element((DataPathValue)((DataPathValue.Builder)DataPathValue.builder().applyMutation(element)).build());
        }

        public Builder color(String var1);

        public Builder timeGranularity(String var1);

        public Builder timeGranularity(TimeGranularity var1);
    }
}

