/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.services.quicksight.model.Role;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRoleMembershipRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, CreateRoleMembershipRequest> {
    private static final SdkField<String> MEMBER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MemberName").getter(CreateRoleMembershipRequest.getter(CreateRoleMembershipRequest::memberName)).setter(CreateRoleMembershipRequest.setter(Builder::memberName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("MemberName").build()}).build();
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(CreateRoleMembershipRequest.getter(CreateRoleMembershipRequest::awsAccountId)).setter(CreateRoleMembershipRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Namespace").getter(CreateRoleMembershipRequest.getter(CreateRoleMembershipRequest::namespace)).setter(CreateRoleMembershipRequest.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Namespace").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Role").getter(CreateRoleMembershipRequest.getter(CreateRoleMembershipRequest::roleAsString)).setter(CreateRoleMembershipRequest.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Role").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBER_NAME_FIELD, AWS_ACCOUNT_ID_FIELD, NAMESPACE_FIELD, ROLE_FIELD));
    private final String memberName;
    private final String awsAccountId;
    private final String namespace;
    private final String role;

    private CreateRoleMembershipRequest(BuilderImpl builder) {
        super(builder);
        this.memberName = builder.memberName;
        this.awsAccountId = builder.awsAccountId;
        this.namespace = builder.namespace;
        this.role = builder.role;
    }

    public final String memberName() {
        return this.memberName;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String namespace() {
        return this.namespace;
    }

    public final Role role() {
        return Role.fromValue(this.role);
    }

    public final String roleAsString() {
        return this.role;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.memberName());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRoleMembershipRequest)) {
            return false;
        }
        CreateRoleMembershipRequest other = (CreateRoleMembershipRequest)((Object)obj);
        return Objects.equals(this.memberName(), other.memberName()) && Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.roleAsString(), other.roleAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateRoleMembershipRequest").add("MemberName", (Object)this.memberName()).add("AwsAccountId", (Object)this.awsAccountId()).add("Namespace", (Object)this.namespace()).add("Role", (Object)this.roleAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MemberName": {
                return Optional.ofNullable(clazz.cast(this.memberName()));
            }
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "Namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.roleAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRoleMembershipRequest, T> g) {
        return obj -> g.apply((CreateRoleMembershipRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String memberName;
        private String awsAccountId;
        private String namespace;
        private String role;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRoleMembershipRequest model) {
            super(model);
            this.memberName(model.memberName);
            this.awsAccountId(model.awsAccountId);
            this.namespace(model.namespace);
            this.role(model.role);
        }

        public final String getMemberName() {
            return this.memberName;
        }

        public final void setMemberName(String memberName) {
            this.memberName = memberName;
        }

        @Override
        public final Builder memberName(String memberName) {
            this.memberName = memberName;
            return this;
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getRole() {
            return this.role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        public final Builder role(Role role) {
            this.role(role == null ? null : role.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRoleMembershipRequest build() {
            return new CreateRoleMembershipRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRoleMembershipRequest> {
        public Builder memberName(String var1);

        public Builder awsAccountId(String var1);

        public Builder namespace(String var1);

        public Builder role(String var1);

        public Builder role(Role var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

