/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TopicIRFilterType {
    CATEGORY_FILTER("CATEGORY_FILTER"),
    NUMERIC_EQUALITY_FILTER("NUMERIC_EQUALITY_FILTER"),
    NUMERIC_RANGE_FILTER("NUMERIC_RANGE_FILTER"),
    DATE_RANGE_FILTER("DATE_RANGE_FILTER"),
    RELATIVE_DATE_FILTER("RELATIVE_DATE_FILTER"),
    TOP_BOTTOM_FILTER("TOP_BOTTOM_FILTER"),
    EQUALS("EQUALS"),
    RANK_LIMIT_FILTER("RANK_LIMIT_FILTER"),
    ACCEPT_ALL_FILTER("ACCEPT_ALL_FILTER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TopicIRFilterType> VALUE_MAP;
    private final String value;

    private TopicIRFilterType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TopicIRFilterType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TopicIRFilterType> knownValues() {
        EnumSet<TopicIRFilterType> knownValues = EnumSet.allOf(TopicIRFilterType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TopicIRFilterType.class, TopicIRFilterType::toString);
    }
}

