/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartDashboardSnapshotJobScheduleRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, StartDashboardSnapshotJobScheduleRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(StartDashboardSnapshotJobScheduleRequest.getter(StartDashboardSnapshotJobScheduleRequest::awsAccountId)).setter(StartDashboardSnapshotJobScheduleRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> DASHBOARD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DashboardId").getter(StartDashboardSnapshotJobScheduleRequest.getter(StartDashboardSnapshotJobScheduleRequest::dashboardId)).setter(StartDashboardSnapshotJobScheduleRequest.setter(Builder::dashboardId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DashboardId").build()}).build();
    private static final SdkField<String> SCHEDULE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScheduleId").getter(StartDashboardSnapshotJobScheduleRequest.getter(StartDashboardSnapshotJobScheduleRequest::scheduleId)).setter(StartDashboardSnapshotJobScheduleRequest.setter(Builder::scheduleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ScheduleId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, DASHBOARD_ID_FIELD, SCHEDULE_ID_FIELD));
    private final String awsAccountId;
    private final String dashboardId;
    private final String scheduleId;

    private StartDashboardSnapshotJobScheduleRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.dashboardId = builder.dashboardId;
        this.scheduleId = builder.scheduleId;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String dashboardId() {
        return this.dashboardId;
    }

    public final String scheduleId() {
        return this.scheduleId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dashboardId());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDashboardSnapshotJobScheduleRequest)) {
            return false;
        }
        StartDashboardSnapshotJobScheduleRequest other = (StartDashboardSnapshotJobScheduleRequest)((Object)obj);
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.dashboardId(), other.dashboardId()) && Objects.equals(this.scheduleId(), other.scheduleId());
    }

    public final String toString() {
        return ToString.builder((String)"StartDashboardSnapshotJobScheduleRequest").add("AwsAccountId", (Object)this.awsAccountId()).add("DashboardId", (Object)this.dashboardId()).add("ScheduleId", (Object)this.scheduleId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "DashboardId": {
                return Optional.ofNullable(clazz.cast(this.dashboardId()));
            }
            case "ScheduleId": {
                return Optional.ofNullable(clazz.cast(this.scheduleId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartDashboardSnapshotJobScheduleRequest, T> g) {
        return obj -> g.apply((StartDashboardSnapshotJobScheduleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String dashboardId;
        private String scheduleId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartDashboardSnapshotJobScheduleRequest model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.dashboardId(model.dashboardId);
            this.scheduleId(model.scheduleId);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getDashboardId() {
            return this.dashboardId;
        }

        public final void setDashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
        }

        @Override
        public final Builder dashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
            return this;
        }

        public final String getScheduleId() {
            return this.scheduleId;
        }

        public final void setScheduleId(String scheduleId) {
            this.scheduleId = scheduleId;
        }

        @Override
        public final Builder scheduleId(String scheduleId) {
            this.scheduleId = scheduleId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartDashboardSnapshotJobScheduleRequest build() {
            return new StartDashboardSnapshotJobScheduleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartDashboardSnapshotJobScheduleRequest> {
        public Builder awsAccountId(String var1);

        public Builder dashboardId(String var1);

        public Builder scheduleId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

