/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.TableFieldIconSetType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TableFieldCustomIconContent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TableFieldCustomIconContent> {
    private static final SdkField<String> ICON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Icon").getter(TableFieldCustomIconContent.getter(TableFieldCustomIconContent::iconAsString)).setter(TableFieldCustomIconContent.setter(Builder::icon)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Icon").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ICON_FIELD));
    private static final long serialVersionUID = 1L;
    private final String icon;

    private TableFieldCustomIconContent(BuilderImpl builder) {
        this.icon = builder.icon;
    }

    public final TableFieldIconSetType icon() {
        return TableFieldIconSetType.fromValue(this.icon);
    }

    public final String iconAsString() {
        return this.icon;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.iconAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableFieldCustomIconContent)) {
            return false;
        }
        TableFieldCustomIconContent other = (TableFieldCustomIconContent)obj;
        return Objects.equals(this.iconAsString(), other.iconAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TableFieldCustomIconContent").add("Icon", (Object)this.iconAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Icon": {
                return Optional.ofNullable(clazz.cast(this.iconAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TableFieldCustomIconContent, T> g) {
        return obj -> g.apply((TableFieldCustomIconContent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String icon;

        private BuilderImpl() {
        }

        private BuilderImpl(TableFieldCustomIconContent model) {
            this.icon(model.icon);
        }

        public final String getIcon() {
            return this.icon;
        }

        public final void setIcon(String icon) {
            this.icon = icon;
        }

        @Override
        public final Builder icon(String icon) {
            this.icon = icon;
            return this;
        }

        @Override
        public final Builder icon(TableFieldIconSetType icon) {
            this.icon(icon == null ? null : icon.toString());
            return this;
        }

        public TableFieldCustomIconContent build() {
            return new TableFieldCustomIconContent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TableFieldCustomIconContent> {
        public Builder icon(String var1);

        public Builder icon(TableFieldIconSetType var1);
    }
}

