/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.FoldersForResourceArnListCopier;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFoldersForResourceResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, ListFoldersForResourceResponse> {
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(ListFoldersForResourceResponse.getter(ListFoldersForResourceResponse::status)).setter(ListFoldersForResourceResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final SdkField<List<String>> FOLDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Folders").getter(ListFoldersForResourceResponse.getter(ListFoldersForResourceResponse::folders)).setter(ListFoldersForResourceResponse.setter(Builder::folders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Folders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListFoldersForResourceResponse.getter(ListFoldersForResourceResponse::nextToken)).setter(ListFoldersForResourceResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(ListFoldersForResourceResponse.getter(ListFoldersForResourceResponse::requestId)).setter(ListFoldersForResourceResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, FOLDERS_FIELD, NEXT_TOKEN_FIELD, REQUEST_ID_FIELD));
    private final Integer status;
    private final List<String> folders;
    private final String nextToken;
    private final String requestId;

    private ListFoldersForResourceResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.folders = builder.folders;
        this.nextToken = builder.nextToken;
        this.requestId = builder.requestId;
    }

    public final Integer status() {
        return this.status;
    }

    public final boolean hasFolders() {
        return this.folders != null && !(this.folders instanceof SdkAutoConstructList);
    }

    public final List<String> folders() {
        return this.folders;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String requestId() {
        return this.requestId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFolders() ? this.folders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFoldersForResourceResponse)) {
            return false;
        }
        ListFoldersForResourceResponse other = (ListFoldersForResourceResponse)((Object)obj);
        return Objects.equals(this.status(), other.status()) && this.hasFolders() == other.hasFolders() && Objects.equals(this.folders(), other.folders()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.requestId(), other.requestId());
    }

    public final String toString() {
        return ToString.builder((String)"ListFoldersForResourceResponse").add("Status", (Object)this.status()).add("Folders", this.hasFolders() ? this.folders() : null).add("NextToken", (Object)this.nextToken()).add("RequestId", (Object)this.requestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "Folders": {
                return Optional.ofNullable(clazz.cast(this.folders()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFoldersForResourceResponse, T> g) {
        return obj -> g.apply((ListFoldersForResourceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private Integer status;
        private List<String> folders = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFoldersForResourceResponse model) {
            super(model);
            this.status(model.status);
            this.folders(model.folders);
            this.nextToken(model.nextToken);
            this.requestId(model.requestId);
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final Collection<String> getFolders() {
            if (this.folders instanceof SdkAutoConstructList) {
                return null;
            }
            return this.folders;
        }

        public final void setFolders(Collection<String> folders) {
            this.folders = FoldersForResourceArnListCopier.copy(folders);
        }

        @Override
        public final Builder folders(Collection<String> folders) {
            this.folders = FoldersForResourceArnListCopier.copy(folders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder folders(String ... folders) {
            this.folders(Arrays.asList(folders));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public ListFoldersForResourceResponse build() {
            return new ListFoldersForResourceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFoldersForResourceResponse> {
        public Builder status(Integer var1);

        public Builder folders(Collection<String> var1);

        public Builder folders(String ... var1);

        public Builder nextToken(String var1);

        public Builder requestId(String var1);
    }
}

