/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.VisualCustomAction;
import software.amazon.awssdk.services.quicksight.model.VisualCustomActionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EmptyVisual
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EmptyVisual> {
    private static final SdkField<String> VISUAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VisualId").getter(EmptyVisual.getter(EmptyVisual::visualId)).setter(EmptyVisual.setter(Builder::visualId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualId").build()}).build();
    private static final SdkField<String> DATA_SET_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSetIdentifier").getter(EmptyVisual.getter(EmptyVisual::dataSetIdentifier)).setter(EmptyVisual.setter(Builder::dataSetIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetIdentifier").build()}).build();
    private static final SdkField<List<VisualCustomAction>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Actions").getter(EmptyVisual.getter(EmptyVisual::actions)).setter(EmptyVisual.setter(Builder::actions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VisualCustomAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VISUAL_ID_FIELD, DATA_SET_IDENTIFIER_FIELD, ACTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String visualId;
    private final String dataSetIdentifier;
    private final List<VisualCustomAction> actions;

    private EmptyVisual(BuilderImpl builder) {
        this.visualId = builder.visualId;
        this.dataSetIdentifier = builder.dataSetIdentifier;
        this.actions = builder.actions;
    }

    public final String visualId() {
        return this.visualId;
    }

    public final String dataSetIdentifier() {
        return this.dataSetIdentifier;
    }

    public final boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructList);
    }

    public final List<VisualCustomAction> actions() {
        return this.actions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.visualId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSetIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActions() ? this.actions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmptyVisual)) {
            return false;
        }
        EmptyVisual other = (EmptyVisual)obj;
        return Objects.equals(this.visualId(), other.visualId()) && Objects.equals(this.dataSetIdentifier(), other.dataSetIdentifier()) && this.hasActions() == other.hasActions() && Objects.equals(this.actions(), other.actions());
    }

    public final String toString() {
        return ToString.builder((String)"EmptyVisual").add("VisualId", (Object)this.visualId()).add("DataSetIdentifier", (Object)this.dataSetIdentifier()).add("Actions", this.hasActions() ? this.actions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VisualId": {
                return Optional.ofNullable(clazz.cast(this.visualId()));
            }
            case "DataSetIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dataSetIdentifier()));
            }
            case "Actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EmptyVisual, T> g) {
        return obj -> g.apply((EmptyVisual)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String visualId;
        private String dataSetIdentifier;
        private List<VisualCustomAction> actions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EmptyVisual model) {
            this.visualId(model.visualId);
            this.dataSetIdentifier(model.dataSetIdentifier);
            this.actions(model.actions);
        }

        public final String getVisualId() {
            return this.visualId;
        }

        public final void setVisualId(String visualId) {
            this.visualId = visualId;
        }

        @Override
        public final Builder visualId(String visualId) {
            this.visualId = visualId;
            return this;
        }

        public final String getDataSetIdentifier() {
            return this.dataSetIdentifier;
        }

        public final void setDataSetIdentifier(String dataSetIdentifier) {
            this.dataSetIdentifier = dataSetIdentifier;
        }

        @Override
        public final Builder dataSetIdentifier(String dataSetIdentifier) {
            this.dataSetIdentifier = dataSetIdentifier;
            return this;
        }

        public final List<VisualCustomAction.Builder> getActions() {
            List<VisualCustomAction.Builder> result = VisualCustomActionListCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<VisualCustomAction.BuilderImpl> actions) {
            this.actions = VisualCustomActionListCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Collection<VisualCustomAction> actions) {
            this.actions = VisualCustomActionListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(VisualCustomAction ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<VisualCustomAction.Builder> ... actions) {
            this.actions(Stream.of(actions).map(c -> (VisualCustomAction)((VisualCustomAction.Builder)VisualCustomAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public EmptyVisual build() {
            return new EmptyVisual(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EmptyVisual> {
        public Builder visualId(String var1);

        public Builder dataSetIdentifier(String var1);

        public Builder actions(Collection<VisualCustomAction> var1);

        public Builder actions(VisualCustomAction ... var1);

        public Builder actions(Consumer<VisualCustomAction.Builder> ... var1);
    }
}

