/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateRefreshScheduleResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, UpdateRefreshScheduleResponse> {
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(UpdateRefreshScheduleResponse.getter(UpdateRefreshScheduleResponse::status)).setter(UpdateRefreshScheduleResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(UpdateRefreshScheduleResponse.getter(UpdateRefreshScheduleResponse::requestId)).setter(UpdateRefreshScheduleResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<String> SCHEDULE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScheduleId").getter(UpdateRefreshScheduleResponse.getter(UpdateRefreshScheduleResponse::scheduleId)).setter(UpdateRefreshScheduleResponse.setter(Builder::scheduleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleId").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(UpdateRefreshScheduleResponse.getter(UpdateRefreshScheduleResponse::arn)).setter(UpdateRefreshScheduleResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, REQUEST_ID_FIELD, SCHEDULE_ID_FIELD, ARN_FIELD));
    private final Integer status;
    private final String requestId;
    private final String scheduleId;
    private final String arn;

    private UpdateRefreshScheduleResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.requestId = builder.requestId;
        this.scheduleId = builder.scheduleId;
        this.arn = builder.arn;
    }

    public final Integer status() {
        return this.status;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final String scheduleId() {
        return this.scheduleId;
    }

    public final String arn() {
        return this.arn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRefreshScheduleResponse)) {
            return false;
        }
        UpdateRefreshScheduleResponse other = (UpdateRefreshScheduleResponse)((Object)obj);
        return Objects.equals(this.status(), other.status()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.scheduleId(), other.scheduleId()) && Objects.equals(this.arn(), other.arn());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateRefreshScheduleResponse").add("Status", (Object)this.status()).add("RequestId", (Object)this.requestId()).add("ScheduleId", (Object)this.scheduleId()).add("Arn", (Object)this.arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "ScheduleId": {
                return Optional.ofNullable(clazz.cast(this.scheduleId()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRefreshScheduleResponse, T> g) {
        return obj -> g.apply((UpdateRefreshScheduleResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private Integer status;
        private String requestId;
        private String scheduleId;
        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRefreshScheduleResponse model) {
            super(model);
            this.status(model.status);
            this.requestId(model.requestId);
            this.scheduleId(model.scheduleId);
            this.arn(model.arn);
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final String getScheduleId() {
            return this.scheduleId;
        }

        public final void setScheduleId(String scheduleId) {
            this.scheduleId = scheduleId;
        }

        @Override
        public final Builder scheduleId(String scheduleId) {
            this.scheduleId = scheduleId;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        @Override
        public UpdateRefreshScheduleResponse build() {
            return new UpdateRefreshScheduleResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateRefreshScheduleResponse> {
        public Builder status(Integer var1);

        public Builder requestId(String var1);

        public Builder scheduleId(String var1);

        public Builder arn(String var1);
    }
}

