/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobSummary;
import software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobSummaryListCopier;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAssetBundleImportJobsResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, ListAssetBundleImportJobsResponse> {
    private static final SdkField<List<AssetBundleImportJobSummary>> ASSET_BUNDLE_IMPORT_JOB_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssetBundleImportJobSummaryList").getter(ListAssetBundleImportJobsResponse.getter(ListAssetBundleImportJobsResponse::assetBundleImportJobSummaryList)).setter(ListAssetBundleImportJobsResponse.setter(Builder::assetBundleImportJobSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssetBundleImportJobSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssetBundleImportJobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAssetBundleImportJobsResponse.getter(ListAssetBundleImportJobsResponse::nextToken)).setter(ListAssetBundleImportJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(ListAssetBundleImportJobsResponse.getter(ListAssetBundleImportJobsResponse::requestId)).setter(ListAssetBundleImportJobsResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(ListAssetBundleImportJobsResponse.getter(ListAssetBundleImportJobsResponse::status)).setter(ListAssetBundleImportJobsResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_BUNDLE_IMPORT_JOB_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));
    private final List<AssetBundleImportJobSummary> assetBundleImportJobSummaryList;
    private final String nextToken;
    private final String requestId;
    private final Integer status;

    private ListAssetBundleImportJobsResponse(BuilderImpl builder) {
        super(builder);
        this.assetBundleImportJobSummaryList = builder.assetBundleImportJobSummaryList;
        this.nextToken = builder.nextToken;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    public final boolean hasAssetBundleImportJobSummaryList() {
        return this.assetBundleImportJobSummaryList != null && !(this.assetBundleImportJobSummaryList instanceof SdkAutoConstructList);
    }

    public final List<AssetBundleImportJobSummary> assetBundleImportJobSummaryList() {
        return this.assetBundleImportJobSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final Integer status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssetBundleImportJobSummaryList() ? this.assetBundleImportJobSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssetBundleImportJobsResponse)) {
            return false;
        }
        ListAssetBundleImportJobsResponse other = (ListAssetBundleImportJobsResponse)((Object)obj);
        return this.hasAssetBundleImportJobSummaryList() == other.hasAssetBundleImportJobSummaryList() && Objects.equals(this.assetBundleImportJobSummaryList(), other.assetBundleImportJobSummaryList()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"ListAssetBundleImportJobsResponse").add("AssetBundleImportJobSummaryList", this.hasAssetBundleImportJobSummaryList() ? this.assetBundleImportJobSummaryList() : null).add("NextToken", (Object)this.nextToken()).add("RequestId", (Object)this.requestId()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssetBundleImportJobSummaryList": {
                return Optional.ofNullable(clazz.cast(this.assetBundleImportJobSummaryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAssetBundleImportJobsResponse, T> g) {
        return obj -> g.apply((ListAssetBundleImportJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private List<AssetBundleImportJobSummary> assetBundleImportJobSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private String requestId;
        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssetBundleImportJobsResponse model) {
            super(model);
            this.assetBundleImportJobSummaryList(model.assetBundleImportJobSummaryList);
            this.nextToken(model.nextToken);
            this.requestId(model.requestId);
            this.status(model.status);
        }

        public final List<AssetBundleImportJobSummary.Builder> getAssetBundleImportJobSummaryList() {
            List<AssetBundleImportJobSummary.Builder> result = AssetBundleImportJobSummaryListCopier.copyToBuilder(this.assetBundleImportJobSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetBundleImportJobSummaryList(Collection<AssetBundleImportJobSummary.BuilderImpl> assetBundleImportJobSummaryList) {
            this.assetBundleImportJobSummaryList = AssetBundleImportJobSummaryListCopier.copyFromBuilder(assetBundleImportJobSummaryList);
        }

        @Override
        public final Builder assetBundleImportJobSummaryList(Collection<AssetBundleImportJobSummary> assetBundleImportJobSummaryList) {
            this.assetBundleImportJobSummaryList = AssetBundleImportJobSummaryListCopier.copy(assetBundleImportJobSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetBundleImportJobSummaryList(AssetBundleImportJobSummary ... assetBundleImportJobSummaryList) {
            this.assetBundleImportJobSummaryList(Arrays.asList(assetBundleImportJobSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetBundleImportJobSummaryList(Consumer<AssetBundleImportJobSummary.Builder> ... assetBundleImportJobSummaryList) {
            this.assetBundleImportJobSummaryList(Stream.of(assetBundleImportJobSummaryList).map(c -> (AssetBundleImportJobSummary)((AssetBundleImportJobSummary.Builder)AssetBundleImportJobSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        @Override
        public ListAssetBundleImportJobsResponse build() {
            return new ListAssetBundleImportJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAssetBundleImportJobsResponse> {
        public Builder assetBundleImportJobSummaryList(Collection<AssetBundleImportJobSummary> var1);

        public Builder assetBundleImportJobSummaryList(AssetBundleImportJobSummary ... var1);

        public Builder assetBundleImportJobSummaryList(Consumer<AssetBundleImportJobSummary.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder requestId(String var1);

        public Builder status(Integer var1);
    }
}

