/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightClient;
import software.amazon.awssdk.services.quicksight.internal.UserAgentUtils;
import software.amazon.awssdk.services.quicksight.model.ListRoleMembershipsRequest;
import software.amazon.awssdk.services.quicksight.model.ListRoleMembershipsResponse;

public class ListRoleMembershipsIterable
implements SdkIterable<ListRoleMembershipsResponse> {
    private final QuickSightClient client;
    private final ListRoleMembershipsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRoleMembershipsIterable(QuickSightClient client, ListRoleMembershipsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRoleMembershipsResponseFetcher();
    }

    public Iterator<ListRoleMembershipsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> membersList() {
        Function<ListRoleMembershipsResponse, Iterator> getIterator = response -> {
            if (response != null && response.membersList() != null) {
                return response.membersList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRoleMembershipsResponseFetcher
    implements SyncPageFetcher<ListRoleMembershipsResponse> {
        private ListRoleMembershipsResponseFetcher() {
        }

        public boolean hasNextPage(ListRoleMembershipsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRoleMembershipsResponse nextPage(ListRoleMembershipsResponse previousPage) {
            if (previousPage == null) {
                return ListRoleMembershipsIterable.this.client.listRoleMemberships(ListRoleMembershipsIterable.this.firstRequest);
            }
            return ListRoleMembershipsIterable.this.client.listRoleMemberships((ListRoleMembershipsRequest)((Object)ListRoleMembershipsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

