/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.AnchorDateConfiguration;
import software.amazon.awssdk.services.quicksight.model.ColumnIdentifier;
import software.amazon.awssdk.services.quicksight.model.DefaultFilterControlConfiguration;
import software.amazon.awssdk.services.quicksight.model.ExcludePeriodConfiguration;
import software.amazon.awssdk.services.quicksight.model.FilterNullOption;
import software.amazon.awssdk.services.quicksight.model.RelativeDateType;
import software.amazon.awssdk.services.quicksight.model.TimeGranularity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RelativeDatesFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RelativeDatesFilter> {
    private static final SdkField<String> FILTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FilterId").getter(RelativeDatesFilter.getter(RelativeDatesFilter::filterId)).setter(RelativeDatesFilter.setter(Builder::filterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterId").build()}).build();
    private static final SdkField<ColumnIdentifier> COLUMN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Column").getter(RelativeDatesFilter.getter(RelativeDatesFilter::column)).setter(RelativeDatesFilter.setter(Builder::column)).constructor(ColumnIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Column").build()}).build();
    private static final SdkField<AnchorDateConfiguration> ANCHOR_DATE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AnchorDateConfiguration").getter(RelativeDatesFilter.getter(RelativeDatesFilter::anchorDateConfiguration)).setter(RelativeDatesFilter.setter(Builder::anchorDateConfiguration)).constructor(AnchorDateConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnchorDateConfiguration").build()}).build();
    private static final SdkField<String> MINIMUM_GRANULARITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MinimumGranularity").getter(RelativeDatesFilter.getter(RelativeDatesFilter::minimumGranularityAsString)).setter(RelativeDatesFilter.setter(Builder::minimumGranularity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumGranularity").build()}).build();
    private static final SdkField<String> TIME_GRANULARITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimeGranularity").getter(RelativeDatesFilter.getter(RelativeDatesFilter::timeGranularityAsString)).setter(RelativeDatesFilter.setter(Builder::timeGranularity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeGranularity").build()}).build();
    private static final SdkField<String> RELATIVE_DATE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RelativeDateType").getter(RelativeDatesFilter.getter(RelativeDatesFilter::relativeDateTypeAsString)).setter(RelativeDatesFilter.setter(Builder::relativeDateType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelativeDateType").build()}).build();
    private static final SdkField<Integer> RELATIVE_DATE_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RelativeDateValue").getter(RelativeDatesFilter.getter(RelativeDatesFilter::relativeDateValue)).setter(RelativeDatesFilter.setter(Builder::relativeDateValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelativeDateValue").build()}).build();
    private static final SdkField<String> PARAMETER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParameterName").getter(RelativeDatesFilter.getter(RelativeDatesFilter::parameterName)).setter(RelativeDatesFilter.setter(Builder::parameterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterName").build()}).build();
    private static final SdkField<String> NULL_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NullOption").getter(RelativeDatesFilter.getter(RelativeDatesFilter::nullOptionAsString)).setter(RelativeDatesFilter.setter(Builder::nullOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NullOption").build()}).build();
    private static final SdkField<ExcludePeriodConfiguration> EXCLUDE_PERIOD_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExcludePeriodConfiguration").getter(RelativeDatesFilter.getter(RelativeDatesFilter::excludePeriodConfiguration)).setter(RelativeDatesFilter.setter(Builder::excludePeriodConfiguration)).constructor(ExcludePeriodConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludePeriodConfiguration").build()}).build();
    private static final SdkField<DefaultFilterControlConfiguration> DEFAULT_FILTER_CONTROL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultFilterControlConfiguration").getter(RelativeDatesFilter.getter(RelativeDatesFilter::defaultFilterControlConfiguration)).setter(RelativeDatesFilter.setter(Builder::defaultFilterControlConfiguration)).constructor(DefaultFilterControlConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultFilterControlConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_ID_FIELD, COLUMN_FIELD, ANCHOR_DATE_CONFIGURATION_FIELD, MINIMUM_GRANULARITY_FIELD, TIME_GRANULARITY_FIELD, RELATIVE_DATE_TYPE_FIELD, RELATIVE_DATE_VALUE_FIELD, PARAMETER_NAME_FIELD, NULL_OPTION_FIELD, EXCLUDE_PERIOD_CONFIGURATION_FIELD, DEFAULT_FILTER_CONTROL_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String filterId;
    private final ColumnIdentifier column;
    private final AnchorDateConfiguration anchorDateConfiguration;
    private final String minimumGranularity;
    private final String timeGranularity;
    private final String relativeDateType;
    private final Integer relativeDateValue;
    private final String parameterName;
    private final String nullOption;
    private final ExcludePeriodConfiguration excludePeriodConfiguration;
    private final DefaultFilterControlConfiguration defaultFilterControlConfiguration;

    private RelativeDatesFilter(BuilderImpl builder) {
        this.filterId = builder.filterId;
        this.column = builder.column;
        this.anchorDateConfiguration = builder.anchorDateConfiguration;
        this.minimumGranularity = builder.minimumGranularity;
        this.timeGranularity = builder.timeGranularity;
        this.relativeDateType = builder.relativeDateType;
        this.relativeDateValue = builder.relativeDateValue;
        this.parameterName = builder.parameterName;
        this.nullOption = builder.nullOption;
        this.excludePeriodConfiguration = builder.excludePeriodConfiguration;
        this.defaultFilterControlConfiguration = builder.defaultFilterControlConfiguration;
    }

    public final String filterId() {
        return this.filterId;
    }

    public final ColumnIdentifier column() {
        return this.column;
    }

    public final AnchorDateConfiguration anchorDateConfiguration() {
        return this.anchorDateConfiguration;
    }

    public final TimeGranularity minimumGranularity() {
        return TimeGranularity.fromValue(this.minimumGranularity);
    }

    public final String minimumGranularityAsString() {
        return this.minimumGranularity;
    }

    public final TimeGranularity timeGranularity() {
        return TimeGranularity.fromValue(this.timeGranularity);
    }

    public final String timeGranularityAsString() {
        return this.timeGranularity;
    }

    public final RelativeDateType relativeDateType() {
        return RelativeDateType.fromValue(this.relativeDateType);
    }

    public final String relativeDateTypeAsString() {
        return this.relativeDateType;
    }

    public final Integer relativeDateValue() {
        return this.relativeDateValue;
    }

    public final String parameterName() {
        return this.parameterName;
    }

    public final FilterNullOption nullOption() {
        return FilterNullOption.fromValue(this.nullOption);
    }

    public final String nullOptionAsString() {
        return this.nullOption;
    }

    public final ExcludePeriodConfiguration excludePeriodConfiguration() {
        return this.excludePeriodConfiguration;
    }

    public final DefaultFilterControlConfiguration defaultFilterControlConfiguration() {
        return this.defaultFilterControlConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.column());
        hashCode = 31 * hashCode + Objects.hashCode(this.anchorDateConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumGranularityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeGranularityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.relativeDateTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.relativeDateValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nullOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.excludePeriodConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultFilterControlConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelativeDatesFilter)) {
            return false;
        }
        RelativeDatesFilter other = (RelativeDatesFilter)obj;
        return Objects.equals(this.filterId(), other.filterId()) && Objects.equals(this.column(), other.column()) && Objects.equals(this.anchorDateConfiguration(), other.anchorDateConfiguration()) && Objects.equals(this.minimumGranularityAsString(), other.minimumGranularityAsString()) && Objects.equals(this.timeGranularityAsString(), other.timeGranularityAsString()) && Objects.equals(this.relativeDateTypeAsString(), other.relativeDateTypeAsString()) && Objects.equals(this.relativeDateValue(), other.relativeDateValue()) && Objects.equals(this.parameterName(), other.parameterName()) && Objects.equals(this.nullOptionAsString(), other.nullOptionAsString()) && Objects.equals(this.excludePeriodConfiguration(), other.excludePeriodConfiguration()) && Objects.equals(this.defaultFilterControlConfiguration(), other.defaultFilterControlConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"RelativeDatesFilter").add("FilterId", (Object)this.filterId()).add("Column", (Object)this.column()).add("AnchorDateConfiguration", (Object)this.anchorDateConfiguration()).add("MinimumGranularity", (Object)this.minimumGranularityAsString()).add("TimeGranularity", (Object)this.timeGranularityAsString()).add("RelativeDateType", (Object)this.relativeDateTypeAsString()).add("RelativeDateValue", (Object)this.relativeDateValue()).add("ParameterName", (Object)this.parameterName()).add("NullOption", (Object)this.nullOptionAsString()).add("ExcludePeriodConfiguration", (Object)this.excludePeriodConfiguration()).add("DefaultFilterControlConfiguration", (Object)this.defaultFilterControlConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FilterId": {
                return Optional.ofNullable(clazz.cast(this.filterId()));
            }
            case "Column": {
                return Optional.ofNullable(clazz.cast(this.column()));
            }
            case "AnchorDateConfiguration": {
                return Optional.ofNullable(clazz.cast(this.anchorDateConfiguration()));
            }
            case "MinimumGranularity": {
                return Optional.ofNullable(clazz.cast(this.minimumGranularityAsString()));
            }
            case "TimeGranularity": {
                return Optional.ofNullable(clazz.cast(this.timeGranularityAsString()));
            }
            case "RelativeDateType": {
                return Optional.ofNullable(clazz.cast(this.relativeDateTypeAsString()));
            }
            case "RelativeDateValue": {
                return Optional.ofNullable(clazz.cast(this.relativeDateValue()));
            }
            case "ParameterName": {
                return Optional.ofNullable(clazz.cast(this.parameterName()));
            }
            case "NullOption": {
                return Optional.ofNullable(clazz.cast(this.nullOptionAsString()));
            }
            case "ExcludePeriodConfiguration": {
                return Optional.ofNullable(clazz.cast(this.excludePeriodConfiguration()));
            }
            case "DefaultFilterControlConfiguration": {
                return Optional.ofNullable(clazz.cast(this.defaultFilterControlConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RelativeDatesFilter, T> g) {
        return obj -> g.apply((RelativeDatesFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String filterId;
        private ColumnIdentifier column;
        private AnchorDateConfiguration anchorDateConfiguration;
        private String minimumGranularity;
        private String timeGranularity;
        private String relativeDateType;
        private Integer relativeDateValue;
        private String parameterName;
        private String nullOption;
        private ExcludePeriodConfiguration excludePeriodConfiguration;
        private DefaultFilterControlConfiguration defaultFilterControlConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(RelativeDatesFilter model) {
            this.filterId(model.filterId);
            this.column(model.column);
            this.anchorDateConfiguration(model.anchorDateConfiguration);
            this.minimumGranularity(model.minimumGranularity);
            this.timeGranularity(model.timeGranularity);
            this.relativeDateType(model.relativeDateType);
            this.relativeDateValue(model.relativeDateValue);
            this.parameterName(model.parameterName);
            this.nullOption(model.nullOption);
            this.excludePeriodConfiguration(model.excludePeriodConfiguration);
            this.defaultFilterControlConfiguration(model.defaultFilterControlConfiguration);
        }

        public final String getFilterId() {
            return this.filterId;
        }

        public final void setFilterId(String filterId) {
            this.filterId = filterId;
        }

        @Override
        public final Builder filterId(String filterId) {
            this.filterId = filterId;
            return this;
        }

        public final ColumnIdentifier.Builder getColumn() {
            return this.column != null ? this.column.toBuilder() : null;
        }

        public final void setColumn(ColumnIdentifier.BuilderImpl column) {
            this.column = column != null ? column.build() : null;
        }

        @Override
        public final Builder column(ColumnIdentifier column) {
            this.column = column;
            return this;
        }

        public final AnchorDateConfiguration.Builder getAnchorDateConfiguration() {
            return this.anchorDateConfiguration != null ? this.anchorDateConfiguration.toBuilder() : null;
        }

        public final void setAnchorDateConfiguration(AnchorDateConfiguration.BuilderImpl anchorDateConfiguration) {
            this.anchorDateConfiguration = anchorDateConfiguration != null ? anchorDateConfiguration.build() : null;
        }

        @Override
        public final Builder anchorDateConfiguration(AnchorDateConfiguration anchorDateConfiguration) {
            this.anchorDateConfiguration = anchorDateConfiguration;
            return this;
        }

        public final String getMinimumGranularity() {
            return this.minimumGranularity;
        }

        public final void setMinimumGranularity(String minimumGranularity) {
            this.minimumGranularity = minimumGranularity;
        }

        @Override
        public final Builder minimumGranularity(String minimumGranularity) {
            this.minimumGranularity = minimumGranularity;
            return this;
        }

        @Override
        public final Builder minimumGranularity(TimeGranularity minimumGranularity) {
            this.minimumGranularity(minimumGranularity == null ? null : minimumGranularity.toString());
            return this;
        }

        public final String getTimeGranularity() {
            return this.timeGranularity;
        }

        public final void setTimeGranularity(String timeGranularity) {
            this.timeGranularity = timeGranularity;
        }

        @Override
        public final Builder timeGranularity(String timeGranularity) {
            this.timeGranularity = timeGranularity;
            return this;
        }

        @Override
        public final Builder timeGranularity(TimeGranularity timeGranularity) {
            this.timeGranularity(timeGranularity == null ? null : timeGranularity.toString());
            return this;
        }

        public final String getRelativeDateType() {
            return this.relativeDateType;
        }

        public final void setRelativeDateType(String relativeDateType) {
            this.relativeDateType = relativeDateType;
        }

        @Override
        public final Builder relativeDateType(String relativeDateType) {
            this.relativeDateType = relativeDateType;
            return this;
        }

        @Override
        public final Builder relativeDateType(RelativeDateType relativeDateType) {
            this.relativeDateType(relativeDateType == null ? null : relativeDateType.toString());
            return this;
        }

        public final Integer getRelativeDateValue() {
            return this.relativeDateValue;
        }

        public final void setRelativeDateValue(Integer relativeDateValue) {
            this.relativeDateValue = relativeDateValue;
        }

        @Override
        public final Builder relativeDateValue(Integer relativeDateValue) {
            this.relativeDateValue = relativeDateValue;
            return this;
        }

        public final String getParameterName() {
            return this.parameterName;
        }

        public final void setParameterName(String parameterName) {
            this.parameterName = parameterName;
        }

        @Override
        public final Builder parameterName(String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        public final String getNullOption() {
            return this.nullOption;
        }

        public final void setNullOption(String nullOption) {
            this.nullOption = nullOption;
        }

        @Override
        public final Builder nullOption(String nullOption) {
            this.nullOption = nullOption;
            return this;
        }

        @Override
        public final Builder nullOption(FilterNullOption nullOption) {
            this.nullOption(nullOption == null ? null : nullOption.toString());
            return this;
        }

        public final ExcludePeriodConfiguration.Builder getExcludePeriodConfiguration() {
            return this.excludePeriodConfiguration != null ? this.excludePeriodConfiguration.toBuilder() : null;
        }

        public final void setExcludePeriodConfiguration(ExcludePeriodConfiguration.BuilderImpl excludePeriodConfiguration) {
            this.excludePeriodConfiguration = excludePeriodConfiguration != null ? excludePeriodConfiguration.build() : null;
        }

        @Override
        public final Builder excludePeriodConfiguration(ExcludePeriodConfiguration excludePeriodConfiguration) {
            this.excludePeriodConfiguration = excludePeriodConfiguration;
            return this;
        }

        public final DefaultFilterControlConfiguration.Builder getDefaultFilterControlConfiguration() {
            return this.defaultFilterControlConfiguration != null ? this.defaultFilterControlConfiguration.toBuilder() : null;
        }

        public final void setDefaultFilterControlConfiguration(DefaultFilterControlConfiguration.BuilderImpl defaultFilterControlConfiguration) {
            this.defaultFilterControlConfiguration = defaultFilterControlConfiguration != null ? defaultFilterControlConfiguration.build() : null;
        }

        @Override
        public final Builder defaultFilterControlConfiguration(DefaultFilterControlConfiguration defaultFilterControlConfiguration) {
            this.defaultFilterControlConfiguration = defaultFilterControlConfiguration;
            return this;
        }

        public RelativeDatesFilter build() {
            return new RelativeDatesFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RelativeDatesFilter> {
        public Builder filterId(String var1);

        public Builder column(ColumnIdentifier var1);

        default public Builder column(Consumer<ColumnIdentifier.Builder> column) {
            return this.column((ColumnIdentifier)((ColumnIdentifier.Builder)ColumnIdentifier.builder().applyMutation(column)).build());
        }

        public Builder anchorDateConfiguration(AnchorDateConfiguration var1);

        default public Builder anchorDateConfiguration(Consumer<AnchorDateConfiguration.Builder> anchorDateConfiguration) {
            return this.anchorDateConfiguration((AnchorDateConfiguration)((AnchorDateConfiguration.Builder)AnchorDateConfiguration.builder().applyMutation(anchorDateConfiguration)).build());
        }

        public Builder minimumGranularity(String var1);

        public Builder minimumGranularity(TimeGranularity var1);

        public Builder timeGranularity(String var1);

        public Builder timeGranularity(TimeGranularity var1);

        public Builder relativeDateType(String var1);

        public Builder relativeDateType(RelativeDateType var1);

        public Builder relativeDateValue(Integer var1);

        public Builder parameterName(String var1);

        public Builder nullOption(String var1);

        public Builder nullOption(FilterNullOption var1);

        public Builder excludePeriodConfiguration(ExcludePeriodConfiguration var1);

        default public Builder excludePeriodConfiguration(Consumer<ExcludePeriodConfiguration.Builder> excludePeriodConfiguration) {
            return this.excludePeriodConfiguration((ExcludePeriodConfiguration)((ExcludePeriodConfiguration.Builder)ExcludePeriodConfiguration.builder().applyMutation(excludePeriodConfiguration)).build());
        }

        public Builder defaultFilterControlConfiguration(DefaultFilterControlConfiguration var1);

        default public Builder defaultFilterControlConfiguration(Consumer<DefaultFilterControlConfiguration.Builder> defaultFilterControlConfiguration) {
            return this.defaultFilterControlConfiguration((DefaultFilterControlConfiguration)((DefaultFilterControlConfiguration.Builder)DefaultFilterControlConfiguration.builder().applyMutation(defaultFilterControlConfiguration)).build());
        }
    }
}

