/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BaseMapStyleType {
    LIGHT_GRAY("LIGHT_GRAY"),
    DARK_GRAY("DARK_GRAY"),
    STREET("STREET"),
    IMAGERY("IMAGERY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BaseMapStyleType> VALUE_MAP;
    private final String value;

    private BaseMapStyleType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BaseMapStyleType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BaseMapStyleType> knownValues() {
        EnumSet<BaseMapStyleType> knownValues = EnumSet.allOf(BaseMapStyleType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BaseMapStyleType.class, BaseMapStyleType::toString);
    }
}

