/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.TopicIRContributionAnalysis;
import software.amazon.awssdk.services.quicksight.model.TopicIRFilterListCopier;
import software.amazon.awssdk.services.quicksight.model.TopicIRFilterOption;
import software.amazon.awssdk.services.quicksight.model.TopicIRGroupBy;
import software.amazon.awssdk.services.quicksight.model.TopicIRGroupByListCopier;
import software.amazon.awssdk.services.quicksight.model.TopicIRMetric;
import software.amazon.awssdk.services.quicksight.model.TopicIRMetricListCopier;
import software.amazon.awssdk.services.quicksight.model.TopicSortClause;
import software.amazon.awssdk.services.quicksight.model.VisualOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TopicIR
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TopicIR> {
    private static final SdkField<List<TopicIRMetric>> METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Metrics").getter(TopicIR.getter(TopicIR::metrics)).setter(TopicIR.setter(Builder::metrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TopicIRMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<TopicIRGroupBy>> GROUP_BY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GroupByList").getter(TopicIR.getter(TopicIR::groupByList)).setter(TopicIR.setter(Builder::groupByList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupByList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TopicIRGroupBy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<List<TopicIRFilterOption>>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(TopicIR.getter(TopicIR::filters)).setter(TopicIR.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TopicIRFilterOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<TopicSortClause> SORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Sort").getter(TopicIR.getter(TopicIR::sort)).setter(TopicIR.setter(Builder::sort)).constructor(TopicSortClause::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sort").build()}).build();
    private static final SdkField<TopicIRContributionAnalysis> CONTRIBUTION_ANALYSIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ContributionAnalysis").getter(TopicIR.getter(TopicIR::contributionAnalysis)).setter(TopicIR.setter(Builder::contributionAnalysis)).constructor(TopicIRContributionAnalysis::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContributionAnalysis").build()}).build();
    private static final SdkField<VisualOptions> VISUAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Visual").getter(TopicIR.getter(TopicIR::visual)).setter(TopicIR.setter(Builder::visual)).constructor(VisualOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visual").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRICS_FIELD, GROUP_BY_LIST_FIELD, FILTERS_FIELD, SORT_FIELD, CONTRIBUTION_ANALYSIS_FIELD, VISUAL_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<TopicIRMetric> metrics;
    private final List<TopicIRGroupBy> groupByList;
    private final List<List<TopicIRFilterOption>> filters;
    private final TopicSortClause sort;
    private final TopicIRContributionAnalysis contributionAnalysis;
    private final VisualOptions visual;

    private TopicIR(BuilderImpl builder) {
        this.metrics = builder.metrics;
        this.groupByList = builder.groupByList;
        this.filters = builder.filters;
        this.sort = builder.sort;
        this.contributionAnalysis = builder.contributionAnalysis;
        this.visual = builder.visual;
    }

    public final boolean hasMetrics() {
        return this.metrics != null && !(this.metrics instanceof SdkAutoConstructList);
    }

    public final List<TopicIRMetric> metrics() {
        return this.metrics;
    }

    public final boolean hasGroupByList() {
        return this.groupByList != null && !(this.groupByList instanceof SdkAutoConstructList);
    }

    public final List<TopicIRGroupBy> groupByList() {
        return this.groupByList;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<List<TopicIRFilterOption>> filters() {
        return this.filters;
    }

    public final TopicSortClause sort() {
        return this.sort;
    }

    public final TopicIRContributionAnalysis contributionAnalysis() {
        return this.contributionAnalysis;
    }

    public final VisualOptions visual() {
        return this.visual;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetrics() ? this.metrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupByList() ? this.groupByList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sort());
        hashCode = 31 * hashCode + Objects.hashCode(this.contributionAnalysis());
        hashCode = 31 * hashCode + Objects.hashCode(this.visual());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicIR)) {
            return false;
        }
        TopicIR other = (TopicIR)obj;
        return this.hasMetrics() == other.hasMetrics() && Objects.equals(this.metrics(), other.metrics()) && this.hasGroupByList() == other.hasGroupByList() && Objects.equals(this.groupByList(), other.groupByList()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.sort(), other.sort()) && Objects.equals(this.contributionAnalysis(), other.contributionAnalysis()) && Objects.equals(this.visual(), other.visual());
    }

    public final String toString() {
        return ToString.builder((String)"TopicIR").add("Metrics", this.hasMetrics() ? this.metrics() : null).add("GroupByList", this.hasGroupByList() ? this.groupByList() : null).add("Filters", this.hasFilters() ? this.filters() : null).add("Sort", (Object)this.sort()).add("ContributionAnalysis", (Object)this.contributionAnalysis()).add("Visual", (Object)this.visual()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Metrics": {
                return Optional.ofNullable(clazz.cast(this.metrics()));
            }
            case "GroupByList": {
                return Optional.ofNullable(clazz.cast(this.groupByList()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "Sort": {
                return Optional.ofNullable(clazz.cast(this.sort()));
            }
            case "ContributionAnalysis": {
                return Optional.ofNullable(clazz.cast(this.contributionAnalysis()));
            }
            case "Visual": {
                return Optional.ofNullable(clazz.cast(this.visual()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TopicIR, T> g) {
        return obj -> g.apply((TopicIR)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<TopicIRMetric> metrics = DefaultSdkAutoConstructList.getInstance();
        private List<TopicIRGroupBy> groupByList = DefaultSdkAutoConstructList.getInstance();
        private List<List<TopicIRFilterOption>> filters = DefaultSdkAutoConstructList.getInstance();
        private TopicSortClause sort;
        private TopicIRContributionAnalysis contributionAnalysis;
        private VisualOptions visual;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicIR model) {
            this.metrics(model.metrics);
            this.groupByList(model.groupByList);
            this.filters(model.filters);
            this.sort(model.sort);
            this.contributionAnalysis(model.contributionAnalysis);
            this.visual(model.visual);
        }

        public final List<TopicIRMetric.Builder> getMetrics() {
            List<TopicIRMetric.Builder> result = TopicIRMetricListCopier.copyToBuilder(this.metrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetrics(Collection<TopicIRMetric.BuilderImpl> metrics) {
            this.metrics = TopicIRMetricListCopier.copyFromBuilder(metrics);
        }

        @Override
        public final Builder metrics(Collection<TopicIRMetric> metrics) {
            this.metrics = TopicIRMetricListCopier.copy(metrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(TopicIRMetric ... metrics) {
            this.metrics(Arrays.asList(metrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(Consumer<TopicIRMetric.Builder> ... metrics) {
            this.metrics(Stream.of(metrics).map(c -> (TopicIRMetric)((TopicIRMetric.Builder)TopicIRMetric.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<TopicIRGroupBy.Builder> getGroupByList() {
            List<TopicIRGroupBy.Builder> result = TopicIRGroupByListCopier.copyToBuilder(this.groupByList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupByList(Collection<TopicIRGroupBy.BuilderImpl> groupByList) {
            this.groupByList = TopicIRGroupByListCopier.copyFromBuilder(groupByList);
        }

        @Override
        public final Builder groupByList(Collection<TopicIRGroupBy> groupByList) {
            this.groupByList = TopicIRGroupByListCopier.copy(groupByList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupByList(TopicIRGroupBy ... groupByList) {
            this.groupByList(Arrays.asList(groupByList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupByList(Consumer<TopicIRGroupBy.Builder> ... groupByList) {
            this.groupByList(Stream.of(groupByList).map(c -> (TopicIRGroupBy)((TopicIRGroupBy.Builder)TopicIRGroupBy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<List<TopicIRFilterOption.Builder>> getFilters() {
            List<List<TopicIRFilterOption.Builder>> result = TopicIRFilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<? extends Collection<TopicIRFilterOption.BuilderImpl>> filters) {
            this.filters = TopicIRFilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<? extends Collection<TopicIRFilterOption>> filters) {
            this.filters = TopicIRFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Collection<TopicIRFilterOption> ... filters) {
            this.filters((Collection<? extends Collection<TopicIRFilterOption>>)Arrays.asList(filters));
            return this;
        }

        public final TopicSortClause.Builder getSort() {
            return this.sort != null ? this.sort.toBuilder() : null;
        }

        public final void setSort(TopicSortClause.BuilderImpl sort) {
            this.sort = sort != null ? sort.build() : null;
        }

        @Override
        public final Builder sort(TopicSortClause sort) {
            this.sort = sort;
            return this;
        }

        public final TopicIRContributionAnalysis.Builder getContributionAnalysis() {
            return this.contributionAnalysis != null ? this.contributionAnalysis.toBuilder() : null;
        }

        public final void setContributionAnalysis(TopicIRContributionAnalysis.BuilderImpl contributionAnalysis) {
            this.contributionAnalysis = contributionAnalysis != null ? contributionAnalysis.build() : null;
        }

        @Override
        public final Builder contributionAnalysis(TopicIRContributionAnalysis contributionAnalysis) {
            this.contributionAnalysis = contributionAnalysis;
            return this;
        }

        public final VisualOptions.Builder getVisual() {
            return this.visual != null ? this.visual.toBuilder() : null;
        }

        public final void setVisual(VisualOptions.BuilderImpl visual) {
            this.visual = visual != null ? visual.build() : null;
        }

        @Override
        public final Builder visual(VisualOptions visual) {
            this.visual = visual;
            return this;
        }

        public TopicIR build() {
            return new TopicIR(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TopicIR> {
        public Builder metrics(Collection<TopicIRMetric> var1);

        public Builder metrics(TopicIRMetric ... var1);

        public Builder metrics(Consumer<TopicIRMetric.Builder> ... var1);

        public Builder groupByList(Collection<TopicIRGroupBy> var1);

        public Builder groupByList(TopicIRGroupBy ... var1);

        public Builder groupByList(Consumer<TopicIRGroupBy.Builder> ... var1);

        public Builder filters(Collection<? extends Collection<TopicIRFilterOption>> var1);

        public Builder filters(Collection<TopicIRFilterOption> ... var1);

        public Builder sort(TopicSortClause var1);

        default public Builder sort(Consumer<TopicSortClause.Builder> sort) {
            return this.sort((TopicSortClause)((TopicSortClause.Builder)TopicSortClause.builder().applyMutation(sort)).build());
        }

        public Builder contributionAnalysis(TopicIRContributionAnalysis var1);

        default public Builder contributionAnalysis(Consumer<TopicIRContributionAnalysis.Builder> contributionAnalysis) {
            return this.contributionAnalysis((TopicIRContributionAnalysis)((TopicIRContributionAnalysis.Builder)TopicIRContributionAnalysis.builder().applyMutation(contributionAnalysis)).build());
        }

        public Builder visual(VisualOptions var1);

        default public Builder visual(Consumer<VisualOptions.Builder> visual) {
            return this.visual((VisualOptions)((VisualOptions.Builder)VisualOptions.builder().applyMutation(visual)).build());
        }
    }
}

