/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.BoxPlotFillStyle;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BoxPlotStyleOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BoxPlotStyleOptions> {
    private static final SdkField<String> FILL_STYLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FillStyle").getter(BoxPlotStyleOptions.getter(BoxPlotStyleOptions::fillStyleAsString)).setter(BoxPlotStyleOptions.setter(Builder::fillStyle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FillStyle").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILL_STYLE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String fillStyle;

    private BoxPlotStyleOptions(BuilderImpl builder) {
        this.fillStyle = builder.fillStyle;
    }

    public final BoxPlotFillStyle fillStyle() {
        return BoxPlotFillStyle.fromValue(this.fillStyle);
    }

    public final String fillStyleAsString() {
        return this.fillStyle;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fillStyleAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BoxPlotStyleOptions)) {
            return false;
        }
        BoxPlotStyleOptions other = (BoxPlotStyleOptions)obj;
        return Objects.equals(this.fillStyleAsString(), other.fillStyleAsString());
    }

    public final String toString() {
        return ToString.builder((String)"BoxPlotStyleOptions").add("FillStyle", (Object)this.fillStyleAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FillStyle": {
                return Optional.ofNullable(clazz.cast(this.fillStyleAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BoxPlotStyleOptions, T> g) {
        return obj -> g.apply((BoxPlotStyleOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fillStyle;

        private BuilderImpl() {
        }

        private BuilderImpl(BoxPlotStyleOptions model) {
            this.fillStyle(model.fillStyle);
        }

        public final String getFillStyle() {
            return this.fillStyle;
        }

        public final void setFillStyle(String fillStyle) {
            this.fillStyle = fillStyle;
        }

        @Override
        public final Builder fillStyle(String fillStyle) {
            this.fillStyle = fillStyle;
            return this;
        }

        @Override
        public final Builder fillStyle(BoxPlotFillStyle fillStyle) {
            this.fillStyle(fillStyle == null ? null : fillStyle.toString());
            return this;
        }

        public BoxPlotStyleOptions build() {
            return new BoxPlotStyleOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BoxPlotStyleOptions> {
        public Builder fillStyle(String var1);

        public Builder fillStyle(BoxPlotFillStyle var1);
    }
}

