/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.Slot;
import software.amazon.awssdk.services.quicksight.model.SlotsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TopicTemplate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TopicTemplate> {
    private static final SdkField<String> TEMPLATE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateType").getter(TopicTemplate.getter(TopicTemplate::templateType)).setter(TopicTemplate.setter(Builder::templateType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateType").build()}).build();
    private static final SdkField<List<Slot>> SLOTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Slots").getter(TopicTemplate.getter(TopicTemplate::slots)).setter(TopicTemplate.setter(Builder::slots)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Slots").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Slot::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_TYPE_FIELD, SLOTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String templateType;
    private final List<Slot> slots;

    private TopicTemplate(BuilderImpl builder) {
        this.templateType = builder.templateType;
        this.slots = builder.slots;
    }

    public final String templateType() {
        return this.templateType;
    }

    public final boolean hasSlots() {
        return this.slots != null && !(this.slots instanceof SdkAutoConstructList);
    }

    public final List<Slot> slots() {
        return this.slots;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.templateType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSlots() ? this.slots() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicTemplate)) {
            return false;
        }
        TopicTemplate other = (TopicTemplate)obj;
        return Objects.equals(this.templateType(), other.templateType()) && this.hasSlots() == other.hasSlots() && Objects.equals(this.slots(), other.slots());
    }

    public final String toString() {
        return ToString.builder((String)"TopicTemplate").add("TemplateType", (Object)this.templateType()).add("Slots", this.hasSlots() ? this.slots() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TemplateType": {
                return Optional.ofNullable(clazz.cast(this.templateType()));
            }
            case "Slots": {
                return Optional.ofNullable(clazz.cast(this.slots()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TopicTemplate, T> g) {
        return obj -> g.apply((TopicTemplate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String templateType;
        private List<Slot> slots = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TopicTemplate model) {
            this.templateType(model.templateType);
            this.slots(model.slots);
        }

        public final String getTemplateType() {
            return this.templateType;
        }

        public final void setTemplateType(String templateType) {
            this.templateType = templateType;
        }

        @Override
        public final Builder templateType(String templateType) {
            this.templateType = templateType;
            return this;
        }

        public final List<Slot.Builder> getSlots() {
            List<Slot.Builder> result = SlotsCopier.copyToBuilder(this.slots);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSlots(Collection<Slot.BuilderImpl> slots) {
            this.slots = SlotsCopier.copyFromBuilder(slots);
        }

        @Override
        public final Builder slots(Collection<Slot> slots) {
            this.slots = SlotsCopier.copy(slots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slots(Slot ... slots) {
            this.slots(Arrays.asList(slots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slots(Consumer<Slot.Builder> ... slots) {
            this.slots(Stream.of(slots).map(c -> (Slot)((Slot.Builder)Slot.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public TopicTemplate build() {
            return new TopicTemplate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TopicTemplate> {
        public Builder templateType(String var1);

        public Builder slots(Collection<Slot> var1);

        public Builder slots(Slot ... var1);

        public Builder slots(Consumer<Slot.Builder> ... var1);
    }
}

