/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.AxisDisplayOptions;
import software.amazon.awssdk.services.quicksight.model.ChartAxisLabelOptions;
import software.amazon.awssdk.services.quicksight.model.LegendOptions;
import software.amazon.awssdk.services.quicksight.model.RadarChartAxesRangeScale;
import software.amazon.awssdk.services.quicksight.model.RadarChartFieldWells;
import software.amazon.awssdk.services.quicksight.model.RadarChartSeriesSettings;
import software.amazon.awssdk.services.quicksight.model.RadarChartShape;
import software.amazon.awssdk.services.quicksight.model.RadarChartSortConfiguration;
import software.amazon.awssdk.services.quicksight.model.Visibility;
import software.amazon.awssdk.services.quicksight.model.VisualInteractionOptions;
import software.amazon.awssdk.services.quicksight.model.VisualPalette;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RadarChartConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RadarChartConfiguration> {
    private static final SdkField<RadarChartFieldWells> FIELD_WELLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FieldWells").getter(RadarChartConfiguration.getter(RadarChartConfiguration::fieldWells)).setter(RadarChartConfiguration.setter(Builder::fieldWells)).constructor(RadarChartFieldWells::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldWells").build()}).build();
    private static final SdkField<RadarChartSortConfiguration> SORT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SortConfiguration").getter(RadarChartConfiguration.getter(RadarChartConfiguration::sortConfiguration)).setter(RadarChartConfiguration.setter(Builder::sortConfiguration)).constructor(RadarChartSortConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortConfiguration").build()}).build();
    private static final SdkField<String> SHAPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Shape").getter(RadarChartConfiguration.getter(RadarChartConfiguration::shapeAsString)).setter(RadarChartConfiguration.setter(Builder::shape)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Shape").build()}).build();
    private static final SdkField<RadarChartSeriesSettings> BASE_SERIES_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BaseSeriesSettings").getter(RadarChartConfiguration.getter(RadarChartConfiguration::baseSeriesSettings)).setter(RadarChartConfiguration.setter(Builder::baseSeriesSettings)).constructor(RadarChartSeriesSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseSeriesSettings").build()}).build();
    private static final SdkField<Double> START_ANGLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("StartAngle").getter(RadarChartConfiguration.getter(RadarChartConfiguration::startAngle)).setter(RadarChartConfiguration.setter(Builder::startAngle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartAngle").build()}).build();
    private static final SdkField<VisualPalette> VISUAL_PALETTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VisualPalette").getter(RadarChartConfiguration.getter(RadarChartConfiguration::visualPalette)).setter(RadarChartConfiguration.setter(Builder::visualPalette)).constructor(VisualPalette::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualPalette").build()}).build();
    private static final SdkField<String> ALTERNATE_BAND_COLORS_VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlternateBandColorsVisibility").getter(RadarChartConfiguration.getter(RadarChartConfiguration::alternateBandColorsVisibilityAsString)).setter(RadarChartConfiguration.setter(Builder::alternateBandColorsVisibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlternateBandColorsVisibility").build()}).build();
    private static final SdkField<String> ALTERNATE_BAND_EVEN_COLOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlternateBandEvenColor").getter(RadarChartConfiguration.getter(RadarChartConfiguration::alternateBandEvenColor)).setter(RadarChartConfiguration.setter(Builder::alternateBandEvenColor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlternateBandEvenColor").build()}).build();
    private static final SdkField<String> ALTERNATE_BAND_ODD_COLOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlternateBandOddColor").getter(RadarChartConfiguration.getter(RadarChartConfiguration::alternateBandOddColor)).setter(RadarChartConfiguration.setter(Builder::alternateBandOddColor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlternateBandOddColor").build()}).build();
    private static final SdkField<AxisDisplayOptions> CATEGORY_AXIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CategoryAxis").getter(RadarChartConfiguration.getter(RadarChartConfiguration::categoryAxis)).setter(RadarChartConfiguration.setter(Builder::categoryAxis)).constructor(AxisDisplayOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryAxis").build()}).build();
    private static final SdkField<ChartAxisLabelOptions> CATEGORY_LABEL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CategoryLabelOptions").getter(RadarChartConfiguration.getter(RadarChartConfiguration::categoryLabelOptions)).setter(RadarChartConfiguration.setter(Builder::categoryLabelOptions)).constructor(ChartAxisLabelOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryLabelOptions").build()}).build();
    private static final SdkField<AxisDisplayOptions> COLOR_AXIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ColorAxis").getter(RadarChartConfiguration.getter(RadarChartConfiguration::colorAxis)).setter(RadarChartConfiguration.setter(Builder::colorAxis)).constructor(AxisDisplayOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColorAxis").build()}).build();
    private static final SdkField<ChartAxisLabelOptions> COLOR_LABEL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ColorLabelOptions").getter(RadarChartConfiguration.getter(RadarChartConfiguration::colorLabelOptions)).setter(RadarChartConfiguration.setter(Builder::colorLabelOptions)).constructor(ChartAxisLabelOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColorLabelOptions").build()}).build();
    private static final SdkField<LegendOptions> LEGEND_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Legend").getter(RadarChartConfiguration.getter(RadarChartConfiguration::legend)).setter(RadarChartConfiguration.setter(Builder::legend)).constructor(LegendOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Legend").build()}).build();
    private static final SdkField<String> AXES_RANGE_SCALE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AxesRangeScale").getter(RadarChartConfiguration.getter(RadarChartConfiguration::axesRangeScaleAsString)).setter(RadarChartConfiguration.setter(Builder::axesRangeScale)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AxesRangeScale").build()}).build();
    private static final SdkField<VisualInteractionOptions> INTERACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Interactions").getter(RadarChartConfiguration.getter(RadarChartConfiguration::interactions)).setter(RadarChartConfiguration.setter(Builder::interactions)).constructor(VisualInteractionOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interactions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_WELLS_FIELD, SORT_CONFIGURATION_FIELD, SHAPE_FIELD, BASE_SERIES_SETTINGS_FIELD, START_ANGLE_FIELD, VISUAL_PALETTE_FIELD, ALTERNATE_BAND_COLORS_VISIBILITY_FIELD, ALTERNATE_BAND_EVEN_COLOR_FIELD, ALTERNATE_BAND_ODD_COLOR_FIELD, CATEGORY_AXIS_FIELD, CATEGORY_LABEL_OPTIONS_FIELD, COLOR_AXIS_FIELD, COLOR_LABEL_OPTIONS_FIELD, LEGEND_FIELD, AXES_RANGE_SCALE_FIELD, INTERACTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final RadarChartFieldWells fieldWells;
    private final RadarChartSortConfiguration sortConfiguration;
    private final String shape;
    private final RadarChartSeriesSettings baseSeriesSettings;
    private final Double startAngle;
    private final VisualPalette visualPalette;
    private final String alternateBandColorsVisibility;
    private final String alternateBandEvenColor;
    private final String alternateBandOddColor;
    private final AxisDisplayOptions categoryAxis;
    private final ChartAxisLabelOptions categoryLabelOptions;
    private final AxisDisplayOptions colorAxis;
    private final ChartAxisLabelOptions colorLabelOptions;
    private final LegendOptions legend;
    private final String axesRangeScale;
    private final VisualInteractionOptions interactions;

    private RadarChartConfiguration(BuilderImpl builder) {
        this.fieldWells = builder.fieldWells;
        this.sortConfiguration = builder.sortConfiguration;
        this.shape = builder.shape;
        this.baseSeriesSettings = builder.baseSeriesSettings;
        this.startAngle = builder.startAngle;
        this.visualPalette = builder.visualPalette;
        this.alternateBandColorsVisibility = builder.alternateBandColorsVisibility;
        this.alternateBandEvenColor = builder.alternateBandEvenColor;
        this.alternateBandOddColor = builder.alternateBandOddColor;
        this.categoryAxis = builder.categoryAxis;
        this.categoryLabelOptions = builder.categoryLabelOptions;
        this.colorAxis = builder.colorAxis;
        this.colorLabelOptions = builder.colorLabelOptions;
        this.legend = builder.legend;
        this.axesRangeScale = builder.axesRangeScale;
        this.interactions = builder.interactions;
    }

    public final RadarChartFieldWells fieldWells() {
        return this.fieldWells;
    }

    public final RadarChartSortConfiguration sortConfiguration() {
        return this.sortConfiguration;
    }

    public final RadarChartShape shape() {
        return RadarChartShape.fromValue(this.shape);
    }

    public final String shapeAsString() {
        return this.shape;
    }

    public final RadarChartSeriesSettings baseSeriesSettings() {
        return this.baseSeriesSettings;
    }

    public final Double startAngle() {
        return this.startAngle;
    }

    public final VisualPalette visualPalette() {
        return this.visualPalette;
    }

    public final Visibility alternateBandColorsVisibility() {
        return Visibility.fromValue(this.alternateBandColorsVisibility);
    }

    public final String alternateBandColorsVisibilityAsString() {
        return this.alternateBandColorsVisibility;
    }

    public final String alternateBandEvenColor() {
        return this.alternateBandEvenColor;
    }

    public final String alternateBandOddColor() {
        return this.alternateBandOddColor;
    }

    public final AxisDisplayOptions categoryAxis() {
        return this.categoryAxis;
    }

    public final ChartAxisLabelOptions categoryLabelOptions() {
        return this.categoryLabelOptions;
    }

    public final AxisDisplayOptions colorAxis() {
        return this.colorAxis;
    }

    public final ChartAxisLabelOptions colorLabelOptions() {
        return this.colorLabelOptions;
    }

    public final LegendOptions legend() {
        return this.legend;
    }

    public final RadarChartAxesRangeScale axesRangeScale() {
        return RadarChartAxesRangeScale.fromValue(this.axesRangeScale);
    }

    public final String axesRangeScaleAsString() {
        return this.axesRangeScale;
    }

    public final VisualInteractionOptions interactions() {
        return this.interactions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldWells());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.shapeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseSeriesSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.startAngle());
        hashCode = 31 * hashCode + Objects.hashCode(this.visualPalette());
        hashCode = 31 * hashCode + Objects.hashCode(this.alternateBandColorsVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.alternateBandEvenColor());
        hashCode = 31 * hashCode + Objects.hashCode(this.alternateBandOddColor());
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryAxis());
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.colorAxis());
        hashCode = 31 * hashCode + Objects.hashCode(this.colorLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.legend());
        hashCode = 31 * hashCode + Objects.hashCode(this.axesRangeScaleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.interactions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RadarChartConfiguration)) {
            return false;
        }
        RadarChartConfiguration other = (RadarChartConfiguration)obj;
        return Objects.equals(this.fieldWells(), other.fieldWells()) && Objects.equals(this.sortConfiguration(), other.sortConfiguration()) && Objects.equals(this.shapeAsString(), other.shapeAsString()) && Objects.equals(this.baseSeriesSettings(), other.baseSeriesSettings()) && Objects.equals(this.startAngle(), other.startAngle()) && Objects.equals(this.visualPalette(), other.visualPalette()) && Objects.equals(this.alternateBandColorsVisibilityAsString(), other.alternateBandColorsVisibilityAsString()) && Objects.equals(this.alternateBandEvenColor(), other.alternateBandEvenColor()) && Objects.equals(this.alternateBandOddColor(), other.alternateBandOddColor()) && Objects.equals(this.categoryAxis(), other.categoryAxis()) && Objects.equals(this.categoryLabelOptions(), other.categoryLabelOptions()) && Objects.equals(this.colorAxis(), other.colorAxis()) && Objects.equals(this.colorLabelOptions(), other.colorLabelOptions()) && Objects.equals(this.legend(), other.legend()) && Objects.equals(this.axesRangeScaleAsString(), other.axesRangeScaleAsString()) && Objects.equals(this.interactions(), other.interactions());
    }

    public final String toString() {
        return ToString.builder((String)"RadarChartConfiguration").add("FieldWells", (Object)this.fieldWells()).add("SortConfiguration", (Object)this.sortConfiguration()).add("Shape", (Object)this.shapeAsString()).add("BaseSeriesSettings", (Object)this.baseSeriesSettings()).add("StartAngle", (Object)this.startAngle()).add("VisualPalette", (Object)this.visualPalette()).add("AlternateBandColorsVisibility", (Object)this.alternateBandColorsVisibilityAsString()).add("AlternateBandEvenColor", (Object)this.alternateBandEvenColor()).add("AlternateBandOddColor", (Object)this.alternateBandOddColor()).add("CategoryAxis", (Object)this.categoryAxis()).add("CategoryLabelOptions", (Object)this.categoryLabelOptions()).add("ColorAxis", (Object)this.colorAxis()).add("ColorLabelOptions", (Object)this.colorLabelOptions()).add("Legend", (Object)this.legend()).add("AxesRangeScale", (Object)this.axesRangeScaleAsString()).add("Interactions", (Object)this.interactions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FieldWells": {
                return Optional.ofNullable(clazz.cast(this.fieldWells()));
            }
            case "SortConfiguration": {
                return Optional.ofNullable(clazz.cast(this.sortConfiguration()));
            }
            case "Shape": {
                return Optional.ofNullable(clazz.cast(this.shapeAsString()));
            }
            case "BaseSeriesSettings": {
                return Optional.ofNullable(clazz.cast(this.baseSeriesSettings()));
            }
            case "StartAngle": {
                return Optional.ofNullable(clazz.cast(this.startAngle()));
            }
            case "VisualPalette": {
                return Optional.ofNullable(clazz.cast(this.visualPalette()));
            }
            case "AlternateBandColorsVisibility": {
                return Optional.ofNullable(clazz.cast(this.alternateBandColorsVisibilityAsString()));
            }
            case "AlternateBandEvenColor": {
                return Optional.ofNullable(clazz.cast(this.alternateBandEvenColor()));
            }
            case "AlternateBandOddColor": {
                return Optional.ofNullable(clazz.cast(this.alternateBandOddColor()));
            }
            case "CategoryAxis": {
                return Optional.ofNullable(clazz.cast(this.categoryAxis()));
            }
            case "CategoryLabelOptions": {
                return Optional.ofNullable(clazz.cast(this.categoryLabelOptions()));
            }
            case "ColorAxis": {
                return Optional.ofNullable(clazz.cast(this.colorAxis()));
            }
            case "ColorLabelOptions": {
                return Optional.ofNullable(clazz.cast(this.colorLabelOptions()));
            }
            case "Legend": {
                return Optional.ofNullable(clazz.cast(this.legend()));
            }
            case "AxesRangeScale": {
                return Optional.ofNullable(clazz.cast(this.axesRangeScaleAsString()));
            }
            case "Interactions": {
                return Optional.ofNullable(clazz.cast(this.interactions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RadarChartConfiguration, T> g) {
        return obj -> g.apply((RadarChartConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private RadarChartFieldWells fieldWells;
        private RadarChartSortConfiguration sortConfiguration;
        private String shape;
        private RadarChartSeriesSettings baseSeriesSettings;
        private Double startAngle;
        private VisualPalette visualPalette;
        private String alternateBandColorsVisibility;
        private String alternateBandEvenColor;
        private String alternateBandOddColor;
        private AxisDisplayOptions categoryAxis;
        private ChartAxisLabelOptions categoryLabelOptions;
        private AxisDisplayOptions colorAxis;
        private ChartAxisLabelOptions colorLabelOptions;
        private LegendOptions legend;
        private String axesRangeScale;
        private VisualInteractionOptions interactions;

        private BuilderImpl() {
        }

        private BuilderImpl(RadarChartConfiguration model) {
            this.fieldWells(model.fieldWells);
            this.sortConfiguration(model.sortConfiguration);
            this.shape(model.shape);
            this.baseSeriesSettings(model.baseSeriesSettings);
            this.startAngle(model.startAngle);
            this.visualPalette(model.visualPalette);
            this.alternateBandColorsVisibility(model.alternateBandColorsVisibility);
            this.alternateBandEvenColor(model.alternateBandEvenColor);
            this.alternateBandOddColor(model.alternateBandOddColor);
            this.categoryAxis(model.categoryAxis);
            this.categoryLabelOptions(model.categoryLabelOptions);
            this.colorAxis(model.colorAxis);
            this.colorLabelOptions(model.colorLabelOptions);
            this.legend(model.legend);
            this.axesRangeScale(model.axesRangeScale);
            this.interactions(model.interactions);
        }

        public final RadarChartFieldWells.Builder getFieldWells() {
            return this.fieldWells != null ? this.fieldWells.toBuilder() : null;
        }

        public final void setFieldWells(RadarChartFieldWells.BuilderImpl fieldWells) {
            this.fieldWells = fieldWells != null ? fieldWells.build() : null;
        }

        @Override
        public final Builder fieldWells(RadarChartFieldWells fieldWells) {
            this.fieldWells = fieldWells;
            return this;
        }

        public final RadarChartSortConfiguration.Builder getSortConfiguration() {
            return this.sortConfiguration != null ? this.sortConfiguration.toBuilder() : null;
        }

        public final void setSortConfiguration(RadarChartSortConfiguration.BuilderImpl sortConfiguration) {
            this.sortConfiguration = sortConfiguration != null ? sortConfiguration.build() : null;
        }

        @Override
        public final Builder sortConfiguration(RadarChartSortConfiguration sortConfiguration) {
            this.sortConfiguration = sortConfiguration;
            return this;
        }

        public final String getShape() {
            return this.shape;
        }

        public final void setShape(String shape) {
            this.shape = shape;
        }

        @Override
        public final Builder shape(String shape) {
            this.shape = shape;
            return this;
        }

        @Override
        public final Builder shape(RadarChartShape shape) {
            this.shape(shape == null ? null : shape.toString());
            return this;
        }

        public final RadarChartSeriesSettings.Builder getBaseSeriesSettings() {
            return this.baseSeriesSettings != null ? this.baseSeriesSettings.toBuilder() : null;
        }

        public final void setBaseSeriesSettings(RadarChartSeriesSettings.BuilderImpl baseSeriesSettings) {
            this.baseSeriesSettings = baseSeriesSettings != null ? baseSeriesSettings.build() : null;
        }

        @Override
        public final Builder baseSeriesSettings(RadarChartSeriesSettings baseSeriesSettings) {
            this.baseSeriesSettings = baseSeriesSettings;
            return this;
        }

        public final Double getStartAngle() {
            return this.startAngle;
        }

        public final void setStartAngle(Double startAngle) {
            this.startAngle = startAngle;
        }

        @Override
        public final Builder startAngle(Double startAngle) {
            this.startAngle = startAngle;
            return this;
        }

        public final VisualPalette.Builder getVisualPalette() {
            return this.visualPalette != null ? this.visualPalette.toBuilder() : null;
        }

        public final void setVisualPalette(VisualPalette.BuilderImpl visualPalette) {
            this.visualPalette = visualPalette != null ? visualPalette.build() : null;
        }

        @Override
        public final Builder visualPalette(VisualPalette visualPalette) {
            this.visualPalette = visualPalette;
            return this;
        }

        public final String getAlternateBandColorsVisibility() {
            return this.alternateBandColorsVisibility;
        }

        public final void setAlternateBandColorsVisibility(String alternateBandColorsVisibility) {
            this.alternateBandColorsVisibility = alternateBandColorsVisibility;
        }

        @Override
        public final Builder alternateBandColorsVisibility(String alternateBandColorsVisibility) {
            this.alternateBandColorsVisibility = alternateBandColorsVisibility;
            return this;
        }

        @Override
        public final Builder alternateBandColorsVisibility(Visibility alternateBandColorsVisibility) {
            this.alternateBandColorsVisibility(alternateBandColorsVisibility == null ? null : alternateBandColorsVisibility.toString());
            return this;
        }

        public final String getAlternateBandEvenColor() {
            return this.alternateBandEvenColor;
        }

        public final void setAlternateBandEvenColor(String alternateBandEvenColor) {
            this.alternateBandEvenColor = alternateBandEvenColor;
        }

        @Override
        public final Builder alternateBandEvenColor(String alternateBandEvenColor) {
            this.alternateBandEvenColor = alternateBandEvenColor;
            return this;
        }

        public final String getAlternateBandOddColor() {
            return this.alternateBandOddColor;
        }

        public final void setAlternateBandOddColor(String alternateBandOddColor) {
            this.alternateBandOddColor = alternateBandOddColor;
        }

        @Override
        public final Builder alternateBandOddColor(String alternateBandOddColor) {
            this.alternateBandOddColor = alternateBandOddColor;
            return this;
        }

        public final AxisDisplayOptions.Builder getCategoryAxis() {
            return this.categoryAxis != null ? this.categoryAxis.toBuilder() : null;
        }

        public final void setCategoryAxis(AxisDisplayOptions.BuilderImpl categoryAxis) {
            this.categoryAxis = categoryAxis != null ? categoryAxis.build() : null;
        }

        @Override
        public final Builder categoryAxis(AxisDisplayOptions categoryAxis) {
            this.categoryAxis = categoryAxis;
            return this;
        }

        public final ChartAxisLabelOptions.Builder getCategoryLabelOptions() {
            return this.categoryLabelOptions != null ? this.categoryLabelOptions.toBuilder() : null;
        }

        public final void setCategoryLabelOptions(ChartAxisLabelOptions.BuilderImpl categoryLabelOptions) {
            this.categoryLabelOptions = categoryLabelOptions != null ? categoryLabelOptions.build() : null;
        }

        @Override
        public final Builder categoryLabelOptions(ChartAxisLabelOptions categoryLabelOptions) {
            this.categoryLabelOptions = categoryLabelOptions;
            return this;
        }

        public final AxisDisplayOptions.Builder getColorAxis() {
            return this.colorAxis != null ? this.colorAxis.toBuilder() : null;
        }

        public final void setColorAxis(AxisDisplayOptions.BuilderImpl colorAxis) {
            this.colorAxis = colorAxis != null ? colorAxis.build() : null;
        }

        @Override
        public final Builder colorAxis(AxisDisplayOptions colorAxis) {
            this.colorAxis = colorAxis;
            return this;
        }

        public final ChartAxisLabelOptions.Builder getColorLabelOptions() {
            return this.colorLabelOptions != null ? this.colorLabelOptions.toBuilder() : null;
        }

        public final void setColorLabelOptions(ChartAxisLabelOptions.BuilderImpl colorLabelOptions) {
            this.colorLabelOptions = colorLabelOptions != null ? colorLabelOptions.build() : null;
        }

        @Override
        public final Builder colorLabelOptions(ChartAxisLabelOptions colorLabelOptions) {
            this.colorLabelOptions = colorLabelOptions;
            return this;
        }

        public final LegendOptions.Builder getLegend() {
            return this.legend != null ? this.legend.toBuilder() : null;
        }

        public final void setLegend(LegendOptions.BuilderImpl legend) {
            this.legend = legend != null ? legend.build() : null;
        }

        @Override
        public final Builder legend(LegendOptions legend) {
            this.legend = legend;
            return this;
        }

        public final String getAxesRangeScale() {
            return this.axesRangeScale;
        }

        public final void setAxesRangeScale(String axesRangeScale) {
            this.axesRangeScale = axesRangeScale;
        }

        @Override
        public final Builder axesRangeScale(String axesRangeScale) {
            this.axesRangeScale = axesRangeScale;
            return this;
        }

        @Override
        public final Builder axesRangeScale(RadarChartAxesRangeScale axesRangeScale) {
            this.axesRangeScale(axesRangeScale == null ? null : axesRangeScale.toString());
            return this;
        }

        public final VisualInteractionOptions.Builder getInteractions() {
            return this.interactions != null ? this.interactions.toBuilder() : null;
        }

        public final void setInteractions(VisualInteractionOptions.BuilderImpl interactions) {
            this.interactions = interactions != null ? interactions.build() : null;
        }

        @Override
        public final Builder interactions(VisualInteractionOptions interactions) {
            this.interactions = interactions;
            return this;
        }

        public RadarChartConfiguration build() {
            return new RadarChartConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RadarChartConfiguration> {
        public Builder fieldWells(RadarChartFieldWells var1);

        default public Builder fieldWells(Consumer<RadarChartFieldWells.Builder> fieldWells) {
            return this.fieldWells((RadarChartFieldWells)((RadarChartFieldWells.Builder)RadarChartFieldWells.builder().applyMutation(fieldWells)).build());
        }

        public Builder sortConfiguration(RadarChartSortConfiguration var1);

        default public Builder sortConfiguration(Consumer<RadarChartSortConfiguration.Builder> sortConfiguration) {
            return this.sortConfiguration((RadarChartSortConfiguration)((RadarChartSortConfiguration.Builder)RadarChartSortConfiguration.builder().applyMutation(sortConfiguration)).build());
        }

        public Builder shape(String var1);

        public Builder shape(RadarChartShape var1);

        public Builder baseSeriesSettings(RadarChartSeriesSettings var1);

        default public Builder baseSeriesSettings(Consumer<RadarChartSeriesSettings.Builder> baseSeriesSettings) {
            return this.baseSeriesSettings((RadarChartSeriesSettings)((RadarChartSeriesSettings.Builder)RadarChartSeriesSettings.builder().applyMutation(baseSeriesSettings)).build());
        }

        public Builder startAngle(Double var1);

        public Builder visualPalette(VisualPalette var1);

        default public Builder visualPalette(Consumer<VisualPalette.Builder> visualPalette) {
            return this.visualPalette((VisualPalette)((VisualPalette.Builder)VisualPalette.builder().applyMutation(visualPalette)).build());
        }

        public Builder alternateBandColorsVisibility(String var1);

        public Builder alternateBandColorsVisibility(Visibility var1);

        public Builder alternateBandEvenColor(String var1);

        public Builder alternateBandOddColor(String var1);

        public Builder categoryAxis(AxisDisplayOptions var1);

        default public Builder categoryAxis(Consumer<AxisDisplayOptions.Builder> categoryAxis) {
            return this.categoryAxis((AxisDisplayOptions)((AxisDisplayOptions.Builder)AxisDisplayOptions.builder().applyMutation(categoryAxis)).build());
        }

        public Builder categoryLabelOptions(ChartAxisLabelOptions var1);

        default public Builder categoryLabelOptions(Consumer<ChartAxisLabelOptions.Builder> categoryLabelOptions) {
            return this.categoryLabelOptions((ChartAxisLabelOptions)((ChartAxisLabelOptions.Builder)ChartAxisLabelOptions.builder().applyMutation(categoryLabelOptions)).build());
        }

        public Builder colorAxis(AxisDisplayOptions var1);

        default public Builder colorAxis(Consumer<AxisDisplayOptions.Builder> colorAxis) {
            return this.colorAxis((AxisDisplayOptions)((AxisDisplayOptions.Builder)AxisDisplayOptions.builder().applyMutation(colorAxis)).build());
        }

        public Builder colorLabelOptions(ChartAxisLabelOptions var1);

        default public Builder colorLabelOptions(Consumer<ChartAxisLabelOptions.Builder> colorLabelOptions) {
            return this.colorLabelOptions((ChartAxisLabelOptions)((ChartAxisLabelOptions.Builder)ChartAxisLabelOptions.builder().applyMutation(colorLabelOptions)).build());
        }

        public Builder legend(LegendOptions var1);

        default public Builder legend(Consumer<LegendOptions.Builder> legend) {
            return this.legend((LegendOptions)((LegendOptions.Builder)LegendOptions.builder().applyMutation(legend)).build());
        }

        public Builder axesRangeScale(String var1);

        public Builder axesRangeScale(RadarChartAxesRangeScale var1);

        public Builder interactions(VisualInteractionOptions var1);

        default public Builder interactions(Consumer<VisualInteractionOptions.Builder> interactions) {
            return this.interactions((VisualInteractionOptions)((VisualInteractionOptions.Builder)VisualInteractionOptions.builder().applyMutation(interactions)).build());
        }
    }
}

